/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.ProxyHelper;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;
    private final SecuredLogger securedLogger;
    private final Proxy proxy;
    private final InetSocketAddress serverAddress;
    private volatile boolean isTimeoutExpired = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    private TimeoutSocketChannel(InetSocketAddress inetSocketAddress, NetStatImpl netStatImpl, Proxy proxy, SecuredLogger securedLogger) {
        super((SocketChannel)null);
        this.serverAddress = inetSocketAddress;
        this.securedLogger = securedLogger;
        this.netStat = netStatImpl;
        this.proxy = proxy;
    }

    public TimeoutSocketChannel(InetSocketAddress inetSocketAddress, int n2, NetStatImpl netStatImpl, Proxy proxy, SecuredLogger securedLogger) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this(inetSocketAddress, netStatImpl, proxy, securedLogger);
        this.connect(inetSocketAddress, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(InetSocketAddress inetSocketAddress, int n2) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this.scheduleInterrupt(n2, false);
        try {
            if (this.proxy == null) {
                this.socketChannel = SocketChannel.open(inetSocketAddress);
            } else {
                this.socketChannel = SocketChannel.open(this.proxy.address());
                ProxyHelper.connectViaProxy(this.proxy, this.serverAddress, this.socketChannel);
            }
            this.socketChannel.configureBlocking(true);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
    }

    static CompletionStage<TimeoutSocketChannel> openAsync(InetSocketAddress inetSocketAddress, int n2, NetStatImpl netStatImpl, SecuredLogger securedLogger, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        TimeoutSocketChannel timeoutSocketChannel = new TimeoutSocketChannel(inetSocketAddress, netStatImpl, null, securedLogger);
        return timeoutSocketChannel.connectAsync(n2, asyncOutboundTimeoutHandler, executor).thenApply(void_ -> timeoutSocketChannel);
    }

    private final CompletionStage<Void> connectAsync(int n2, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        Object object;
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous proxy connection is not supported"));
        }
        try {
            object = SocketChannel.open();
            asyncOutboundTimeoutHandler.setChannel((SocketChannel)object);
            this.socketChannel = object;
            this.socketChannel.configureBlocking(false);
            if (this.socketChannel.connect(this.serverAddress)) {
                this.socketChannel.configureBlocking(true);
                return CompletionStageUtil.completedStage(null);
            }
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
        object = new AsyncConnectTask(executor);
        ((AsyncConnectTask)object).start();
        CompletionStage<Void> completionStage = ((AsyncConnectTask)object).getConnectStage();
        if (n2 > 0) {
            TimerTask timerTask = TimeoutInterruptHandler.scheduleTask(() -> TimeoutSocketChannel.lambda$connectAsync$1((AsyncConnectTask)object), n2);
            return completionStage.whenComplete((void_, throwable) -> timerTask.cancel());
        }
        return completionStage;
    }

    void setNetStat(NetStatImpl netStatImpl) {
        this.netStat = netStatImpl;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), true);
        int n2 = -1;
        try {
            n2 = this.socketChannel.read(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesReceived(n2);
            }
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return n2;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), false);
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int n2 = this.socketChannel.write(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    private void scheduleInterrupt(int n2, boolean bl) {
        if (n2 > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread(), this, bl);
        }
    }

    private final void interruptNow(boolean bl) {
        this.interruptTask = bl ? new TimeoutInterruptHandler.InterruptTask(Thread.currentThread(), Integer.MAX_VALUE, this) : new TimeoutInterruptHandler.InterruptTask(Thread.currentThread(), Integer.MAX_VALUE, null);
        this.interruptTask.run();
    }

    private void handleInterrupt() throws InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
        }
        throw new InterruptedIOException("Socket read interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    @Override
    final void registerForNonBlockingRead(Consumer<Throwable> consumer) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            TimerTask timerTask = this.scheduleRegistrationCancel(socketChannel, this.soTimeout, atomicBoolean);
            try {
                TcpMultiplexer.registerForReadEvent(socketChannel, throwable -> {
                    timerTask.cancel();
                    consumer.accept((Throwable)throwable);
                });
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                timerTask.cancel();
                throw iOException;
            }
        } else {
            TcpMultiplexer.registerForReadEvent(socketChannel, consumer);
        }
    }

    @Override
    final void registerForNonBlockingWrite(Consumer<Throwable> consumer) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            TimerTask timerTask = this.scheduleRegistrationCancel(socketChannel, this.soTimeout, atomicBoolean);
            try {
                TcpMultiplexer.registerForWriteEvent(socketChannel, throwable -> {
                    timerTask.cancel();
                    consumer.accept((Throwable)throwable);
                });
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                timerTask.cancel();
                throw iOException;
            }
        } else {
            TcpMultiplexer.registerForWriteEvent(socketChannel, consumer);
        }
    }

    private TimerTask scheduleRegistrationCancel(SocketChannel socketChannel, int n2, AtomicBoolean atomicBoolean) {
        return TimeoutInterruptHandler.scheduleTask(() -> {
            while (!atomicBoolean.get() && !Thread.currentThread().isInterrupted()) {
            }
            this.isTimeoutExpired = true;
            TcpMultiplexer.cancelRegistration(socketChannel, null);
        }, n2);
    }

    private static /* synthetic */ void lambda$connectAsync$1(AsyncConnectTask asyncConnectTask) {
        asyncConnectTask.setTimeoutExpired();
    }

    static {
        try {
            $$$methodRef$$$26 = TimeoutSocketChannel.class.getDeclaredConstructor(InetSocketAddress.class, Integer.TYPE, NetStatImpl.class, Proxy.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = TimeoutSocketChannel.class.getDeclaredConstructor(InetSocketAddress.class, NetStatImpl.class, Proxy.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$openAsync$0", TimeoutSocketChannel.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$connectAsync$1", AsyncConnectTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$connectAsync$2", TimerTask.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$registerForNonBlockingRead$3", TimerTask.class, Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$registerForNonBlockingWrite$4", TimerTask.class, Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$scheduleRegistrationCancel$5", AtomicBoolean.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TimeoutSocketChannel.class.getDeclaredMethod("scheduleRegistrationCancel", SocketChannel.class, Integer.TYPE, AtomicBoolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TimeoutSocketChannel.class.getDeclaredMethod("registerForNonBlockingWrite", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TimeoutSocketChannel.class.getDeclaredMethod("registerForNonBlockingRead", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TimeoutSocketChannel.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimeoutSocketChannel.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimeoutSocketChannel.class.getDeclaredMethod("handleInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimeoutSocketChannel.class.getDeclaredMethod("interruptNow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimeoutSocketChannel.class.getDeclaredMethod("scheduleInterrupt", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimeoutSocketChannel.class.getDeclaredMethod("getSoTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimeoutSocketChannel.class.getDeclaredMethod("setSoTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimeoutSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimeoutSocketChannel.class.getDeclaredMethod("setNetStat", NetStatImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeoutSocketChannel.class.getDeclaredMethod("connectAsync", Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeoutSocketChannel.class.getDeclaredMethod("openAsync", InetSocketAddress.class, Integer.TYPE, NetStatImpl.class, SecuredLogger.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeoutSocketChannel.class.getDeclaredMethod("connect", InetSocketAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private class AsyncConnectTask
    implements Consumer<Throwable> {
        private final Executor asyncExecutor;
        private final Monitor cancellationLock = Monitor.newInstance();
        private final CompletableFuture<Void> connectFuture = new CompletableFuture();
        private boolean isTimeoutExpired = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        private AsyncConnectTask(Executor executor) {
            this.asyncExecutor = executor;
        }

        private void start() {
            try {
                TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
            }
            catch (IOException iOException) {
                this.connectFuture.completeExceptionally(iOException);
            }
        }

        @Override
        public void accept(Throwable throwable) {
            this.asyncExecutor.execute(() -> this.handleReadiness(throwable));
        }

        private final void handleReadiness(Throwable throwable) {
            try (Monitor.CloseableLock closeableLock = this.cancellationLock.acquireCloseableLock();){
                if (throwable != null) {
                    this.connectFuture.completeExceptionally(throwable);
                } else if (!this.isTimeoutExpired) {
                    TimeoutSocketChannel.this.socketChannel.configureBlocking(false);
                    if (TimeoutSocketChannel.this.socketChannel.finishConnect()) {
                        TimeoutSocketChannel.this.socketChannel.configureBlocking(true);
                        this.connectFuture.complete(null);
                    } else {
                        TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
                    }
                }
            }
            catch (IOException iOException) {
                this.connectFuture.completeExceptionally(iOException);
            }
        }

        private final void setTimeoutExpired() {
            this.isTimeoutExpired = true;
            try (Monitor.CloseableLock closeableLock = this.cancellationLock.acquireCloseableLock();){
                TimeoutInterruptHandler.IOReadTimeoutException iOReadTimeoutException = new TimeoutInterruptHandler.IOReadTimeoutException("Socket connect timed out");
                this.asyncExecutor.execute(() -> this.connectFuture.completeExceptionally(iOReadTimeoutException));
                try {
                    TcpMultiplexer.cancelRegistration(TimeoutSocketChannel.this.socketChannel, iOReadTimeoutException);
                    TimeoutSocketChannel.this.socketChannel.close();
                }
                catch (IOException iOException) {
                    this.connectFuture.completeExceptionally(iOReadTimeoutException);
                }
            }
        }

        private final CompletionStage<Void> getConnectStage() {
            return this.connectFuture;
        }

        static {
            try {
                $$$methodRef$$$8 = AsyncConnectTask.class.getDeclaredConstructor(TimeoutSocketChannel.class, Executor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = AsyncConnectTask.class.getDeclaredMethod("lambda$accept$0", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = AsyncConnectTask.class.getDeclaredMethod("lambda$setTimeoutExpired$1", TimeoutInterruptHandler.IOReadTimeoutException.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = AsyncConnectTask.class.getDeclaredMethod("accept", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = AsyncConnectTask.class.getDeclaredMethod("getConnectStage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = AsyncConnectTask.class.getDeclaredMethod("setTimeoutExpired", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = AsyncConnectTask.class.getDeclaredMethod("handleReadiness", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AsyncConnectTask.class.getDeclaredMethod("accept", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AsyncConnectTask.class.getDeclaredMethod("start", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

