/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    int sqlParserParamCount;
    String[] sqlParserParamList;
    boolean useNamedParameter;
    int current_argument;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    static final char QMARK = '?';
    int[] returnTypes;
    Accessor[] returnAccessors;
    private static final ThreadLocal<OracleSql> SQL_PARSER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    AutoKeyInfo(String string) {
        this.originalSql = string;
        this.autoKeyType = 0;
    }

    AutoKeyInfo(String string, String[] stringArray) {
        this.originalSql = string;
        this.columnNames = stringArray;
        this.autoKeyType = 1;
    }

    AutoKeyInfo(String string, int[] nArray) {
        this.originalSql = string;
        this.columnIndexes = nArray;
        this.autoKeyType = 2;
    }

    private void parseSql() throws SQLException {
        if (this.originalSql == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        OracleSql oracleSql = SQL_PARSER.get();
        oracleSql.initialize(this.originalSql);
        this.sqlKind = oracleSql.getSqlKind();
        if (this.sqlKind == OracleStatement.SqlKind.INSERT) {
            this.sqlParserParamCount = oracleSql.getParameterCount();
            this.sqlParserParamList = oracleSql.getParameterList();
            if (this.sqlParserParamList == OracleSql.EMPTY_LIST) {
                this.useNamedParameter = false;
            } else {
                this.useNamedParameter = true;
                this.current_argument = this.sqlParserParamCount;
            }
        }
    }

    private String generateUniqueNamedParameter() {
        String string;
        boolean bl;
        block0: do {
            bl = false;
            string = Integer.toString(++this.current_argument).intern();
            for (int i2 = 0; i2 < this.sqlParserParamCount; ++i2) {
                if (this.sqlParserParamList[i2] != string) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        return ":" + string;
    }

    String getNewSql() throws SQLException {
        try {
            if (this.newSql != null) {
                return this.newSql;
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.parseSql();
            }
            switch (this.autoKeyType) {
                case 0: {
                    this.newSql = this.originalSql + " RETURNING ROWID INTO " + (Serializable)(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
                    this.returnTypes = new int[1];
                    this.returnTypes[0] = 104;
                    break;
                }
                case 1: {
                    this.getNewSqlByColumnName();
                    break;
                }
                case 2: {
                    this.getNewSqlByColumnIndexes();
                }
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.sqlParserParamList = null;
            return this.newSql;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exception).fillInStackTrace();
        }
    }

    private String getNewSqlByColumnName() throws SQLException {
        int n2;
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        for (n2 = 0; n2 < this.columnNames.length; ++n2) {
            int n3;
            this.returnTypes[n2] = n3 = this.getReturnParamTypeCode(n2, this.columnNames[n2], this.columnIndexes);
            stringBuffer.append(this.columnNames[n2]);
            if (n2 >= this.columnNames.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" INTO ");
        for (n2 = 0; n2 < this.columnNames.length - 1; ++n2) {
            stringBuffer.append((Serializable)(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
        }
        stringBuffer.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private String getNewSqlByColumnIndexes() throws SQLException {
        int n2;
        this.returnTypes = new int[this.columnIndexes.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        for (n2 = 0; n2 < this.columnIndexes.length; ++n2) {
            int n3 = this.columnIndexes[n2] - 1;
            if (n3 < 0 || n3 > this.tableColumnNames.length) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null, DatabaseError.createSqlException(3, Integer.toString(n3)).fillInStackTrace()).fillInStackTrace();
            }
            int n4 = this.tableColumnTypes[n3];
            String string = this.tableColumnNames[n3];
            this.returnTypes[n2] = n4;
            stringBuffer.append(string.contains(" ") ? String.format("\"%s\"", string) : string);
            if (n2 >= this.columnIndexes.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" INTO ");
        for (n2 = 0; n2 < this.columnIndexes.length - 1; ++n2) {
            stringBuffer.append((Serializable)(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
        }
        stringBuffer.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    private final int getReturnParamTypeCode(int n2, String string, int[] nArray) throws SQLException {
        string = string.replace("\"", "");
        for (int i2 = 0; i2 < this.tableColumnNames.length; ++i2) {
            if (!string.equalsIgnoreCase(this.tableColumnNames[i2])) continue;
            nArray[n2] = i2 + 1;
            return this.tableColumnTypes[i2];
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null, DatabaseError.createSqlException(6, string).fillInStackTrace()).fillInStackTrace();
    }

    final boolean isInsertSqlStmt() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind == OracleStatement.SqlKind.INSERT;
    }

    final boolean isUpdateSqlStmt() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind == OracleStatement.SqlKind.UPDATE;
    }

    final boolean isInsertOrUpdateSqlStmt() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind == OracleStatement.SqlKind.INSERT || this.sqlKind == OracleStatement.SqlKind.UPDATE;
    }

    String getTableName() throws SQLException {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.isUpdateSqlStmt()) {
            return this.getTableNameForUpdateStmt(this.originalSql);
        }
        if (this.isInsertSqlStmt()) {
            return this.getTableNameForInsertStmt(this.originalSql);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
    }

    private String getTableNameForInsertStmt(String string) throws SQLException {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        int n2 = string3.indexOf("INSERT");
        if ((n2 = string3.indexOf("INTO", n2)) < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String string4 = string2.substring(n2 + 5).trim();
        this.tableName = this.extractTablename(string4);
        return this.tableName;
    }

    private String getTableNameForUpdateStmt(String string) throws SQLException {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        int n2 = string3.indexOf("UPDATE");
        if (n2 != 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String string4 = string2.substring(6).trim();
        this.tableName = this.extractTablename(string4);
        return this.tableName;
    }

    private String extractTablename(String string) throws SQLException {
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 >= n3) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        int n4 = 0;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        do {
            if (string.charAt(n2) == '.') {
                if (string2 != null) {
                    ++n2;
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
            }
            if (string.charAt(n2) == '\"') {
                n4 = n2 + 1;
                if (n2 >= (n4 = string.indexOf(34, n4) + 1) - 2) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                if (string2 == null) {
                    string2 = string.substring(n2, n4);
                    n2 = n4;
                    if (string.charAt(n2) == '.') continue;
                    bl = true;
                    continue;
                }
                string3 = string.substring(n2, n4);
                bl = true;
                continue;
            }
            for (n4 = n2; n4 < n3 && string.charAt(n4) != ' ' && string.charAt(n4) != '(' && string.charAt(n4) != '.'; ++n4) {
            }
            if (n2 >= n4) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            if (string2 == null) {
                string2 = string.substring(n2, n4);
                n2 = n4;
                if (string.charAt(n2) == '.') continue;
                bl = true;
                continue;
            }
            string3 = string.substring(n2, n4);
            bl = true;
        } while (!bl);
        if (string3 == null) {
            return string2;
        }
        return string2 + "." + string3;
    }

    void allocateSpaceForDescribedData(int n2) throws SQLException {
        this.numColumns = n2;
        this.tableColumnNames = new String[n2];
        this.tableColumnTypes = new int[n2];
        this.tableMaxLengths = new int[n2];
        this.tableNullables = new boolean[n2];
        this.tableFormOfUses = new short[n2];
        this.tablePrecisions = new int[n2];
        this.tableScales = new int[n2];
        this.tableTypeNames = new String[n2];
    }

    void fillDescribedData(int n2, String string, int n3, int n4, boolean bl, short s2, int n5, int n6, String string2) throws SQLException {
        this.tableColumnNames[n2] = string;
        this.tableColumnTypes[n2] = n3;
        this.tableMaxLengths[n2] = n4;
        this.tableNullables[n2] = bl;
        this.tableFormOfUses[n2] = s2;
        this.tablePrecisions[n2] = n5;
        this.tableScales[n2] = n6;
        this.tableTypeNames[n2] = string2;
    }

    void initMetaData(OracleResultSet oracleResultSet) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        int n2 = oracleResultSet.getOracleStatement().numReturnParams;
        if (n2 == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.returnAccessors = new Accessor[n2];
        Accessor[] accessorArray = oracleResultSet.getOracleStatement().accessors;
        int n3 = oracleResultSet.getOracleStatement().numberOfBindPositions;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            Accessor accessor = accessorArray[i2];
            if (accessor == null) continue;
            this.returnAccessors[n4++] = accessor;
        }
        switch (this.autoKeyType) {
            case 0: {
                this.initMetaDataKeyFlag();
                break;
            }
            case 1: 
            case 2: {
                this.initMetaDataColumnIndexes();
            }
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    void initMetaDataColumnIndexes() throws SQLException {
        for (int i2 = 0; i2 < this.returnAccessors.length; ++i2) {
            Accessor accessor = this.returnAccessors[i2];
            int n2 = this.columnIndexes[i2] - 1;
            accessor.columnName = this.tableColumnNames[n2];
            accessor.describeType = this.tableColumnTypes[n2];
            accessor.describeMaxLength = this.tableMaxLengths[n2];
            accessor.nullable = this.tableNullables[n2];
            accessor.precision = this.tablePrecisions[n2];
            accessor.scale = this.tablePrecisions[n2];
            accessor.formOfUse = this.tableFormOfUses[n2];
        }
    }

    @Override
    int getValidColumnIndex(int n2) throws SQLException {
        this.checkColumnIndex(n2);
        return n2 - 1;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        this.checkColumnIndex(n2);
        return this.returnAccessors[n2 - 1].columnName;
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        this.checkColumnIndex(n2);
        return this.getTableName();
    }

    @Override
    Accessor[] getDescription() throws SQLException {
        return this.returnAccessors;
    }

    private void checkColumnIndex(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, Integer.toString(n2)).fillInStackTrace();
        }
    }

    static {
        try {
            $$$methodRef$$$26 = AutoKeyInfo.class.getDeclaredConstructor(String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = AutoKeyInfo.class.getDeclaredConstructor(String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = AutoKeyInfo.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = AutoKeyInfo.class.getDeclaredMethod("checkColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = AutoKeyInfo.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = AutoKeyInfo.class.getDeclaredMethod("getTableName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = AutoKeyInfo.class.getDeclaredMethod("getColumnName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = AutoKeyInfo.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = AutoKeyInfo.class.getDeclaredMethod("getValidColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = AutoKeyInfo.class.getDeclaredMethod("initMetaDataColumnIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = AutoKeyInfo.class.getDeclaredMethod("initMetaDataKeyFlag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = AutoKeyInfo.class.getDeclaredMethod("initMetaData", OracleResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = AutoKeyInfo.class.getDeclaredMethod("fillDescribedData", Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = AutoKeyInfo.class.getDeclaredMethod("allocateSpaceForDescribedData", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = AutoKeyInfo.class.getDeclaredMethod("extractTablename", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AutoKeyInfo.class.getDeclaredMethod("getTableNameForUpdateStmt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AutoKeyInfo.class.getDeclaredMethod("getTableNameForInsertStmt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AutoKeyInfo.class.getDeclaredMethod("getTableName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AutoKeyInfo.class.getDeclaredMethod("isInsertOrUpdateSqlStmt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AutoKeyInfo.class.getDeclaredMethod("isUpdateSqlStmt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AutoKeyInfo.class.getDeclaredMethod("isInsertSqlStmt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AutoKeyInfo.class.getDeclaredMethod("getReturnParamTypeCode", Integer.TYPE, String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AutoKeyInfo.class.getDeclaredMethod("getNewSqlByColumnIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AutoKeyInfo.class.getDeclaredMethod("getNewSqlByColumnName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AutoKeyInfo.class.getDeclaredMethod("getNewSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AutoKeyInfo.class.getDeclaredMethod("generateUniqueNamedParameter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AutoKeyInfo.class.getDeclaredMethod("parseSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SQL_PARSER = new ThreadLocal<OracleSql>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected OracleSql initialValue() {
                return new OracleSql(null);
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }
}

