/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDatabaseException;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoer11
extends T4CTTIMsg {
    final int MAXERRBUF = 512;
    long curRowNumber;
    long retCode;
    int arrayElemWError;
    int arrayElemErrno;
    int currCursorID;
    short errorPosition;
    short sqlType;
    byte oerFatal;
    short flags;
    short userCursorOpt;
    short upiParam;
    short warningFlag;
    int osError;
    short stmtNumber;
    short callNumber;
    int pad1;
    long successIters;
    int partitionId;
    int tableId;
    int slotNumber;
    long rba;
    long blockNumber;
    int warnLength = 0;
    int warnFlag = 0;
    int[] errorLength = new int[1];
    byte[] errorMsg;
    byte[] oerepa;
    static final int OERFNCF = 32;
    static final int ORA1403 = 1403;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Tue_Aug_11_01:32:49_PDT_2020";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    T4CTTIoer11(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)4);
    }

    void init() {
        this.retCode = 0L;
        this.errorMsg = null;
        this.oerepa = null;
    }

    int unmarshal() throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.retCode != 0L) {
            this.unmarshalErrorMessage();
        }
        return this.currCursorID;
    }

    void unmarshalErrorMessage() throws IOException, SQLException {
        this.errorMsg = this.meg.unmarshalCLR();
        this.errorLength[0] = this.errorMsg.length;
    }

    void unmarshalAttributes() throws IOException, SQLException {
        int n2;
        if (this.connection.getTTCVersion() >= 3) {
            this.connection.endToEndECIDSequenceNumber = n2 = (int)this.meg.unmarshalUB2();
        }
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB1();
        this.userCursorOpt = this.meg.unmarshalSB1();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rba = this.meg.unmarshalUB4();
        this.partitionId = this.meg.unmarshalUB2();
        this.tableId = this.meg.unmarshalUB1();
        this.blockNumber = this.meg.unmarshalUB4();
        this.slotNumber = this.meg.unmarshalUB2();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
        this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
        n2 = this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
        this.oerepa = (byte[])(n2 > 0 ? Arrays.copyOf(this.connection.tmpBytes128, this.connection.tmpBytes128.length) : null);
        this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
    }

    void unmarshalWarning() throws IOException, SQLException {
        this.retCode = this.meg.unmarshalUB2();
        this.warnLength = this.meg.unmarshalUB2();
        this.warnFlag = this.meg.unmarshalUB2();
        if (this.retCode != 0L && this.warnLength > 0) {
            this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
            this.errorLength[0] = this.warnLength;
        }
    }

    void print() throws SQLException {
        if (TRACE && this.warnFlag != 0) {
        }
        if (this.retCode != 0L) {
        } else if (this.warnFlag != 0) {
        }
    }

    void processError() throws SQLException {
        this.processError(true);
    }

    void processError(boolean bl) throws SQLException {
        this.processError(bl, null);
    }

    void processError(OracleStatement oracleStatement) throws SQLException {
        this.processError(true, oracleStatement);
    }

    void processError(boolean bl, OracleStatement oracleStatement) throws SQLException {
        int n2;
        long l2;
        if (oracleStatement != null) {
            oracleStatement.numberOfExecutedElementsInBatch = (int)this.successIters;
        }
        if ((l2 = this.getRetCode()) != 0L) {
            switch ((int)l2) {
                case 28: 
                case 600: 
                case 1012: 
                case 1041: 
                case 3113: 
                case 3114: {
                    this.connection.internalClose();
                    break;
                }
                case 902: 
                case 21700: {
                    this.connection.removeAllDescriptor();
                }
            }
            if (bl) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), (int)l2).fillInStackTrace();
                if (this.errorPosition >= 0 && oracleStatement != null) {
                    sQLException.initCause(new OracleDatabaseException(this.errorPosition, (int)this.retCode, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), oracleStatement.sqlObject.actualSql, oracleStatement.sqlObject.originalSql));
                }
                throw sQLException;
            }
            return;
        }
        if (!bl) {
            return;
        }
        if ((this.warningFlag & 1) == 1 && (((n2 = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (n2 & 4) == 4)) {
            throw (SQLException)DatabaseError.createSqlException(110).fillInStackTrace();
        }
        if (this.connection != null && this.connection.plsqlCompilerWarnings && (this.flags & 4) == 4) {
            oracleStatement.foundPlsqlCompilerWarning();
        }
    }

    void processWarning() throws SQLException {
        if (this.retCode != 0L) {
            throw DatabaseError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), (int)this.retCode);
        }
    }

    long getCurRowNumber() throws SQLException {
        return this.curRowNumber;
    }

    long getRetCode() {
        return this.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    long updateChecksum(long l2) throws SQLException {
        l2 = CRC64.updateChecksum(l2, this.retCode);
        l2 = CRC64.updateChecksum(l2, this.curRowNumber);
        l2 = CRC64.updateChecksum(l2, this.errorPosition);
        l2 = CRC64.updateChecksum(l2, this.sqlType);
        l2 = CRC64.updateChecksum(l2, this.oerFatal);
        l2 = CRC64.updateChecksum(l2, this.flags);
        l2 = CRC64.updateChecksum(l2, this.userCursorOpt);
        l2 = CRC64.updateChecksum(l2, this.upiParam);
        l2 = CRC64.updateChecksum(l2, this.warningFlag);
        l2 = CRC64.updateChecksum(l2, this.osError);
        l2 = CRC64.updateChecksum(l2, this.successIters);
        l2 = CRC64.updateChecksum(l2, this.errorMsg, 0, this.errorMsg.length);
        return l2;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$16 = T4CTTIoer11.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CTTIoer11.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CTTIoer11.class.getDeclaredMethod("updateChecksum", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIoer11.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIoer11.class.getDeclaredMethod("getRetCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIoer11.class.getDeclaredMethod("getCurRowNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIoer11.class.getDeclaredMethod("processWarning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIoer11.class.getDeclaredMethod("processError", Boolean.TYPE, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIoer11.class.getDeclaredMethod("processError", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIoer11.class.getDeclaredMethod("processError", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoer11.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoer11.class.getDeclaredMethod("print", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoer11.class.getDeclaredMethod("unmarshalWarning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoer11.class.getDeclaredMethod("unmarshalAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoer11.class.getDeclaredMethod("unmarshalErrorMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoer11.class.getDeclaredMethod("unmarshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoer11.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoer11"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

