/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.net.nt.SocketChannelWrapper;

public class WSSSocketChannel
extends SocketChannelWrapper {
    private static final byte WS_OPCODE_CONTINUE = 0;
    private static final byte WS_OPCODE_TEXTDATA = 1;
    private static final byte WS_OPCODE_BINARYDATA = 2;
    private static final byte WS_OPCODE_CLOSE = 8;
    private static final byte WS_OPCODE_PING = 9;
    private static final byte WS_OPCODE_PONG = 10;
    private static final int HANDSHAKE_RESPONSE_BUFFER_SIZE = 1024;
    private static final byte MASK_BYTE_OPCODE = 15;
    private static final byte MASK_BYTE_FIN = -127;
    public static final byte[] WS_DUMMY_MASK_KEY;
    private ByteBuffer payloadBuffer = ByteBuffer.allocate(this.bufferSize);
    private boolean isClosed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public WSSSocketChannel(SocketChannel socketChannel, String string, String string2, int n2, String string3, String string4) throws IOException {
        super(socketChannel);
        this.payloadBuffer.limit(0);
        this.doWSHandShake(string, string2, n2, string3, string4);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.position();
        if (!this.payloadBuffer.hasRemaining()) {
            this.readFromSocket();
        }
        while (this.payloadBuffer.hasRemaining() && byteBuffer.hasRemaining()) {
            byteBuffer.put(this.payloadBuffer.get());
        }
        return byteBuffer.position() - n2;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 > 0) {
            WSFrame.writeFrame(this.socketChannel, new WSBinaryFrame(byteBuffer));
        }
        return n2;
    }

    @Override
    public void setBufferSize(int n2) {
        if (this.bufferSize == n2) {
            return;
        }
        this.bufferSize = n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (this.payloadBuffer.hasRemaining()) {
            byteBuffer.put(this.payloadBuffer);
        }
        byteBuffer.flip();
        this.payloadBuffer = byteBuffer;
    }

    private void doWSHandShake(String string, String string2, int n2, String string3, String string4) throws IOException {
        WSHandshakeHelper wSHandshakeHelper = new WSHandshakeHelper(string, null, string2, n2, string3, string4);
        wSHandshakeHelper.sendHandshakeData(this.socketChannel);
        wSHandshakeHelper.receiveHandshakeResponse(this.socketChannel);
    }

    private void readFromSocket() throws IOException {
        WSFrame.readFrame(this.socketChannel, this.payloadBuffer);
    }

    @Override
    public void disconnect() {
        try {
            if (!this.isClosed && this.socketChannel != null && this.socketChannel.isOpen()) {
                WSCloseFrame wSCloseFrame = new WSCloseFrame();
                WSFrame.writeFrame(this.socketChannel, wSCloseFrame);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isClosed = true;
        try {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            $$$methodRef$$$6 = WSSSocketChannel.class.getDeclaredConstructor(SocketChannel.class, String.class, String.class, Integer.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = WSSSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = WSSSocketChannel.class.getDeclaredMethod("readFromSocket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = WSSSocketChannel.class.getDeclaredMethod("doWSHandShake", String.class, String.class, Integer.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = WSSSocketChannel.class.getDeclaredMethod("setBufferSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = WSSSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = WSSSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        WS_DUMMY_MASK_KEY = new byte[]{0, 0, 0, 0};
    }

    private static class WSBinaryFrame
    extends WSFrame {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private WSBinaryFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(wSHeader, byteBuffer, socketChannel);
        }

        private WSBinaryFrame(ByteBuffer byteBuffer) {
            this.payloadBuffer = byteBuffer;
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            WSHeader.access$802(this.header, WS_DUMMY_MASK_KEY);
            this.header.opCode = (byte)2;
            this.header.payloadLength = this.payloadBuffer.remaining();
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
        }

        static {
            try {
                $$$methodRef$$$5 = WSBinaryFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSBinaryFrame.class.getDeclaredConstructor(ByteBuffer.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSBinaryFrame.class.getDeclaredConstructor(ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSBinaryFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSBinaryFrame.class.getDeclaredMethod("readPayload", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSBinaryFrame.class.getDeclaredMethod("prepareForWrite", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class WSCloseFrame
    extends WSFrame {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private WSCloseFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(wSHeader, byteBuffer, socketChannel);
        }

        private WSCloseFrame() {
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            WSHeader.access$802(this.header, WS_DUMMY_MASK_KEY);
            this.header.opCode = (byte)8;
            this.header.payloadLength = 0;
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
            short s2 = this.payloadBuffer.getShort();
            throw new IOException("WebSocket : Connection closed. (Error code : " + s2 + ")");
        }

        static {
            try {
                $$$methodRef$$$5 = WSCloseFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSCloseFrame.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSCloseFrame.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSCloseFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSCloseFrame.class.getDeclaredMethod("readPayload", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSCloseFrame.class.getDeclaredMethod("prepareForWrite", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static abstract class WSFrame {
        protected WSHeader header;
        protected ByteBuffer payloadBuffer;
        protected SocketChannel socketChannel;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        private WSFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            this.header = wSHeader;
            this.payloadBuffer = byteBuffer;
            this.socketChannel = socketChannel;
        }

        private WSFrame() {
        }

        static WSFrame readFrame(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
            WSHeader wSHeader = new WSHeader();
            wSHeader.read(socketChannel);
            WSFrame wSFrame = null;
            switch (wSHeader.opCode) {
                case 0: 
                case 2: {
                    wSFrame = new WSBinaryFrame(wSHeader, byteBuffer, socketChannel);
                    break;
                }
                case 8: {
                    wSFrame = new WSCloseFrame(wSHeader, byteBuffer, socketChannel);
                    break;
                }
                default: {
                    throw new IOException("Websocket : Invalid frame type : " + wSHeader.opCode);
                }
            }
            wSFrame.readPayload();
            wSFrame.maskOrUnmaskPayload();
            return wSFrame;
        }

        static void writeFrame(SocketChannel socketChannel, WSFrame wSFrame) throws IOException {
            wSFrame.prepareForWrite();
            wSFrame.header.write(socketChannel);
            wSFrame.maskOrUnmaskPayload();
            if (wSFrame.payloadBuffer != null) {
                while (wSFrame.payloadBuffer.hasRemaining()) {
                    socketChannel.write(wSFrame.payloadBuffer);
                }
            }
        }

        private void maskOrUnmaskPayload() {
            if (this.header.isPayloadMasked) {
                int n2;
                for (int i2 = n2 = this.payloadBuffer.position(); i2 < this.payloadBuffer.limit(); ++i2) {
                    byte by = this.payloadBuffer.get(i2);
                    by = (byte)(by ^ this.header.maskingKey[i2 % 4]);
                    this.payloadBuffer.put(i2, by);
                }
                this.payloadBuffer.rewind();
                this.payloadBuffer.position(n2);
            }
        }

        protected void readPayloadFromSocket() throws IOException {
            this.payloadBuffer.clear();
            this.payloadBuffer.limit(this.header.payloadLength);
            if (this.header.payloadLength <= 0) {
                return;
            }
            while (this.payloadBuffer.hasRemaining()) {
                this.socketChannel.read(this.payloadBuffer);
            }
            this.payloadBuffer.flip();
        }

        abstract void readPayload() throws IOException;

        abstract void prepareForWrite() throws IOException;

        static {
            try {
                $$$methodRef$$$7 = WSFrame.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WSFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WSFrame.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSFrame.class.getDeclaredMethod("readPayloadFromSocket", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSFrame.class.getDeclaredMethod("maskOrUnmaskPayload", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSFrame.class.getDeclaredMethod("writeFrame", SocketChannel.class, WSFrame.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSFrame.class.getDeclaredMethod("readFrame", SocketChannel.class, ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class WSHeader {
        private boolean isFinalChunk;
        private byte opCode;
        private int payloadLength;
        private boolean isPayloadMasked;
        private byte[] maskingKey;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;

        private WSHeader() {
        }

        void read(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(14);
            byteBuffer.limit(2);
            while (byteBuffer.hasRemaining()) {
                socketChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            this.isFinalChunk = (by & 0x80) != 0;
            this.opCode = (byte)(by & 0xF);
            this.isPayloadMasked = (by2 & 0x80) != 0;
            this.payloadLength = (byte)(0x7F & by2);
            this.readRemainingHeaderBytes(socketChannel, byteBuffer);
            if (this.payloadLength == 126) {
                this.payloadLength = byteBuffer.getShort() & 0xFFFF;
            } else if (this.payloadLength >= 127) {
                this.payloadLength = (int)byteBuffer.getLong();
            }
            if (this.isPayloadMasked) {
                this.maskingKey = new byte[4];
                byteBuffer.get(this.maskingKey);
            }
        }

        private void readRemainingHeaderBytes(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
            int n2 = 2;
            if (this.payloadLength == 126) {
                n2 += 2;
            } else if (this.payloadLength >= 127) {
                n2 += 8;
            }
            if (this.isPayloadMasked) {
                n2 += 4;
            }
            byteBuffer.position(2);
            byteBuffer.limit(n2);
            while (byteBuffer.hasRemaining()) {
                socketChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            byteBuffer.position(2);
        }

        private void write(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(14);
            byte by = this.opCode;
            if (this.isFinalChunk) {
                by = (byte)(by | 0x80);
            }
            byte by2 = 0;
            if (this.isPayloadMasked) {
                by2 = -128;
            }
            byteBuffer.put(by);
            if (this.payloadLength > 65535) {
                by2 = (byte)(by2 | 0x7F);
                byteBuffer.put(by2);
                byteBuffer.putLong(this.payloadLength);
            } else if (this.payloadLength >= 126) {
                by2 = (byte)(by2 | 0x7E);
                byteBuffer.put(by2);
                byteBuffer.putShort((short)this.payloadLength);
            } else {
                by2 = (byte)(by2 | this.payloadLength & 0x7F);
                byteBuffer.put(by2);
            }
            if (this.isPayloadMasked) {
                byteBuffer.put(this.maskingKey);
            }
            byteBuffer.flip();
            socketChannel.write(byteBuffer);
        }

        static /* synthetic */ byte[] access$802(WSHeader wSHeader, byte[] byArray) {
            wSHeader.maskingKey = byArray;
            return byArray;
        }

        static {
            try {
                $$$methodRef$$$14 = WSHeader.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = WSHeader.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = WSHeader.class.getDeclaredMethod("access$902", WSHeader.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = WSHeader.class.getDeclaredMethod("access$302", WSHeader.class, Byte.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = WSHeader.class.getDeclaredMethod("access$802", WSHeader.class, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = WSHeader.class.getDeclaredMethod("access$702", WSHeader.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = WSHeader.class.getDeclaredMethod("access$1202", WSHeader.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = WSHeader.class.getDeclaredMethod("access$900", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WSHeader.class.getDeclaredMethod("access$800", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WSHeader.class.getDeclaredMethod("access$700", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSHeader.class.getDeclaredMethod("access$600", WSHeader.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSHeader.class.getDeclaredMethod("access$300", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSHeader.class.getDeclaredMethod("write", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSHeader.class.getDeclaredMethod("readRemainingHeaderBytes", SocketChannel.class, ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSHeader.class.getDeclaredMethod("read", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class WSHandshakeHelper {
        private final byte[] MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.UTF_8);
        private final int SWITCHING_PROTOCOLS = 101;
        private final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
        private final Pattern PAT_HEADER = Pattern.compile("([^:]+):\\s*(.*)");
        private final String uri;
        private final String queryParam;
        private final String host;
        private final int port;
        private final String key;
        private final String httpBasicAuthKey;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        WSHandshakeHelper(String string, String string2, String string3, int n2, String string4, String string5) {
            this.uri = string;
            this.queryParam = string2;
            this.host = string3;
            this.port = n2;
            this.key = this.genRandomKey();
            this.httpBasicAuthKey = string4 != null && string5 != null ? this.getHTTPAuthHeader(string4, string5) : null;
        }

        void sendHandshakeData(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.generateUpgradeRequest().getBytes(StandardCharsets.ISO_8859_1));
            while (byteBuffer.hasRemaining()) {
                socketChannel.write(byteBuffer);
            }
        }

        void receiveHandshakeResponse(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            socketChannel.read(byteBuffer);
            byteBuffer.flip();
            String string = new String(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit(), StandardCharsets.ISO_8859_1);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            this.validateStatus(string2);
            Properties properties = new Properties();
            string2 = bufferedReader.readLine();
            while (string2 != null && string2.trim().length() > 0) {
                this.parseHeader(string2, properties);
                string2 = bufferedReader.readLine();
            }
            this.validateResponseHeaders(properties);
        }

        private String generateUpgradeRequest() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GET ");
            if (this.uri != null && this.uri.length() > 0) {
                if (!this.uri.startsWith("/")) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(this.uri);
            } else {
                stringBuilder.append("/");
            }
            if (this.queryParam != null && this.queryParam.length() != 0) {
                stringBuilder.append("?").append(this.queryParam);
            }
            stringBuilder.append(" HTTP/1.1\r\n");
            stringBuilder.append("Host: ").append(this.host);
            if (this.port > 0) {
                stringBuilder.append(':').append(this.port);
            }
            stringBuilder.append("\r\n");
            stringBuilder.append("Upgrade: websocket\r\n");
            stringBuilder.append("Connection: Upgrade\r\n");
            stringBuilder.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
            stringBuilder.append("Sec-WebSocket-Version: 13\r\n");
            stringBuilder.append("Sec-WebSocket-Protocol: sqlnet\r\n");
            if (this.httpBasicAuthKey != null) {
                stringBuilder.append("Authorization: " + this.httpBasicAuthKey + "\r\n");
            }
            stringBuilder.append("Pragma: no-cache\r\n");
            stringBuilder.append("Cache-Control: no-cache\r\n");
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }

        private void validateStatus(String string) throws IOException {
            Matcher matcher = this.PAT_STATUS_LINE.matcher(string);
            if (!matcher.matches()) {
                throw new IOException("WebSocket: Unexpected HTTP response status line [" + string + "]");
            }
            int n2 = Integer.parseInt(matcher.group(1));
            String string2 = matcher.group(2);
            if (n2 != 101) {
                throw new IOException("WebSocket: Unable to upgrade to websocket protocol [" + n2 + " : " + string2 + "]");
            }
        }

        private void validateResponseHeaders(Properties properties) throws IOException {
            byte[] byArray;
            String string = properties.getProperty("Connection");
            if (!"upgrade".equalsIgnoreCase(string)) {
                throw new IOException("WebSocket: value of the header Connection is  " + string + " (expected 'upgrade')");
            }
            String string2 = properties.getProperty("Upgrade");
            if (!"websocket".equalsIgnoreCase(string2)) {
                throw new IOException("WebSocket: value of the header Upgrade is  " + string + " (expected 'websocket')");
            }
            String string3 = properties.getProperty("Sec-WebSocket-Accept");
            byte[] byArray2 = byArray = string3 == null ? null : string3.getBytes(StandardCharsets.ISO_8859_1);
            if (byArray == null || byArray.length < 20) {
                throw new IOException("Invalid Sec-WebSocket-Accept hash");
            }
            byte[] byArray3 = this.expectedAcceptHash(this.key);
            for (int i2 = 0; i2 < 20; ++i2) {
                if (byArray[i2] == byArray3[i2]) continue;
                throw new IOException("Sec-WebSocket-Accept hash does not match");
            }
        }

        private String getHTTPAuthHeader(String string, String string2) {
            String string3 = string + ":" + string2;
            byte[] byArray = Base64.getEncoder().encode(string3.getBytes(StandardCharsets.ISO_8859_1));
            String string4 = "Basic " + new String(byArray, StandardCharsets.ISO_8859_1);
            return string4;
        }

        private void parseHeader(String string, Properties properties) {
            Matcher matcher = this.PAT_HEADER.matcher(string);
            if (matcher.matches()) {
                properties.setProperty(matcher.group(1), matcher.group(2));
            }
        }

        private final String genRandomKey() {
            byte[] byArray = new byte[16];
            ThreadLocalRandom.current().nextBytes(byArray);
            return Base64.getEncoder().encodeToString(byArray);
        }

        private final byte[] expectedAcceptHash(String string) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update(this.key.getBytes(StandardCharsets.UTF_8));
                messageDigest.update(this.MAGIC);
                return Base64.getEncoder().encode(messageDigest.digest());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }

        static {
            try {
                $$$methodRef$$$9 = WSHandshakeHelper.class.getDeclaredConstructor(String.class, String.class, String.class, Integer.TYPE, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = WSHandshakeHelper.class.getDeclaredMethod("expectedAcceptHash", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = WSHandshakeHelper.class.getDeclaredMethod("genRandomKey", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WSHandshakeHelper.class.getDeclaredMethod("parseHeader", String.class, Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WSHandshakeHelper.class.getDeclaredMethod("getHTTPAuthHeader", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSHandshakeHelper.class.getDeclaredMethod("validateResponseHeaders", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSHandshakeHelper.class.getDeclaredMethod("validateStatus", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSHandshakeHelper.class.getDeclaredMethod("generateUpgradeRequest", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSHandshakeHelper.class.getDeclaredMethod("receiveHandshakeResponse", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSHandshakeHelper.class.getDeclaredMethod("sendHandshakeData", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

