/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class Utils {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    Utils() {
    }

    static String makeSlashed(Class clazz) {
        return Utils.makeSlashed(clazz.getName());
    }

    static String makeSlashed(String string) {
        return string.replace('.', '/');
    }

    static String makeSlashed(String string, String string2) {
        return Utils.makeSlashed(string) + "/" + string2;
    }

    static String makeType(Class clazz) {
        return Utils.makeType(clazz.getName());
    }

    static String makeType(String string) {
        String string2 = Utils.makeSlashed(string);
        if ("boolean".equals(string2)) {
            return "Z";
        }
        if ("char".equals(string2)) {
            return "C";
        }
        if ("byte".equals(string2)) {
            return "B";
        }
        if ("short".equals(string2)) {
            return "S";
        }
        if ("int".equals(string2)) {
            return "I";
        }
        if ("long".equals(string2)) {
            return "J";
        }
        if ("float".equals(string2)) {
            return "F";
        }
        if ("double".equals(string2)) {
            return "D";
        }
        if ("void".equals(string2)) {
            return "V";
        }
        if (string2.startsWith("[")) {
            return string2;
        }
        return "L" + string2 + ";";
    }

    static String makeSignature(Class[] classArray, Class clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class clazz2 : classArray) {
            stringBuilder.append(Utils.makeType(Utils.makeSlashed(clazz2.getName())));
        }
        stringBuilder.append(')').append(Utils.makeType(Utils.makeSlashed(clazz.getName())));
        return stringBuilder.toString();
    }

    static String[] makeThrowables(Class[] classArray) {
        String[] stringArray;
        int n2 = classArray.length;
        if (0 == n2) {
            stringArray = null;
        } else {
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = Utils.makeSlashed(classArray[i2].getName());
            }
        }
        return stringArray;
    }

    static int loadOpcode(Class clazz) {
        String string = clazz.getName();
        if ("boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string)) {
            return 21;
        }
        if ("long".equals(string)) {
            return 22;
        }
        if ("float".equals(string)) {
            return 23;
        }
        if ("double".equals(string)) {
            return 24;
        }
        return 25;
    }

    static int storeOpcode(Class clazz) {
        String string = clazz.getName();
        if ("boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string)) {
            return 54;
        }
        if ("long".equals(string)) {
            return 55;
        }
        if ("float".equals(string)) {
            return 56;
        }
        if ("double".equals(string)) {
            return 57;
        }
        return 58;
    }

    static int returnOpcode(Class clazz) {
        String string = clazz.getName();
        if ("boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string)) {
            return 172;
        }
        if ("long".equals(string)) {
            return 173;
        }
        if ("float".equals(string)) {
            return 174;
        }
        if ("double".equals(string)) {
            return 175;
        }
        if ("void".equals(string)) {
            return 177;
        }
        return 176;
    }

    static int varSize(Class clazz) {
        String string = clazz.getName();
        if ("double".equals(string) || "long".equals(string)) {
            return 2;
        }
        return 1;
    }

    static void cast(MethodVisitor methodVisitor, Class clazz, Class clazz2) {
        boolean bl = Utils.isPrimitive(clazz);
        boolean bl2 = Utils.isPrimitive(clazz2);
        if (!bl && bl2) {
            Utils.autoUnbox(methodVisitor, clazz2);
        } else if (bl && !bl2) {
            Utils.autoBox(methodVisitor, clazz);
        } else if (!(bl || bl2 || clazz.equals(clazz2))) {
            methodVisitor.visitTypeInsn(192, Utils.makeSlashed(clazz2));
        }
    }

    static boolean isPrimitive(Class clazz) {
        return Boolean.TYPE.equals(clazz) || Character.TYPE.equals(clazz) || Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
    }

    static void autoBox(MethodVisitor methodVisitor, Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (Character.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (Byte.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (Short.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (Integer.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (Long.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (Float.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (Double.TYPE.equals(clazz)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
    }

    static void autoUnbox(MethodVisitor methodVisitor, Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
            methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (Character.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Character");
            methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        } else if (Byte.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Byte");
            methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (Short.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Short");
            methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (Integer.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Integer");
            methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (Long.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Long");
            methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (Float.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Float");
            methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (Double.TYPE.equals(clazz)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Double");
            methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else {
            methodVisitor.visitTypeInsn(192, Utils.makeSlashed(clazz));
        }
    }

    static void loadClass(MethodVisitor methodVisitor, Class clazz) {
        String string = clazz.getName();
        if ("boolean".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
        } else if ("char".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
        } else if ("byte".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
        } else if ("short".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
        } else if ("int".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
        } else if ("long".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
        } else if ("float".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
        } else if ("double".equals(string)) {
            methodVisitor.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
        } else {
            methodVisitor.visitLdcInsn((Object)Type.getType((Class)clazz));
        }
    }

    static void loadConst(MethodVisitor methodVisitor, int n2) {
        switch (n2) {
            case 0: {
                methodVisitor.visitInsn(3);
                return;
            }
            case 1: {
                methodVisitor.visitInsn(4);
                return;
            }
            case 2: {
                methodVisitor.visitInsn(5);
                return;
            }
            case 3: {
                methodVisitor.visitInsn(6);
                return;
            }
            case 4: {
                methodVisitor.visitInsn(7);
                return;
            }
            case 5: {
                methodVisitor.visitInsn(8);
                return;
            }
        }
        if (n2 >= -128 && n2 <= 127) {
            methodVisitor.visitIntInsn(16, n2);
            return;
        }
        throw new RuntimeException("do not know how to load " + n2);
    }

    static {
        try {
            $$$methodRef$$$17 = Utils.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = Utils.class.getDeclaredMethod("loadConst", MethodVisitor.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = Utils.class.getDeclaredMethod("loadClass", MethodVisitor.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = Utils.class.getDeclaredMethod("autoUnbox", MethodVisitor.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = Utils.class.getDeclaredMethod("autoBox", MethodVisitor.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = Utils.class.getDeclaredMethod("isPrimitive", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = Utils.class.getDeclaredMethod("cast", MethodVisitor.class, Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = Utils.class.getDeclaredMethod("varSize", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = Utils.class.getDeclaredMethod("returnOpcode", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Utils.class.getDeclaredMethod("storeOpcode", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Utils.class.getDeclaredMethod("loadOpcode", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Utils.class.getDeclaredMethod("makeThrowables", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Utils.class.getDeclaredMethod("makeSignature", Class[].class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Utils.class.getDeclaredMethod("makeType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Utils.class.getDeclaredMethod("makeType", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Utils.class.getDeclaredMethod("makeSlashed", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Utils.class.getDeclaredMethod("makeSlashed", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Utils.class.getDeclaredMethod("makeSlashed", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

