/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;

public class OracleDataUtil {
    static short lastCsId;
    static CharacterSet lastCS;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Wed_Aug_02_04:24:00_PDT_2023";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public static Object convertToObject(Object object, int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        Object object2 = OracleDataUtil._convertToObject(object, n2, oracleDataFactory);
        return object2;
    }

    public static Object _convertToObject(Object object, int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof OracleStruct) {
            return oracleDataFactory.create(object, 2002);
        }
        if (object instanceof OracleRef) {
            return oracleDataFactory.create(object, 2006);
        }
        if (object instanceof OracleArray) {
            return oracleDataFactory.create(object, 2003);
        }
        if (object instanceof OracleOpaque) {
            return oracleDataFactory.create(object, 2007);
        }
        if (oracleDataFactory != null) {
            return oracleDataFactory.create(object, n2);
        }
        if (object instanceof NUMBER) {
            if (n2 == 2 || n2 == 3) {
                return ((NUMBER)object).bigDecimalValue();
            }
            if (n2 == 8 || n2 == 6) {
                return ((NUMBER)object).doubleValue();
            }
            if (n2 == 4 || n2 == 5) {
                return ((NUMBER)object).intValue();
            }
            if (n2 == 7) {
                return Float.valueOf(((NUMBER)object).floatValue());
            }
            if (n2 == 16) {
                return ((NUMBER)object).booleanValue();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 48 type: " + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 48, " type: " + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return object;
    }

    public static Object convertToOracle(Object object, Connection connection) throws SQLException {
        return OracleDataUtil.convertToOracle(object, connection, false);
    }

    public static Object convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        Object object2 = OracleDataUtil._convertToOracle(object, connection, bl);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof OracleData) {
            return ((OracleData)object).toJDBCObject((OracleConnection)connection);
        }
        if (object instanceof String) {
            short s2;
            short s3 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (s2 = bl ? ((oracle.jdbc.internal.OracleConnection)connection).getNCharSet() : ((oracle.jdbc.internal.OracleConnection)connection).getDbCsId());
            if (s2 != lastCsId) {
                lastCsId = s2;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)object, lastCS);
        }
        if (object instanceof Character) {
            short s4;
            short s5 = s4 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (short)((oracle.jdbc.internal.OracleConnection)connection).getDbCsId();
            if (s4 != lastCsId) {
                lastCsId = s4;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)object).toString(), lastCS);
        }
        if (object instanceof BigDecimal) {
            return new NUMBER((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new NUMBER((BigInteger)object);
        }
        if (object instanceof Double) {
            return new NUMBER((Double)object);
        }
        if (object instanceof Float) {
            return new NUMBER(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new NUMBER((Integer)object);
        }
        if (object instanceof Boolean) {
            return new NUMBER((Boolean)object);
        }
        if (object instanceof Short) {
            return new NUMBER((Short)object);
        }
        if (object instanceof Byte) {
            return new NUMBER((Byte)object);
        }
        if (object instanceof Long) {
            return new NUMBER((Long)object);
        }
        if (object instanceof Timestamp) {
            return new TIMESTAMP((Timestamp)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)object).getTime()));
        }
        if (object instanceof byte[]) {
            return new RAW((byte[])object);
        }
        if (object instanceof OracleData) {
            return object;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleDataUtil.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 48");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(null, 48);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static boolean isMutable(Object object, OracleDataFactory oracleDataFactory) {
        if (object == null) {
            return false;
        }
        return object instanceof OracleBfile || object instanceof OracleBlob || object instanceof OracleClob || oracleDataFactory != null && (object instanceof OracleStruct || object instanceof OracleOpaque || object instanceof OracleArray);
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jpub.runtime");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$8 = OracleDataUtil.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleDataUtil.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleDataUtil.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleDataUtil.class.getDeclaredMethod("isMutable", Object.class, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleDataUtil.class.getDeclaredMethod("_convertToOracle", Object.class, Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDataUtil.class.getDeclaredMethod("convertToOracle", Object.class, Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDataUtil.class.getDeclaredMethod("convertToOracle", Object.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDataUtil.class.getDeclaredMethod("_convertToObject", Object.class, Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDataUtil.class.getDeclaredMethod("convertToObject", Object.class, Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        lastCsId = (short)870;
        lastCS = CharacterSet.make(870);
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jpub.runtime.Util"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

