/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class CancelLock {
    private CancelState state = null;
    private OracleStatement statement = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    CancelLock(OracleStatement oracleStatement) {
        this.statement = oracleStatement;
        this.state = new CancelState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIdle() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            return this.state.isIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCanceled() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            return this.state.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterExecuting() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            assert (this.state.isIdle());
            this.state.setExecuting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitExecuting() {
        while (true) {
            CancelState cancelState = this.state;
            synchronized (cancelState) {
                if (this.state.isExecuting()) {
                    this.state.setIdle();
                    break;
                }
                if (this.state.isCanceling()) {
                    try {
                        this.state.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (this.state.isCanceled()) {
                    if (this.statement != null && this.statement.connection.cancelInProgressFlag) {
                    }
                    this.state.setIdle();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enterCanceling() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            if (this.state.isExecuting()) {
                this.state.setCanceling();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitCanceling() {
        CancelState cancelState = this.state;
        synchronized (cancelState) {
            assert (this.state.isCanceling());
            this.state.setCanceled();
            this.state.notify();
        }
    }

    static {
        try {
            $$$methodRef$$$6 = CancelLock.class.getDeclaredConstructor(OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CancelLock.class.getDeclaredMethod("exitCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CancelLock.class.getDeclaredMethod("enterCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CancelLock.class.getDeclaredMethod("exitExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CancelLock.class.getDeclaredMethod("enterExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CancelLock.class.getDeclaredMethod("isCanceled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CancelLock.class.getDeclaredMethod("isIdle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

