/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.Joinable;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
abstract class OracleRowSet
implements Serializable,
Cloneable,
Joinable {
    protected String dataSource;
    protected String dataSourceName;
    protected String url;
    protected String username;
    protected String password;
    protected Map typeMap;
    protected int maxFieldSize;
    protected int maxRows;
    protected int queryTimeout;
    protected int fetchSize;
    protected int transactionIsolation;
    protected boolean escapeProcessing;
    protected String command;
    protected int concurrency;
    protected boolean readOnly;
    protected int fetchDirection;
    protected int rowsetType;
    protected boolean showDeleted;
    protected Vector listener;
    protected RowSetEvent rowsetEvent;
    protected Vector matchColumnIndexes;
    protected Vector matchColumnNames;
    protected boolean isClosed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;

    protected OracleRowSet() throws SQLException {
        this.initializeProperties();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.listener = new Vector();
        this.rowsetEvent = new RowSetEvent((RowSet)((Object)this));
        this.isClosed = false;
    }

    protected void initializeProperties() {
        this.command = null;
        this.concurrency = 1007;
        this.dataSource = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = false;
        this.showDeleted = false;
        this.transactionIsolation = 2;
        this.rowsetType = 1005;
        this.typeMap = new HashMap();
        this.username = null;
        this.password = null;
        this.url = null;
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getReadOnly() {
        return this.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean getShowDeleted() {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.rowsetType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n2) throws SQLException {
        if (n2 != 1007 && n2 != 1008) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.concurrency = n2;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.fetchDirection = n2;
    }

    public void setFetchSize(int n2) throws SQLException {
        this.fetchSize = n2;
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        this.maxFieldSize = n2;
    }

    public void setMaxRows(int n2) throws SQLException {
        this.maxRows = n2;
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.queryTimeout = n2;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        this.transactionIsolation = n2;
    }

    public void setType(int n2) throws SQLException {
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.rowsetType = n2;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        for (int i2 = 0; i2 < this.listener.size(); ++i2) {
            if (!this.listener.elementAt(i2).equals(rowSetListener)) continue;
            return;
        }
        this.listener.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        for (int i2 = 0; i2 < this.listener.size(); ++i2) {
            if (!this.listener.elementAt(i2).equals(rowSetListener)) continue;
            this.listener.remove(i2);
        }
    }

    protected synchronized void notifyCursorMoved() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RowSetListener)this.listener.elementAt(i2)).cursorMoved(this.rowsetEvent);
            }
        }
    }

    protected void notifyRowChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RowSetListener)this.listener.elementAt(i2)).rowChanged(this.rowsetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() {
        int n2 = this.listener.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ((RowSetListener)this.listener.elementAt(i2)).rowSetChanged(this.rowsetEvent);
            }
        }
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        int[] nArray;
        if (this.matchColumnIndexes.size() == 0 && this.matchColumnNames.size() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334).fillInStackTrace();
        }
        if (this.matchColumnNames.size() > 0) {
            String[] stringArray = this.getMatchColumnNames();
            int n2 = stringArray.length;
            nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.findColumn(stringArray[i2]);
            }
        } else {
            int n3 = this.matchColumnIndexes.size();
            nArray = new int[n3];
            int n4 = -1;
            for (int i3 = 0; i3 < n3; ++i3) {
                try {
                    n4 = (Integer)this.matchColumnIndexes.get(i3);
                }
                catch (Exception exception) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336).fillInStackTrace();
                }
                if (n4 <= 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336).fillInStackTrace();
                }
                nArray[i3] = n4;
            }
        }
        return nArray;
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        this.checkIfMatchColumnNamesSet();
        int n2 = this.matchColumnNames.size();
        String[] stringArray = new String[n2];
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                string = (String)this.matchColumnNames.get(i2);
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 337).fillInStackTrace();
            }
            if (string == null || string.equals("")) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 337).fillInStackTrace();
            }
            stringArray[i2] = string;
        }
        return stringArray;
    }

    @Override
    public void setMatchColumn(int n2) throws SQLException {
        if (n2 <= 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336).fillInStackTrace();
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnIndexes.add(0, n2);
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 338).fillInStackTrace();
        }
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (nArray == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336).fillInStackTrace();
            }
            try {
                this.matchColumnIndexes.add(i2, nArray[i2]);
                continue;
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 338).fillInStackTrace();
            }
        }
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        if (string == null || string.equals("")) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnNames.add(0, string.trim());
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 339).fillInStackTrace();
        }
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            try {
                this.matchColumnNames.add(i2, stringArray[i2].trim());
                continue;
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 339).fillInStackTrace();
            }
        }
    }

    @Override
    public void unsetMatchColumn(int n2) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (n2 <= 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336).fillInStackTrace();
        }
        int n3 = -1;
        try {
            n3 = (Integer)this.matchColumnIndexes.get(0);
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334).fillInStackTrace();
        }
        if (n3 != n2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 340).fillInStackTrace();
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (nArray == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        int n2 = -1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 336).fillInStackTrace();
            }
            try {
                n2 = (Integer)this.matchColumnIndexes.get(i2);
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334).fillInStackTrace();
            }
            if (n2 == nArray[i2]) continue;
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 340).fillInStackTrace();
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (string == null || string.equals("")) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String string2 = null;
        try {
            string2 = (String)this.matchColumnNames.get(0);
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 335).fillInStackTrace();
        }
        if (!string2.equals(string.trim())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 341).fillInStackTrace();
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (stringArray == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String string = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            try {
                string = (String)this.matchColumnNames.get(i2);
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 335).fillInStackTrace();
            }
            if (string.equals(stringArray[i2])) continue;
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 341).fillInStackTrace();
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void validateJNDIName(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 360).fillInStackTrace();
        }
        if ((string.toLowerCase().startsWith("ldap://") || string.toLowerCase().startsWith("rmi://")) && !Boolean.valueOf(System.getProperty("oracle.jdbc.allowAbsoluteJNDIUrls", "false")).booleanValue()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 360).fillInStackTrace();
        }
    }

    protected void checkIfMatchColumnIndexesSet() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 334).fillInStackTrace();
        }
    }

    protected void checkIfMatchColumnNamesSet() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 335).fillInStackTrace();
        }
    }

    public abstract int findColumn(String var1) throws SQLException;

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    abstract String getTableName() throws SQLException;

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException("<T> T getObject").fillInStackTrace();
    }

    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException("<T> T getObject").fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$63 = OracleRowSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleRowSet.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleRowSet.class.getDeclaredMethod("getObject", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleRowSet.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleRowSet.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleRowSet.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleRowSet.class.getDeclaredMethod("getHoldability", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleRowSet.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleRowSet.class.getDeclaredMethod("checkIfMatchColumnNamesSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleRowSet.class.getDeclaredMethod("checkIfMatchColumnIndexesSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleRowSet.class.getDeclaredMethod("validateJNDIName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleRowSet.class.getDeclaredMethod("unsetMatchColumn", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleRowSet.class.getDeclaredMethod("unsetMatchColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleRowSet.class.getDeclaredMethod("unsetMatchColumn", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleRowSet.class.getDeclaredMethod("unsetMatchColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleRowSet.class.getDeclaredMethod("setMatchColumn", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleRowSet.class.getDeclaredMethod("setMatchColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleRowSet.class.getDeclaredMethod("setMatchColumn", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleRowSet.class.getDeclaredMethod("setMatchColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleRowSet.class.getDeclaredMethod("getMatchColumnNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleRowSet.class.getDeclaredMethod("getMatchColumnIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleRowSet.class.getDeclaredMethod("notifyRowSetChanged", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleRowSet.class.getDeclaredMethod("notifyRowChanged", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleRowSet.class.getDeclaredMethod("notifyCursorMoved", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleRowSet.class.getDeclaredMethod("removeRowSetListener", RowSetListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleRowSet.class.getDeclaredMethod("addRowSetListener", RowSetListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleRowSet.class.getDeclaredMethod("setUsername", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleRowSet.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleRowSet.class.getDeclaredMethod("setTypeMap", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleRowSet.class.getDeclaredMethod("setType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleRowSet.class.getDeclaredMethod("setTransactionIsolation", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleRowSet.class.getDeclaredMethod("setShowDeleted", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleRowSet.class.getDeclaredMethod("setReadOnly", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleRowSet.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleRowSet.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleRowSet.class.getDeclaredMethod("setMaxRows", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleRowSet.class.getDeclaredMethod("setMaxFieldSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleRowSet.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleRowSet.class.getDeclaredMethod("setFetchDirection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleRowSet.class.getDeclaredMethod("setEscapeProcessing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleRowSet.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleRowSet.class.getDeclaredMethod("setDataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleRowSet.class.getDeclaredMethod("setConcurrency", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleRowSet.class.getDeclaredMethod("setCommand", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleRowSet.class.getDeclaredMethod("getUsername", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleRowSet.class.getDeclaredMethod("getUrl", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleRowSet.class.getDeclaredMethod("getTypeMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleRowSet.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleRowSet.class.getDeclaredMethod("getTransactionIsolation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleRowSet.class.getDeclaredMethod("getShowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleRowSet.class.getDeclaredMethod("isReadOnly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleRowSet.class.getDeclaredMethod("getReadOnly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleRowSet.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleRowSet.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleRowSet.class.getDeclaredMethod("getMaxRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleRowSet.class.getDeclaredMethod("getMaxFieldSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleRowSet.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleRowSet.class.getDeclaredMethod("getFetchDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleRowSet.class.getDeclaredMethod("getEscapeProcessing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleRowSet.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleRowSet.class.getDeclaredMethod("getDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleRowSet.class.getDeclaredMethod("getConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRowSet.class.getDeclaredMethod("getCommand", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRowSet.class.getDeclaredMethod("initializeProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

