/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.lang.reflect.Executable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public TimeoutSocketChannel(SocketAddress socketAddress, int n2, NetStatImpl netStatImpl) throws IOException {
        super((SocketChannel)null);
        this.netStat = netStatImpl;
        this.connect(socketAddress, n2);
    }

    public TimeoutSocketChannel(InetSocketAddress inetSocketAddress, int n2, NetStatImpl netStatImpl, InetSocketAddress inetSocketAddress2) throws IOException {
        super((SocketChannel)null);
        this.netStat = netStatImpl;
        if (inetSocketAddress2 == null) {
            this.connect(inetSocketAddress, n2);
        } else {
            this.connect(inetSocketAddress2, n2);
            this.doHTTPTunneling(inetSocketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(SocketAddress socketAddress, int n2) throws IOException {
        this.scheduleInterrupt(n2, false);
        try {
            this.socketChannel = SocketChannel.open(socketAddress);
            this.socketChannel.configureBlocking(true);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
    }

    private void doHTTPTunneling(InetSocketAddress inetSocketAddress) throws IOException {
        String string = inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONNECT " + string + " HTTP/1.0\r\n");
        stringBuilder.append("Host: " + string + "\r\n");
        stringBuilder.append("\r\n");
        ByteBuffer byteBuffer = ByteBuffer.wrap(stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1));
        while (byteBuffer.hasRemaining()) {
            this.socketChannel.write(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(512);
        this.socketChannel.read(byteBuffer2);
        byteBuffer2.flip();
        String string2 = new String(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit(), StandardCharsets.US_ASCII);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        String string3 = bufferedReader.readLine();
        Matcher matcher = this.PAT_STATUS_LINE.matcher(string3);
        if (!matcher.matches()) {
            throw new IOException("HTTP proxy tunneling failed [" + string3 + "]");
        }
        int n2 = Integer.parseInt(matcher.group(1));
        String string4 = matcher.group(2);
        if (n2 != 200) {
            throw new IOException("HTTP proxy tunneling failed [" + n2 + ":" + string3 + "]");
        }
    }

    void setNetStat(NetStatImpl netStatImpl) {
        this.netStat = netStatImpl;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), true);
        try {
            int n2 = this.socketChannel.read(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesReceived(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), false);
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int n2 = this.socketChannel.write(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    private void scheduleInterrupt(int n2, boolean bl) {
        if (n2 > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread(), this, bl);
        }
    }

    private void handleInterrupt() throws InterruptedIOException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
        }
        throw new InterruptedIOException("Socket read interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    static {
        try {
            $$$methodRef$$$15 = TimeoutSocketChannel.class.getDeclaredConstructor(InetSocketAddress.class, Integer.TYPE, NetStatImpl.class, InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimeoutSocketChannel.class.getDeclaredConstructor(SocketAddress.class, Integer.TYPE, NetStatImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimeoutSocketChannel.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimeoutSocketChannel.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimeoutSocketChannel.class.getDeclaredMethod("handleInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimeoutSocketChannel.class.getDeclaredMethod("scheduleInterrupt", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimeoutSocketChannel.class.getDeclaredMethod("getSoTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimeoutSocketChannel.class.getDeclaredMethod("setSoTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimeoutSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeoutSocketChannel.class.getDeclaredMethod("setNetStat", NetStatImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeoutSocketChannel.class.getDeclaredMethod("doHTTPTunneling", InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeoutSocketChannel.class.getDeclaredMethod("connect", SocketAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

