/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

@DefaultLogger(value="oracle.jdbc")
class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.implicitCache = oracleImplicitConnectionCache;
    }

    @Override
    public void run() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        while (this.timeToLive) {
            try {
                if (this.timeToLive && (l2 = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                    this.runTimeToLiveTimeout(l2);
                }
                if (this.timeToLive && (l3 = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeout();
                }
                if (this.timeToLive && (l4 = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                    this.runAbandonedTimeout(l4);
                }
                if (this.timeToLive) {
                    this.isSleeping = true;
                    try {
                        OracleImplicitConnectionCacheThread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    this.isSleeping = false;
                }
                if (this.implicitCache != null && (l2 > 0L || l3 > 0L || l4 > 0L)) continue;
                this.timeToLive = false;
            }
            catch (SQLException sQLException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimeToLiveTimeout(long l2) throws SQLException {
        long l3 = 0L;
        long l4 = 0L;
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection oraclePooledConnection = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] objectArray = this.implicitCache.checkedOutConnectionList.toArray();
                int n2 = this.implicitCache.checkedOutConnectionList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[i2];
                    Connection connection = oraclePooledConnection.getLogicalHandle();
                    if (connection == null) continue;
                    l4 = ((OracleConnection)connection).getStartTime();
                    l3 = System.currentTimeMillis();
                    if (l3 - l4 <= l2 * 1000L) continue;
                    try {
                        this.implicitCache.closeCheckedOutConnection(oraclePooledConnection, true);
                        continue;
                    }
                    catch (SQLException sQLException) {
                    }
                }
            }
        }
    }

    private void runInactivityTimeout() {
        try {
            this.implicitCache.doForEveryCachedConnection(4);
        }
        catch (SQLException sQLException) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAbandonedTimeout(long l2) throws SQLException {
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection oraclePooledConnection = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] objectArray = this.implicitCache.checkedOutConnectionList.toArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[i2];
                    OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
                    if (oracleConnection == null) continue;
                    OracleConnectionCacheCallback oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj();
                    if ((long)(oracleConnection.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) <= l2) continue;
                    try {
                        boolean bl = true;
                        if (oracleConnectionCacheCallback != null && (oracleConnection.getConnectionCacheCallbackFlag() == 4 || oracleConnection.getConnectionCacheCallbackFlag() == 1)) {
                            bl = oracleConnectionCacheCallback.handleAbandonedConnection(oracleConnection, oracleConnection.getConnectionCacheCallbackPrivObj());
                        }
                        if (!bl) continue;
                        this.implicitCache.closeCheckedOutConnection(oraclePooledConnection, true);
                        this.implicitCache.checkedOutConnectionList.remove(oraclePooledConnection);
                        this.implicitCache.storeCacheConnection(oraclePooledConnection.cachedConnectionAttributes, oraclePooledConnection);
                        continue;
                    }
                    catch (SQLException sQLException) {
                    }
                }
            }
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$4 = OracleImplicitConnectionCacheThread.class.getDeclaredConstructor(OracleImplicitConnectionCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("runAbandonedTimeout", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("runInactivityTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("runTimeToLiveTimeout", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

