/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalTransactionId;
import oracle.jdbc.driver.NTFLTXIDEvent;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIkvarr;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.driver.TemplateOverflow;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CTTIfun
extends T4CTTIMsg {
    static final short OOPEN = 2;
    static final short OFETCH = 5;
    static final short OCLOSE = 8;
    static final short OLOGOFF = 9;
    static final short OCOMON = 12;
    static final short OCOMOFF = 13;
    static final short OCOMMIT = 14;
    static final short OROLLBACK = 15;
    static final short OCANCEL = 20;
    static final short ODSCRARR = 43;
    static final short OVERSION = 59;
    static final short OK2RPC = 67;
    static final short OALL7 = 71;
    static final short OSQL7 = 74;
    static final short OEXFEN = 78;
    static final short O3LOGON = 81;
    static final short O3LOGA = 82;
    static final short OKOD = 92;
    static final short OALL8 = 94;
    static final short OLOBOPS = 96;
    static final short ODNY = 98;
    static final short OTXSE = 103;
    static final short OTXEN = 104;
    static final short OCCA = 105;
    static final short O80SES = 107;
    static final short ODSY = 119;
    static final short OAUTH = 115;
    static final short OSESSKEY = 118;
    static final short OCANA = 120;
    static final short OKPN = 125;
    static final short OOTCM = 127;
    static final short OSCID = 135;
    static final short OSPFPPUT = 138;
    static final short OKPFC = 139;
    static final short OPING = 147;
    static final short OKEYVAL = 154;
    static final short OXSSCS = 155;
    static final short OXSSRO = 156;
    static final short OXSSPO = 157;
    static final short OAQEQ = 121;
    static final short OAQDQ = 122;
    static final short OAQGPS = 132;
    static final short OAQLS = 126;
    static final short OAQXQ = 145;
    static final short OSESSGET = 162;
    static final short OSESSRLS = 163;
    static final short OSSTEMPLATE = 164;
    static final short OQCSTA = 167;
    static final short OQCID = 168;
    static final short OXSNSO = 172;
    static final short OXSNS = 178;
    static final short OXSSYNC = 176;
    static final short OXSATT = 180;
    static final short OXSCRE = 179;
    static final short OXSDET = 181;
    static final short OXSDES = 182;
    static final short OXSSET = 183;
    static final short OSESSSTATE = 176;
    static final short OAPPCONTREPLAY = 177;
    static final short OAQENQ = 184;
    static final short OAQDEQ = 185;
    static final short OAQEMNDEQ = 186;
    static final short OAQNFY = 187;
    static final short OCHUNKINFO = 190;
    static final short ODPP = 128;
    static final short ODPMOP = 130;
    static final short ODPLS = 129;
    private short funCode;
    protected final T4CTTIoer11 oer;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    boolean rpaProcessed = false;
    boolean rxhProcessed = false;
    boolean iovProcessed = false;
    private final short[] ttiList;
    private int ttiListEnd = 0;
    ReplayContext replayContext = null;
    StateSignatures stateSignatures = null;
    TemplateOverflow templateOverflow = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    T4CTTIfun(T4CConnection t4CConnection, byte by) {
        super(t4CConnection, by);
        this.oer = t4CConnection.getT4CTTIoer();
        this.ttiList = t4CConnection.ttiList;
    }

    final void setFunCode(short s2) {
        this.funCode = s2;
    }

    final short getFunCode() {
        return this.funCode;
    }

    private final void marshalFunHeader() throws IOException {
        this.connection.setExecutingRPCFunctionCode(this.funCode);
        this.marshalTTCcode();
        this.meg.marshalUB1(this.funCode);
        this.meg.marshalUB1(this.connection.getNextSeqNumber());
    }

    abstract void marshal() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doRPC() throws IOException, SQLException {
        if (this.getTTCCode() == 17) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        this.connection.checkEndReplayCallback();
        if (this.connection.isResultSetCacheActive()) {
            this.connection.enterMarshalling();
            this.meg.marshalUB1((short)24);
            this.connection.kpdqidcscn.setSCN(this.connection.getResultSetCacheVisibleSCN());
            this.connection.kpdqidcscn.marshal();
            this.connection.exitMarshalling();
        }
        this.connection.sendPiggyBackedMessages();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.init();
            this.connection.enterMarshalling();
            this.marshalFunHeader();
            try {
                this.connection.pipeState = 1;
                this.marshal();
                this.connection.pipeState = 2;
                this.receive();
                this.connection.exitMarshalling();
                return;
            }
            catch (SQLException sQLException) {
                Object object = this.connection.cancelInProgressLockForThin;
                synchronized (object) {
                    block13: {
                        this.redoCursorClose();
                        if (!this.canReplay(sQLException)) break block13;
                        continue;
                    }
                    throw sQLException;
                }
            }
            finally {
                this.connection.pipeState = -1;
                this.connection.lastPiggyBackCursorCloseSeqNumber = 0;
            }
        }
    }

    final void doPigRPC() throws IOException {
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader();
        this.marshal();
        this.connection.exitMarshalling();
    }

    final void doOneWayRPC() throws IOException, SQLException {
        this.connection.sendPiggyBackedMessages();
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader();
        this.marshal();
        this.meg.flush();
        this.connection.exitMarshalling();
    }

    private void init() {
        this.rpaProcessed = false;
        this.rxhProcessed = false;
        this.iovProcessed = false;
        this.ttiListEnd = 0;
    }

    void resumeReceive() throws SQLException, IOException {
        this.receive();
    }

    private final String ttiListString() {
        Object object = "[ ";
        for (int i2 = 0; i2 < this.ttiListEnd; ++i2) {
            object = (String)object + this.ttiList[i2] + ", ";
        }
        object = (String)object + "]";
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void receive() throws SQLException, IOException {
        this.receiveState = 1;
        this.replayContext = null;
        this.stateSignatures = null;
        this.templateOverflow = null;
        try {
            var1_1 = null;
            block37: while (true) lbl-1000:
            // 19 sources

            {
                try {
                    var2_5 = this.meg.unmarshalUB1();
                    if (this.ttiListEnd < this.ttiList.length) {
                        this.ttiList[this.ttiListEnd++] = var2_5;
                    }
                    switch (var2_5) {
                        case 8: {
                            if (this.rpaProcessed) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                            }
                            this.readRPA();
                            try {
                                this.processRPA();
                            }
                            catch (SQLException var3_7) {
                                var1_1 = var3_7;
                            }
                            this.rpaProcessed = true;
                            ** break;
                        }
                        case 21: {
                            this.readBVC();
                            ** break;
                        }
                        case 11: {
                            this.readIOV();
                            this.iovProcessed = true;
                            ** break;
                        }
                        case 6: {
                            this.readRXH();
                            this.rxhProcessed = true;
                            ** break;
                        }
                        case 12: {
                            this.processSLG();
                            ** break;
                        }
                        case 7: {
                            this.receiveState = 2;
                            if (this.readRXD()) {
                                this.receiveState = 3;
                                return;
                            }
                            this.receiveState = 1;
                            ** break;
                        }
                        case 16: {
                            this.readDCB();
                            ** break;
                        }
                        case 14: {
                            this.readLOBD();
                            ** break;
                        }
                        case 25: {
                            this.readRSH();
                            ** break;
                        }
                        case 23: {
                            this.readSPF();
                            ** break;
                        }
                        case 19: {
                            this.meg.marshalUB1((short)19);
                            ** break;
                        }
                        case 27: {
                            this.readIMPLRES();
                            ** break;
                        }
                        case 15: {
                            this.oer.init();
                            this.oer.unmarshalWarning();
                            try {
                                this.oer.processWarning();
                            }
                            catch (SQLWarning var3_8) {
                                this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), var3_8));
                            }
                            continue block37;
                        }
                        case 9: {
                            this.processEOCS();
                            if (this.connection.getTTCVersion() >= 3) {
                                this.connection.endToEndECIDSequenceNumber = var3_9 = (short)this.meg.unmarshalUB2();
                            }
                            break block37;
                        }
                        case 13: {
                            this.readOAC();
                            ** break;
                        }
                        case 4: {
                            this.processEOCS();
                            this.oer.init();
                            this.oer.unmarshal();
                            try {
                                if (this.oer.callNumber == this.connection.currentTTCSeqNumber) {
                                    this.processError();
                                    break block37;
                                }
                                this.oer.processError(true);
                            }
                            catch (SQLException var3_10) {
                                var1_1 = var3_10;
                            }
                            break block37;
                        }
                        case 28: {
                            this.connection.reNegotiateTTCProDty();
                            ** break;
                        }
                        default: {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString()).fillInStackTrace();
                        }
                    }
                }
                catch (BreakNetException var3_11) {
                    continue;
                }
                finally {
                    this.connection.sentCancel = false;
                    continue;
                }
                break;
            }
            this.receiveState = 0;
            if (var1_1 != null) {
                throw var1_1;
            }
        }
        catch (SQLRecoverableException var1_2) {
            throw var1_2;
        }
        catch (IOException var1_3) {
            if (this.replayContext != null) {
                this.handleReplayContext(this.replayContext);
            }
            if (this.stateSignatures != null) {
                this.updateSessionState(this.stateSignatures, this.templateOverflow);
            }
            throw var1_3;
        }
        catch (SQLException var1_4) {
            if (this.replayContext != null) {
                this.handleReplayContext(this.replayContext);
            }
            if (this.stateSignatures != null) {
                this.updateSessionState(this.stateSignatures, this.templateOverflow);
            }
            this.connection.setExecutingRPCFunctionCode((short)0);
            this.connection.setExecutingRPCSQL(null);
            throw var1_4;
        }
        if (this.replayContext != null) {
            this.handleReplayContext(this.replayContext);
        }
        if (this.stateSignatures != null) {
            this.updateSessionState(this.stateSignatures, this.templateOverflow);
        }
        this.connection.setExecutingRPCFunctionCode((short)0);
        this.connection.setExecutingRPCSQL(null);
    }

    private final void handleReplayContext(ReplayContext replayContext) {
        if (this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.NONREQUEST)) {
            return;
        }
        assert ((replayContext.flags_kpdxcAppContCtl & 4L) != 0L || replayContext.errcode_kpdxcAppContCtl != 41406L || !this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server disabled replay with error " + replayContext.errcode_kpdxcAppContCtl + " but our replayModes=" + this.connection.replayModes;
        assert (replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 || this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server is sending a non-null replay context but our replayModes=" + this.connection.replayModes;
        if (this.connection.thinACReplayContextReceived.length == this.connection.thinACReplayContextReceivedCurrent) {
            ReplayContext[] replayContextArray = new ReplayContext[this.connection.thinACReplayContextReceived.length * 2];
            System.arraycopy(this.connection.thinACReplayContextReceived, 0, replayContextArray, 0, this.connection.thinACReplayContextReceived.length);
            this.connection.thinACReplayContextReceived = replayContextArray;
        }
        this.connection.thinACReplayContextReceived[this.connection.thinACReplayContextReceivedCurrent++] = replayContext;
        if ((replayContext.flags_kpdxcAppContCtl & 4L) == 0L && this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) {
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED);
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
        }
        if (!(replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 && this.connection.ignoreReplayContextFromAuthentication)) {
            this.connection.thinACLastReplayContextReceived = replayContext;
        }
    }

    private final void updateSessionState(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        if (this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.NONREQUEST)) {
            return;
        }
        this.connection.updateSessionState(stateSignatures, templateOverflow);
    }

    private final void processEOCS() throws SQLException, IOException {
        if (this.connection.hasServerCompileTimeCapability(15, 1)) {
            int n2;
            this.connection.eocs = n2 = (int)this.meg.unmarshalUB4();
            if ((n2 & 8) != 0) {
                long l2 = this.meg.unmarshalSB8();
            }
            if ((n2 & 0x800) != 0) {
                this.connection.setNeedsToBeClosed(true);
            }
        }
    }

    void processRPA() throws SQLException {
    }

    void readOAC() throws SQLException, IOException {
    }

    void readRSH() throws IOException, SQLException {
    }

    void readRPA() throws IOException, SQLException {
    }

    void readBVC() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readLOBD() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readIOV() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readRXH() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    boolean readRXD() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readIMPLRES() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readDCB() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void processSLG() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    private final void readSPF() throws IOException, SQLException {
        byte by = (byte)this.meg.unmarshalUB1();
        switch (by) {
            case 1: {
                int n2 = this.meg.unmarshalUB2();
                byte by2 = (byte)this.meg.unmarshalUB1();
                for (int i2 = 0; i2 < n2; ++i2) {
                    T4CTTIqcinv[] t4CTTIqcinvArray;
                    int n3;
                    T4CTTIqcinv[] t4CTTIqcinvArray2;
                    int n4;
                    this.connection.kpdqidcscn.unmarshal();
                    int n5 = this.meg.unmarshalSWORD();
                    if (n5 > 0) {
                        n4 = this.meg.unmarshalUB1();
                        t4CTTIqcinvArray2 = new T4CTTIqcinv[n5];
                        for (n3 = 0; n3 < n5; ++n3) {
                            t4CTTIqcinvArray2[n3] = new T4CTTIqcinv(this.connection);
                            t4CTTIqcinvArray2[n3].unmarshal();
                            this.connection.getResultSetCacheInternal().processCommittedInvalidation(t4CTTIqcinvArray2[n3]);
                        }
                    } else {
                        t4CTTIqcinvArray2 = null;
                    }
                    this.connection.getResultSetCacheLocalInvalidations().clear();
                    n4 = this.meg.unmarshalSWORD();
                    if (n4 > 0) {
                        n3 = (byte)this.meg.unmarshalUB1();
                        t4CTTIqcinvArray = new T4CTTIqcinv[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            t4CTTIqcinvArray[i3] = new T4CTTIqcinv(this.connection);
                            t4CTTIqcinvArray[i3].unmarshal();
                            this.connection.getResultSetCacheLocalInvalidations().add(t4CTTIqcinvArray[i3].kpdqcqid);
                        }
                    } else {
                        t4CTTIqcinvArray = null;
                    }
                    long l2 = this.meg.unmarshalUB4();
                    this.connection.setResultSetCacheVisibleSCN(this.connection.kpdqidcscn.getSCN());
                }
                break;
            }
            case 2: {
                int n6 = this.meg.unmarshalUB2();
                byte by3 = (byte)this.meg.unmarshalUB1();
                byte[] byArray = this.meg.unmarshalNBytes(n6);
                break;
            }
            case 4: {
                this.connection.ocsessret.receive();
                break;
            }
            case 5: {
                int n7 = this.meg.unmarshalUB2();
                byte by4 = (byte)this.meg.unmarshalUB1();
                T4CTTIkvarr t4CTTIkvarr = new T4CTTIkvarr(this.connection);
                t4CTTIkvarr.unmarshal();
                break;
            }
            case 7: {
                LogicalTransactionId logicalTransactionId;
                assert (this.connection.enableTGSupport || this.connection.enableACSupport) : "Driver TG/AC support is disabled but server still sent LTXID piggyback";
                byte[] byArray = this.meg.unmarshalDALC();
                int n8 = Arrays.hashCode(byArray);
                if (this.connection.thinACLastLtxidHash == n8) break;
                this.connection.thinACCurrentLTXID = logicalTransactionId = new LogicalTransactionId(byArray);
                NTFLTXIDEvent nTFLTXIDEvent = new NTFLTXIDEvent(this.connection, logicalTransactionId);
                this.connection.notify(nTFLTXIDEvent);
                this.connection.thinACLastLtxidHash = n8;
                break;
            }
            case 9: {
                int n9 = this.meg.unmarshalUB2();
                byte by5 = (byte)this.meg.unmarshalUB1();
                for (int i4 = 0; i4 < n9; ++i4) {
                    NTFXSEvent nTFXSEvent = new NTFXSEvent(this.connection);
                    this.connection.notify(nTFXSEvent);
                }
                break;
            }
            case 8: {
                int n10 = this.meg.unmarshalUB2();
                byte by6 = (byte)this.meg.unmarshalUB1();
                long l3 = this.meg.unmarshalUB4();
                long l4 = this.meg.unmarshalUB4();
                short s2 = this.meg.unmarshalUB1();
                byte[] byArray = this.meg.unmarshalDALC();
                this.replayContext = new ReplayContext(l3, s2, byArray, l4);
                break;
            }
            case 10: {
                assert (this.connection.enableACSupport) : "Driver AC support is disabled but server still sent state-signatures piggyback";
                int n11 = this.meg.unmarshalUB2();
                byte by7 = (byte)this.meg.unmarshalUB1();
                long l5 = this.meg.unmarshalSB8();
                long l6 = this.meg.unmarshalSB8();
                long l7 = this.meg.unmarshalSB8();
                if (this.connection.hasServerCompileTimeCapability(39, 15)) {
                    long l8 = this.meg.unmarshalUB4();
                    this.stateSignatures = new StateSignatures(l5, l6, l7, l8);
                    long l9 = this.meg.unmarshalSB8();
                    byte[] byArray = this.meg.unmarshalDALC();
                    long l10 = this.meg.unmarshalSB8();
                    long l11 = 64L;
                    boolean bl = (l5 & l11) == l11;
                    this.templateOverflow = new TemplateOverflow(l9, byArray, bl, l10);
                    break;
                }
                this.stateSignatures = new StateSignatures(l5, l6, l7);
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString()).fillInStackTrace();
            }
        }
    }

    void processError() throws SQLException {
        this.oer.processError();
    }

    final long getErrorCode() throws SQLException {
        return this.oer.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private void redoCursorClose() {
        if (this.connection.lastPiggyBackCursorCloseSeqNumber != 0 && this.oer.callNumber != this.connection.currentTTCSeqNumber) {
            short s2;
            short s3 = s2 = this.oer.callNumber == 127 ? (short)1 : (short)(this.oer.callNumber + 1);
            while (s2 != this.connection.currentTTCSeqNumber) {
                if (this.connection.lastPiggyBackCursorCloseSeqNumber == s2) {
                    this.connection.redoCursorClose();
                    break;
                }
                if (s2 == 127) {
                    s2 = 1;
                    continue;
                }
                s2 = (short)(s2 + 1);
            }
        }
    }

    private boolean canReplay(SQLException sQLException) {
        boolean bl = false;
        if (sQLException.getErrorCode() == 1013 || this.connection.cancelInProgressFlag && sQLException.getMessage() != null && sQLException.getMessage().contains("ORA-01013")) {
            this.connection.cancelInProgressFlag = false;
            if (this.funCode == 15 || this.funCode == 12 || this.funCode == 13 || this.funCode == 14 || this.funCode == 59) {
                if (this.oer.callNumber != this.connection.currentTTCSeqNumber || this.connection.statementCancel) {
                    bl = true;
                }
            } else if (this.connection.statementCancel && (this.connection.currentTTCSeqNumber > this.oer.callNumber || this.connection.currentTTCSeqNumber < this.oer.callNumber && this.oer.callNumber + 5 > 127)) {
                bl = true;
            }
        }
        return bl;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$31 = T4CTTIfun.class.getDeclaredConstructor(T4CConnection.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CTTIfun.class.getDeclaredMethod("canReplay", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CTTIfun.class.getDeclaredMethod("redoCursorClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CTTIfun.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CTTIfun.class.getDeclaredMethod("getErrorCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CTTIfun.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CTTIfun.class.getDeclaredMethod("readSPF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CTTIfun.class.getDeclaredMethod("processSLG", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CTTIfun.class.getDeclaredMethod("readDCB", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CTTIfun.class.getDeclaredMethod("readIMPLRES", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CTTIfun.class.getDeclaredMethod("readRXD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CTTIfun.class.getDeclaredMethod("readRXH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CTTIfun.class.getDeclaredMethod("readIOV", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CTTIfun.class.getDeclaredMethod("readLOBD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CTTIfun.class.getDeclaredMethod("readBVC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CTTIfun.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CTTIfun.class.getDeclaredMethod("readRSH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CTTIfun.class.getDeclaredMethod("readOAC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIfun.class.getDeclaredMethod("processRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIfun.class.getDeclaredMethod("processEOCS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIfun.class.getDeclaredMethod("updateSessionState", StateSignatures.class, TemplateOverflow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIfun.class.getDeclaredMethod("handleReplayContext", ReplayContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIfun.class.getDeclaredMethod("receive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIfun.class.getDeclaredMethod("ttiListString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIfun.class.getDeclaredMethod("resumeReceive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIfun.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIfun.class.getDeclaredMethod("doOneWayRPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIfun.class.getDeclaredMethod("doPigRPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIfun.class.getDeclaredMethod("doRPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIfun.class.getDeclaredMethod("marshalFunHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIfun.class.getDeclaredMethod("getFunCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIfun.class.getDeclaredMethod("setFunCode", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

