/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CSocketOutputStreamWrapper
extends NetOutputStream {
    static final int MAX_BUFFER_SIZE = 2048;
    NetOutputStream os = null;
    byte[] buffer = new byte[2048];
    int bIndex = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T4CSocketOutputStreamWrapper(NetOutputStream netOutputStream) throws IOException {
        this.os = netOutputStream;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.bIndex + 1 >= 2048) {
            this.flush();
        }
        this.buffer[this.bIndex++] = (byte)(n2 & 0xFF);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 2048) {
            this.flush();
            this.os.write(byArray, n2, n3);
        } else if (this.bIndex + n3 < 2048) {
            System.arraycopy(byArray, n2, this.buffer, this.bIndex, n3);
            this.bIndex += n3;
        } else {
            this.flush();
            System.arraycopy(byArray, n2, this.buffer, this.bIndex, n3);
            this.bIndex += n3;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean bl) throws IOException {
        if (this.bIndex > 0) {
            this.os.write(this.buffer, 0, this.bIndex);
            this.bIndex = 0;
        }
        if (bl) {
            this.os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        super.close();
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException, BreakNetException {
        this.flush(true);
        this.os.writeZeroCopyIO(byArray, n2, n3);
    }

    static {
        try {
            $$$methodRef$$$6 = T4CSocketOutputStreamWrapper.class.getDeclaredConstructor(NetOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CSocketOutputStreamWrapper.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CSocketOutputStreamWrapper.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CSocketOutputStreamWrapper.class.getDeclaredMethod("flush", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CSocketOutputStreamWrapper.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CSocketOutputStreamWrapper.class.getDeclaredMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CSocketOutputStreamWrapper.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

