/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockDescription;

public class SimpleClockDescription
implements ClockDescription {
    protected String _name;
    protected Clock _clock;
    protected long _measuredFrequency;
    protected long _resolution = -1L;
    protected double _overhead;
    static final double _computeTime = 0.1;

    protected void compDetails(Clock clock) {
        long start;
        long reportedFrequency = clock.getReportedFrequency();
        long last = start = clock.getTime();
        long curr = start;
        long diff = 0L;
        long maxRun = (long)(0.1 * (double)reportedFrequency);
        long total = 0L;
        long min = 1000000L;
        int count = 0;
        while (total < maxRun) {
            curr = clock.getTime();
            ++count;
            diff = curr - last;
            if (diff == 0L) continue;
            total += diff;
            if (min > diff) {
                min = diff;
            }
            last = curr;
        }
        this._overhead = (double)(curr - start) / (double)count;
        this._resolution = min;
        this._measuredFrequency = (long)((double)reportedFrequency / (double)min);
    }

    public String toString() {
        return this._name + " - Measured Frequency: " + this._measuredFrequency + " ticks per second";
    }

    @Override
    public void discover(Clock clock) {
        this._clock = clock;
        this._name = clock.getName();
        this.compDetails(clock);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public long getMeasuredFrequency() {
        return this._measuredFrequency;
    }

    @Override
    public long getResolution() {
        return this._resolution;
    }

    @Override
    public double getOverhead() {
        return this._overhead;
    }
}

