/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import java.lang.ref.WeakReference;
import oracle.dms.instrument.state.Value;

public class ObjectValue
extends Value {
    private volatile boolean _copy = false;
    private volatile Object _value = null;

    @Override
    public void update(Object inValue) {
        Object newValue = null;
        newValue = this._copy ? this.copy(inValue) : inValue;
        this._value = newValue == null ? null : (newValue instanceof String ? newValue : new WeakReference<Object>(newValue));
    }

    private String copy(Object newval) {
        String retVal = null;
        if (newval != null) {
            retVal = newval.toString();
        }
        return retVal;
    }

    @Override
    public synchronized void setCopy(boolean copy) {
        this._copy = copy;
        if (this._copy && this._value != null && this._value instanceof WeakReference) {
            Object referrant = ((WeakReference)this._value).get();
            this._value = referrant != null ? referrant.toString() : null;
        }
    }

    @Override
    public Object getValue() {
        Object retVal = null;
        if (this._value != null) {
            retVal = this._value instanceof WeakReference ? ((WeakReference)this._value).get() : this._value;
        }
        return retVal;
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public String toString() {
        String retVal = "";
        if (this._value != null) {
            if (this._value instanceof WeakReference) {
                Object referrant = ((WeakReference)this._value).get();
                if (referrant != null) {
                    retVal = referrant.toString();
                }
            } else {
                retVal = (String)this._value;
            }
        }
        return retVal;
    }

    @Override
    public Object clone() {
        ObjectValue retVal = (ObjectValue)super.clone();
        return retVal;
    }
}

