/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.common.AccessCheck;
import oracle.dfw.impl.common.FileComparator;
import oracle.dfw.impl.dump.ExternalUtility;

public class TempFileManager
extends Thread {
    private static final String TEMP_DIR_PREFIX = "oracle-dfw-";
    private static final String TEMP_DIR = "oracle-dfw-0";
    private static final String CLEANER_THREAD_NAME = "DFW Temporary File Cleaner";
    private static final long MIN_CHECK_INTERVAL = 1L;
    private static long s_maxSize = 0x6400000L;
    private static boolean s_privateRoot = false;
    private static boolean s_alreadyPurged = false;
    private static String s_root = null;
    private static File s_tmpDir = null;
    private static Object LOCK = new Object();
    private static byte[] s_sizeCheckLock = new byte[0];
    private static long s_minCheckInterval = 21600000L;
    private static long s_nextSizeCheckTime = System.currentTimeMillis() + s_minCheckInterval;
    private CLEANUP_MODE m_mode;
    private File m_dir;

    public static File createTempFile(String prefix, String suffix) throws IOException {
        TempFileManager.getTemporaryDirectory();
        File tmpDir = s_tmpDir;
        return AccessCheck.createTempFile(prefix, suffix, tmpDir);
    }

    private static void recursiveDelete(File rootDir) throws IOException {
        TempFileManager.recursiveDelete(rootDir, true, 0);
    }

    private static void recursiveDelete(File rootDir, boolean deleteRootDir, int level) throws IOException {
        File[] files = AccessCheck.listFiles(rootDir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (AccessCheck.isDirectory(file)) {
                    TempFileManager.recursiveDelete(file, deleteRootDir, level + 1);
                    continue;
                }
                if (AccessCheck.delete(file)) continue;
                throw new IOException("could not delete " + files[i].getAbsolutePath());
            }
        }
        if ((level != 0 || deleteRootDir) && !AccessCheck.delete(rootDir)) {
            throw new IOException("could not delete " + rootDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String root) throws IOException {
        Object object;
        if (s_tmpDir == null) {
            object = LOCK;
            synchronized (object) {
                s_root = root;
                if (s_tmpDir == null) {
                    TempFileManager.setTempDirectory();
                }
            }
        }
        try {
            object = LOCK;
            synchronized (object) {
                if (!s_alreadyPurged) {
                    Thread cleaner = null;
                    if (s_privateRoot) {
                        if (AccessCheck.isDirectory(s_tmpDir) && s_tmpDir.getName().startsWith(TEMP_DIR) && s_tmpDir.getName().indexOf("..") == -1) {
                            File tmpDirTobePurgred = new File(s_root, "oracle-dfw-0.bak");
                            if (!AccessCheck.exists(tmpDirTobePurgred)) {
                                AccessCheck.renameTo(s_tmpDir, tmpDirTobePurgred);
                                s_tmpDir = new File(s_root, "oracle-dfw-0.tmp");
                                AccessCheck.mkdirs(s_tmpDir);
                            }
                            cleaner = new TempFileManager(tmpDirTobePurgred, CLEANUP_MODE.ALL);
                        }
                    } else {
                        cleaner = new TempFileManager(new File(s_root), CLEANUP_MODE.STALE_DIRS);
                    }
                    cleaner.start();
                    s_alreadyPurged = true;
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getFrameworkLogger().log(Level.SEVERE, "failure initializing the Diagnostic Framework temporary file manager", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTemporaryDirectory() throws IOException {
        Object object;
        if (s_tmpDir == null) {
            object = LOCK;
            synchronized (object) {
                if (s_tmpDir == null) {
                    TempFileManager.setTempDirectory();
                }
            }
        }
        if (!s_tmpDir.exists()) {
            object = LOCK;
            synchronized (object) {
                TempFileManager.setTempDirectory();
            }
        }
        if (TempFileManager.isTimeToCheckSize()) {
            try {
                TempFileManager cleaner = new TempFileManager(s_tmpDir, CLEANUP_MODE.STALE_FILES);
                cleaner.start();
            }
            catch (Throwable t) {
                LoggerFactory.getFrameworkLogger().log(Level.SEVERE, "failure cleaning up stale dump files", t);
            }
        }
        return s_tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMinCheckInterval(long minInterval) {
        if (minInterval < 1L) {
            minInterval = 1L;
        }
        byte[] byArray = s_sizeCheckLock;
        synchronized (s_sizeCheckLock) {
            s_nextSizeCheckTime = System.currentTimeMillis() + minInterval;
            s_minCheckInterval = minInterval;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public static long getMinCheckInterval() {
        return s_minCheckInterval;
    }

    private static void setTempDirectory() throws IOException {
        File root = null;
        if (s_root != null && s_root.length() > 0) {
            root = new File(s_root);
            try {
                if (!AccessCheck.exists(root)) {
                    AccessCheck.mkdirs(root);
                }
            }
            catch (Throwable t) {
                LoggerFactory.getFrameworkLogger().log(Level.FINEST, "failure to create " + root, t);
            }
        }
        File tmpDir = null;
        if (root != null && AccessCheck.exists(root)) {
            tmpDir = new File(root + File.separator + TEMP_DIR + ".tmp");
            s_privateRoot = true;
        } else {
            s_privateRoot = false;
            s_root = TempFileManager.getSystemTempDir();
            root = new File(s_root);
            tmpDir = AccessCheck.createTempFile(TEMP_DIR_PREFIX, ".tmp", root);
            AccessCheck.delete(tmpDir);
            File lockFile = new File(root, tmpDir.getName() + ".lck");
            AccessCheck.createNewFile(lockFile);
            FileWriter fw = AccessCheck.createFileWriter(lockFile);
            String myPID = ExternalUtility.getMyJVMPID();
            fw.write(myPID);
            fw.close();
            AccessCheck.deleteOnExit(lockFile);
        }
        if (!tmpDir.exists() && !AccessCheck.mkdirs(tmpDir)) {
            throw new IOException("unable to create temporary directory " + tmpDir.getAbsolutePath());
        }
        s_tmpDir = tmpDir;
    }

    private static String getSystemTempDir() {
        String tmpdir = null;
        tmpdir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.io.tmpdir");
            }
        });
        if (!(tmpdir != null && tmpdir.length() != 0 || (tmpdir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        })) != null && tmpdir.length() != 0)) {
            tmpdir = ".";
        }
        return tmpdir;
    }

    @Override
    public void run() {
        try {
            switch (this.m_mode) {
                case STALE_DIRS: {
                    this.purgeStaleDirectories();
                    break;
                }
                case STALE_FILES: {
                    this.purgeStaleFiles();
                    break;
                }
                case ALL: {
                    try {
                        TempFileManager.recursiveDelete(this.m_dir);
                        break;
                    }
                    catch (IOException ex) {
                        LoggerFactory.getFrameworkLogger().log(Level.FINE, "unable to delete " + this.m_dir.getAbsolutePath(), ex);
                    }
                }
            }
        }
        catch (Throwable th) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "failure cleaning temporary files", th);
        }
    }

    private void purgeStaleDirectories() {
        try {
            FileFilter tmpDirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return AccessCheck.isDirectory(pathname) && pathname.getName().startsWith(TempFileManager.TEMP_DIR_PREFIX);
                }
            };
            File[] tmpFiles = AccessCheck.listFiles(this.m_dir, tmpDirFilter);
            String myPID = ExternalUtility.getMyJVMPID();
            ArrayList<String> pids = ExternalUtility.getAllJVMPIDS();
            for (int i = 0; i < tmpFiles.length; ++i) {
                File tmpFile = tmpFiles[i];
                File lockFile = new File(tmpFile.getParent(), tmpFile.getName() + ".lck");
                boolean toBeRemoved = false;
                if (pids != null && AccessCheck.exists(lockFile)) {
                    try {
                        LineNumberReader rd = new LineNumberReader(AccessCheck.createFileReader(lockFile));
                        String ownerPID = rd.readLine();
                        rd.close();
                        if (ownerPID == null) {
                            toBeRemoved = false;
                        } else if (!myPID.equals(ownerPID = ownerPID.trim()) && !pids.contains(ownerPID)) {
                            toBeRemoved = true;
                            AccessCheck.delete(lockFile);
                        }
                    }
                    catch (Exception ex) {
                        toBeRemoved = false;
                    }
                }
                if (AccessCheck.exists(lockFile) && !toBeRemoved) continue;
                if (LoggerFactory.getFrameworkLogger().isLoggable(Level.FINEST)) {
                    LoggerFactory.getFrameworkLogger().log(Level.FINEST, "deleting stale directory " + tmpFile);
                }
                try {
                    TempFileManager.recursiveDelete(tmpFile);
                    continue;
                }
                catch (IOException ex) {
                    LoggerFactory.getFrameworkLogger().log(Level.FINE, "unable to delete " + tmpFile.getAbsolutePath(), ex);
                }
            }
        }
        catch (Throwable t) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "failure removing stale Diagnostic Framework temporary files", t);
        }
    }

    private void purgeStaleFiles() {
        ArrayList<File> files = new ArrayList<File>();
        long size = this.recursiveFindTempFiles(this.m_dir, files);
        if (size > s_maxSize) {
            Collections.sort(files, new FileComparator());
            while (size > s_maxSize && files.size() > 0) {
                File f = files.remove(0);
                size -= AccessCheck.length(f);
                AccessCheck.delete(f);
            }
        }
    }

    private long recursiveFindTempFiles(File tmpDir, ArrayList<File> files) {
        long size = 0L;
        try {
            File[] tmpFiles = AccessCheck.listFiles(tmpDir);
            if (tmpFiles == null) {
                return 0L;
            }
            for (int i = 0; i < tmpFiles.length; ++i) {
                File tmpFile = tmpFiles[i];
                if (tmpFile == null || !AccessCheck.exists(tmpFile)) continue;
                if (AccessCheck.isDirectory(tmpFile)) {
                    if ("sampling".equals(tmpFile.getName())) continue;
                    size += this.recursiveFindTempFiles(tmpFile, files);
                    continue;
                }
                size += AccessCheck.length(tmpFile);
                files.add(tmpFile);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "failure searching stale dump files", t);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTimeToCheckSize() {
        boolean isPurgingTime = false;
        byte[] byArray = s_sizeCheckLock;
        synchronized (s_sizeCheckLock) {
            long currentTime = System.currentTimeMillis();
            if (currentTime > s_nextSizeCheckTime) {
                s_nextSizeCheckTime = currentTime + s_minCheckInterval;
                isPurgingTime = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return isPurgingTime;
        }
    }

    public static void setMaxSize(long size) {
        if (size > 0L) {
            s_maxSize = size;
        } else {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "Ignore invalid size: " + size);
        }
    }

    public static long getMaxSize() {
        return s_maxSize;
    }

    TempFileManager(File dir, CLEANUP_MODE mode) {
        this.m_dir = dir;
        this.m_mode = mode;
        this.setDaemon(true);
        this.setName("DFW Temporary File Cleaner-" + (Object)((Object)mode));
    }

    private static enum CLEANUP_MODE {
        STALE_DIRS,
        STALE_FILES,
        ALL;

    }
}

