/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.producer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import oracle.dms.config.CollectorConfig;
import oracle.dms.producer.MetricConvertor;
import oracle.dms.producer.RowInfo;

public class JseMetricConvertor
extends MetricConvertor {
    public JseMetricConvertor(MBeanServerConnection mbeanServer, CollectorConfig collectorConfig, ScheduledExecutorService dmsTimer) {
        super(mbeanServer, null, collectorConfig, dmsTimer);
    }

    @Override
    protected String getSpyCategory() {
        return "JseServer";
    }

    @Override
    public List<RowInfo> getRowInfos(Set<ObjectName> objNames, MBeanServerConnection mbeanServer) {
        String METHOD_NAME = "getRowInfos";
        ArrayList<RowInfo> rowInfos = new ArrayList<RowInfo>();
        if (objNames == null) {
            return rowInfos;
        }
        for (ObjectName objName : objNames) {
            try {
                MBeanAttributeInfo[] attrInfos;
                RowInfo rowInfo;
                MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objName);
                String domainName = objName.getDomain();
                if (mbeanInfo == null || "oracle.dms".equals(domainName)) continue;
                Descriptor descriptor = mbeanInfo.getDescriptor();
                String interfaceClassName = (String)descriptor.getFieldValue("interfaceClassName");
                boolean isJavaMBean = "java.lang".equals(domainName);
                if (this.containsRowInfo(objName) && (isJavaMBean || interfaceClassName != null)) continue;
                String typeName = (String)descriptor.getFieldValue("DiagnosticTypeName");
                if ((typeName == null || typeName.trim().length() == 0) && isJavaMBean) {
                    typeName = interfaceClassName;
                }
                if ((rowInfo = this.getRowInfo(typeName, objName, attrInfos = mbeanInfo.getAttributes(), mbeanServer)) == null) continue;
                rowInfos.add(rowInfo);
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.logp(Level.FINE, this.getClass().getName(), "getRowInfos", "Exception occurred when examining MBean: " + objName, e);
            }
        }
        return rowInfos;
    }
}

