/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.io.Serializable;
import oracle.dms.reporter.TbmlReporter;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.NameSupport;

public class ColumnDefinitionSupport
extends NameSupport
implements ColumnDefinition {
    private SchemaSupport m_schema = null;
    private String m_unit = null;
    private String m_description = null;
    private static final long serialVersionUID = -1150676720292L;

    public ColumnDefinitionSupport(SchemaSupport schema, String name, String description, String unit) {
        super(name);
        if (schema == null) {
            throw new IllegalArgumentException(" schema=" + schema + " description=" + description + " unit=" + unit);
        }
        this.m_schema = schema;
        this.m_description = description;
        this.m_unit = unit;
        this.m_schema.addColumnDefinition(this);
    }

    @Override
    public String getUnit() {
        return this.m_unit;
    }

    public boolean hasUnit() {
        return this.m_unit != null && this.m_unit.trim().length() > 0;
    }

    public void setUnit(String unit) {
        if (unit != null && unit.trim().length() > 0) {
            this.m_unit = unit;
        }
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public boolean hasDescription() {
        return this.m_description != null && this.m_description.trim().length() > 0;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getType() {
        return this.getTypeID().toString();
    }

    @Override
    public ValueType getTypeID() {
        return ((TableSupport)this.m_schema.getTable()).getColumnType(this.m_name);
    }

    @Override
    public boolean isKey() {
        return this.m_schema.getTable().containsKey(this.m_name);
    }

    public ColumnDefinitionSupport clone(SchemaSupport schema, boolean includeDescriptions) {
        ColumnDefinitionSupport clone = null;
        try {
            clone = (ColumnDefinitionSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (schema != null) {
            clone.m_schema = schema;
        }
        if (!includeDescriptions) {
            clone.m_description = null;
        }
        return clone;
    }

    public static ValueType getValueTypeCode(String type) {
        if (type == null) {
            return ValueType.STRING;
        }
        type = type.toUpperCase();
        try {
            return ValueType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            return ValueType.UNKNOWN;
        }
    }

    public static ValueType getValueTypeCodeByClass(Serializable value) {
        if (value == null) {
            return ValueType.UNKNOWN;
        }
        if (value instanceof Integer) {
            return ValueType.INTEGER;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        if (value instanceof Long) {
            return ValueType.LONG;
        }
        if (value instanceof String) {
            return ValueType.STRING;
        }
        return ValueType.UNKNOWN;
    }

    protected void printTbml(PrintWriter out) {
        String type = this.getType();
        TbmlReporter.printColumnDefinition(this.m_name, type, this.m_unit, this.m_description, out);
    }

    protected int size() {
        int size = 0;
        if (this.m_unit != null) {
            size += this.m_unit.length();
        }
        if (this.m_description != null) {
            size += this.m_description.length();
        }
        return size;
    }
}

