/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.statistics;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.dms.statistics.DataPoint1D;
import oracle.dms.statistics.Statistics1D;

public class Histogram1D<N extends Number, T> {
    static AtomicInteger idCounter = new AtomicInteger();
    private LinkedList<DataPoint1D<N, T>> mRawDataPoint1Ds;
    private List<HistogramBin<N, T>> mHistogramBins;
    private Statistics1D<N> mStatistics;
    private String mId = "histogram" + idCounter.incrementAndGet();
    private double mBinSize;
    private String mFormatString;

    public static <N extends Number, T> Histogram1D<N, T> create(List<DataPoint1D<N, T>> data, int numBins) {
        if (numBins == 0) {
            throw new IllegalArgumentException("Can not create a histogram with zero bins.");
        }
        if (data.size() == 0) {
            throw new IllegalArgumentException("Can not create a histogram without any data.");
        }
        return new Histogram1D<N, T>(data, numBins);
    }

    private Histogram1D(List<DataPoint1D<N, T>> data, int numBins) {
        this.mRawDataPoint1Ds = new LinkedList();
        LinkedList<N> numberList = new LinkedList<N>();
        for (DataPoint1D<N, T> dp : data) {
            this.mRawDataPoint1Ds.add(dp);
            numberList.add(dp.getValue());
        }
        this.mStatistics = Statistics1D.create(numberList);
        this.calculateBinnedData(numBins);
    }

    public int getDataPointCount() {
        return this.mRawDataPoint1Ds.size();
    }

    public Statistics1D<N> getStatistics() {
        return this.mStatistics;
    }

    public double getBinSize() {
        return this.mBinSize;
    }

    public List<HistogramBin<N, T>> getBins() {
        return this.mHistogramBins;
    }

    public String getId() {
        return this.mId;
    }

    public String getFormatStringForBins() {
        if (this.mFormatString == null) {
            double maxAbsValue = ((Number)this.mStatistics.getMaxAbsValue()).doubleValue();
            if (maxAbsValue == 0.0) {
                maxAbsValue = 1.0;
            }
            long magnitudeOfNumbers = (long)Math.floor(Math.log10(maxAbsValue));
            long magnitudeOfDelta = (long)Math.floor(Math.log10(this.mBinSize));
            if (magnitudeOfDelta <= 0L) {
                long decimalPlaces = Math.abs(magnitudeOfDelta) + 1L;
                this.mFormatString = "%" + (magnitudeOfNumbers + 1L + decimalPlaces + 1L) + "." + decimalPlaces + "f";
            } else {
                this.mFormatString = "%" + (magnitudeOfNumbers + 1L) + ".0f";
            }
        }
        return this.mFormatString;
    }

    private void calculateBinnedData(int numBins) {
        this.mHistogramBins = new LinkedList<HistogramBin<N, T>>();
        int absNumBins = Math.abs(numBins);
        if (absNumBins == 1) {
            this.mHistogramBins.add(new HistogramBin(this, ((Number)this.mStatistics.getMinValue()).doubleValue(), ((Number)this.mStatistics.getMaxValue()).doubleValue()));
            this.mBinSize = ((Number)this.mStatistics.getMaxValue()).doubleValue() - ((Number)this.mStatistics.getMinValue()).doubleValue();
        } else {
            boolean bl;
            this.mBinSize = 1.0;
            double midPoint = 1.0;
            boolean bl2 = bl = numBins > 0;
            if (bl) {
                if (this.mStatistics.getAveAbsDeviation() > 0.0) {
                    this.mBinSize = this.mStatistics.getAveAbsDeviation();
                }
                midPoint = this.mStatistics.getAverage();
            } else {
                if (Statistics1D.gt(this.mStatistics.getMaxValue(), this.mStatistics.getMinValue())) {
                    this.mBinSize = (((Number)this.mStatistics.getMaxValue()).doubleValue() - ((Number)this.mStatistics.getMinValue()).doubleValue()) / (double)absNumBins;
                }
                midPoint = (((Number)this.mStatistics.getMaxValue()).doubleValue() + ((Number)this.mStatistics.getMinValue()).doubleValue()) / 2.0;
            }
            double lowerBinEdge = midPoint - (double)absNumBins * this.mBinSize / 2.0;
            for (int binCount = 0; binCount < absNumBins; ++binCount) {
                double upperBinEdge;
                double upperBinEdgeToUse = upperBinEdge = lowerBinEdge + this.mBinSize;
                double lowerBinEdgeToUse = lowerBinEdge;
                if (binCount == 0) {
                    lowerBinEdgeToUse = -1.7976931348623157E308;
                }
                if (binCount == absNumBins - 1) {
                    upperBinEdgeToUse = Double.MAX_VALUE;
                }
                this.mHistogramBins.add(new HistogramBin(this, lowerBinEdgeToUse, upperBinEdgeToUse));
                lowerBinEdge = upperBinEdge;
            }
        }
        HistogramBin<N, T> lastBin = this.mHistogramBins.get(this.mHistogramBins.size() - 1);
        block1: for (DataPoint1D dataPoint1D : this.mRawDataPoint1Ds) {
            for (HistogramBin<N, T> hb : this.mHistogramBins) {
                if (hb != lastBin) {
                    if (!(((Number)dataPoint1D.mValue).doubleValue() >= hb.mLowValue) || !(((Number)dataPoint1D.mValue).doubleValue() < hb.mHighValue)) continue;
                    hb.add(dataPoint1D);
                    continue block1;
                }
                if (!(((Number)dataPoint1D.mValue).doubleValue() >= hb.mLowValue) || !(((Number)dataPoint1D.mValue).doubleValue() <= hb.mHighValue)) continue;
                hb.add(dataPoint1D);
                continue block1;
            }
        }
    }

    public static class HistogramBin<N extends Number, T> {
        Histogram1D mParent;
        List<DataPoint1D<N, T>> mDataPoints = new LinkedList<DataPoint1D<N, T>>();
        Statistics1D<N> mStatistics;
        double mLowValue;
        double mHighValue;
        N mTotalValue;
        static AtomicInteger idCounter = new AtomicInteger();
        String mId;

        HistogramBin(Histogram1D<N, T> parent, double lowValue, double highValue) {
            this.mParent = parent;
            this.mLowValue = lowValue;
            this.mHighValue = highValue;
            this.mId = ((Histogram1D)parent).mId + "_bin" + idCounter.incrementAndGet();
        }

        public int getDataPointCount() {
            return this.mDataPoints.size();
        }

        public List<DataPoint1D<N, T>> getDataPoints() {
            return this.mDataPoints;
        }

        public float getPercentage() {
            return (float)this.mDataPoints.size() * 100.0f / (float)this.mParent.mRawDataPoint1Ds.size();
        }

        void add(DataPoint1D<N, T> hdp) {
            this.mDataPoints.add(hdp);
        }

        public String getId() {
            return this.mId;
        }

        public String toString() {
            return this.mId + " [" + this.mLowValue + ", " + this.mHighValue + ") " + this.mDataPoints.size();
        }

        public Statistics1D<N> getStatistics() {
            if (this.mStatistics == null) {
                this.mStatistics = Statistics1D.createFromDataPoints(this.mDataPoints);
            }
            return this.mStatistics;
        }
    }
}

