/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.as.management.translation.NLSupport;

public abstract class DMSNLSupport {
    public static final String DMS_MESSAGE_FILE = "oracle.dms.util.dms";
    public static final Logger DMS_UTIL_LOGGER = Logger.getLogger("oracle.dms.util", "oracle.dms.util.dms");

    public static String getString(String key) {
        return DMSNLSupport.getString(key, null);
    }

    public static String getString(String key, String defaultString) {
        return DMSNLSupport.getString(key, defaultString, null);
    }

    public static String getString(String key, String defaultString, Locale locale) {
        String translation;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NLSupport nls = NLSupport.getNLSupport(DMS_MESSAGE_FILE, DMSNLSupport.class.getClassLoader());
        try {
            translation = nls.getTranslation(key, locale);
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
        if (translation == null || translation.trim().length() == 0) {
            return defaultString;
        }
        return translation;
    }

    public static String getMessage(String key, Object[] args) {
        return DMSNLSupport.getMessage(key, args, null);
    }

    public static String getMessage(String key, Object[] args, String defaultString) {
        return DMSNLSupport.getMessage(key, args, defaultString, null);
    }

    public static String getMessage(String key, Object[] args, String defaultString, Locale locale) {
        String translation;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NLSupport nls = NLSupport.getNLSupport(DMS_MESSAGE_FILE, DMSNLSupport.class.getClassLoader());
        try {
            translation = nls.getTranslation(key, args, locale);
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
        if (translation == null || translation.trim().length() == 0) {
            return defaultString;
        }
        return translation;
    }

    private DMSNLSupport() {
    }

    public static void warnOldParameterInUse(Logger logger, String[] oldPropertyNames, String[] newPropertyNames) {
        DMSNLSupport.warnParameterUseage(logger, "DMS-50976", oldPropertyNames, newPropertyNames);
    }

    public static void warnMixedVintageParameterInUse(Logger logger, String[] oldPropertyNames, String[] newPropertyNames) {
        DMSNLSupport.warnParameterUseage(logger, "DMS-50977", oldPropertyNames, newPropertyNames);
    }

    private static void warnParameterUseage(Logger logger, String key, String[] oldPropertyNames, String[] newPropertyNames) {
        if (oldPropertyNames == null || newPropertyNames == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append(oldPropertyNames[0]);
        for (int i = 1; i < oldPropertyNames.length; ++i) {
            sb.append(',').append(oldPropertyNames[i]);
        }
        String oldNames = sb.toString();
        sb = new StringBuilder(1024);
        sb.append(newPropertyNames[0]);
        for (int i = 1; i < newPropertyNames.length; ++i) {
            sb.append(", ").append(newPropertyNames[i]);
        }
        String newNames = sb.toString();
        LogRecord record = new LogRecord(Level.WARNING, key);
        record.setParameters(new Object[]{oldNames, newNames});
        record.setResourceBundle(DMS_UTIL_LOGGER.getResourceBundle());
        logger.log(record);
    }
}

