/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import oracle.dms.instrument.Noun;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.TreeletOptions;
import oracle.dms.util.Indentation;

class NounTreeletNode
extends BranchTreeletNode<Noun> {
    NounTreeletNode(Noun root) {
        super(root);
    }

    NounTreeletNode(String name, NounTreeletNode parent, Noun mappedNode) {
        super(name, parent, mappedNode);
        parent.addBranch(this.m_name, this);
    }

    @Override
    public String getTable() {
        Noun noun = (Noun)this.m_mappedNode;
        return noun.getType();
    }

    @Override
    protected void startPrintNode(TreeletOptions options, PrintWriter out) {
        String format = options.getFormat();
        if ("pdml".equals(format)) {
            out.print("<noun name='");
            out.print(this.getName());
            out.print("' type='");
            out.print(this.getTable());
            out.print("'>\n");
        } else {
            Indentation indent = options.getIndentation();
            indent.indent(out);
            out.print(this.toString());
            out.print(" [type=");
            out.print(this.getTable());
            out.println(']');
        }
    }

    @Override
    protected void endPrintNode(TreeletOptions options, PrintWriter out) {
        String format = options.getFormat();
        if ("pdml".equals(format)) {
            out.print("</noun>\n");
        }
    }
}

