/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.EnumMap;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.DomainExecutionContextStub;

public class ExecutionContextStub
extends ExecutionContext {
    private static EnumMap<StubType, ExecutionContextStub> sTheStubs = new EnumMap(StubType.class);

    private ExecutionContextStub(DomainExecutionContextStub domainContext) {
        super(domainContext);
    }

    public static ExecutionContextStub getTheStub(StubType stubType) {
        return sTheStubs.get((Object)stubType);
    }

    static {
        for (StubType stubType : StubType.values()) {
            sTheStubs.put(stubType, new ExecutionContextStub(DomainExecutionContextStub.getTheStub(stubType)));
        }
    }

    public static enum StubType {
        DISABLED("_disabled_", "The stub implementation for when DMS ExecutionContext is disabled or not initialized."),
        UNAVAILABLE_DUE_TO_ERROR("_unavailable_", "The stub implementation used when an error has prevented use of a domain-specific implementation."),
        UNKNOWN("_unknown_", "The stub implementation used when an unanticipated condition has been encountered.");

        private String mECID;
        private String mDescription;

        private StubType(String ECID, String description) {
            this.mECID = ECID;
            this.mDescription = description;
        }

        public String getECID() {
            return this.mECID;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

