/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import oracle.dms.event.Event;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventType;
import oracle.dms.event.Filter;

public class EventSourceTypeFilter
implements Filter {
    private EventType[] mEventTypes;
    private int mSourceTypeBits;
    private String mName;
    private String mId;

    public EventSourceTypeFilter(String name, String id, EventSourceType[] sourceTypes) {
        this.mName = name;
        this.mId = id;
        this.mEventTypes = EventType.getEventTypesForSourceTypes(sourceTypes);
        block0: for (EventSourceType s : EventSourceType.values()) {
            for (EventSourceType sourceType : sourceTypes) {
                if (!sourceType.isTypeOf(s)) continue;
                this.mSourceTypeBits |= 1 << s.ordinal();
                continue block0;
            }
        }
    }

    @Override
    public boolean applyFilter(Event event) {
        return (1 << event.getSourceType().ordinal() & this.mSourceTypeBits) != 0;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        return this.mEventTypes;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean willDiscriminateAgainstNounType(String nounType) {
        return false;
    }
}

