/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import oracle.dms.ParameterDescriptor;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.DMSContextManager;
import oracle.dms.http.DmsServletRequest;
import oracle.dms.http.Request;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.internal.ParamScopedMetricsConfig;
import oracle.dms.instrument.internal.ParamScopedMetricsConfigManager;
import oracle.dms.instrument.internal.ParamScopedMetricsSystem;
import oracle.dms.reporter.TableReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnGroup;
import oracle.dms.table.NullValue;
import oracle.dms.table.Row;
import oracle.dms.table.RowComparator;
import oracle.dms.table.Schema;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.TableName;
import oracle.dms.table.TableSource;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.NetUtil;
import oracle.dms.util.QueryOptions;
import oracle.dms.util.URIUtils;

public class MetricTableReporter
extends TableReporter {
    private static final String TIME = ".time";
    private static final String VALUE = ".value";
    static final String SPACE = "&nbsp;";
    static final String RAW_FORMAT = "?format=raw";
    static final String HTML_FORMAT = "?format=html";
    static final String LIST_FORMAT = "?format=metriclist";
    static final String TABLE_FORMAT = "?format=metrictable";
    static final String HELP_FORMAT = "?format=metrichelp";
    static final String QUERY_SCHEMA = "&value=false&units=true&description=true";
    private static final String BYPASS_CACHE = "&cache=false&prefetch=false";
    public static final String METRIC_TABLE_FRAME = "metricTableFrame";
    private static NumberFormat s_numFormat0 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static NumberFormat s_numFormat1 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static NumberFormat s_numFormat2 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static NumberFormat s_numFormat3 = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private boolean m_tableContents = true;
    static final String COPY_RIGHT = "Copyright &copy; 2002, 2013, Oracle and/or its affiliates. All rights reserved.";

    public MetricTableReporter(TableSource tableSource, Request request) {
        super(tableSource, request);
    }

    @Override
    protected void setQueryOptions() {
        super.setQueryOptions();
        this.m_options.setQueryType(QueryOptions.QueryType.ALL);
    }

    @Override
    protected void printHeading(PrintWriter out) {
        MetricTableReporter.printHTMLStart(out);
        out.println("</head><body>");
        Collection oldTables = this.m_tables;
        this.m_tables = new TreeSet(this.m_tables);
        oldTables.clear();
        if (this.m_tables.size() > 1) {
            this.m_tableContents = false;
            MetricTableReporter.printBanner("<a name=top>" + DMSNLSupport.getString("TV_CONTENTS", "Contents") + "</a>", this.m_request, out);
            out.print("<ol>");
            for (Table table : this.m_tables) {
                String name = table.getName();
                out.print("<li><a");
                MetricTableReporter.printTableSort(name, DMSUtil.urlXssEscape(this.m_request.getRequestURI()), out);
                out.print(" target=");
                out.print(METRIC_TABLE_FRAME);
                out.print('>');
                out.print(name);
                out.println("</a>");
            }
            out.println("</ol><p>");
        }
    }

    @Override
    protected void printEnding(PrintWriter out) {
        out.print("<hr>");
        out.print(new Date());
        out.print("<br>");
        out.print(DMSNLSupport.getString("TV_COPY_RIGHT", COPY_RIGHT));
        out.println("</body></html>");
    }

    @Override
    protected void printTable(Table table, PrintWriter out) {
        if (!this.m_tableContents) {
            return;
        }
        String name = table.getName();
        MetricTableReporter.printBanner("<a name=top>" + DMSUtil.xssEscape(name) + "</a>", this.m_request, out);
        SchemaSupport schema = (SchemaSupport)table.getSchema();
        if (schema != null) {
            Object[] sensors = schema.getColumnGroupNames();
            String[][] metrics = null;
            if (sensors != null) {
                Arrays.sort(sensors);
                metrics = new String[sensors.length][];
            }
            String[] properties = MetricTableReporter.getTableHeader(schema, (String[])sensors, metrics);
            MetricTableReporter.printTableStart(1, 1, out, 100);
            this._printDataHeader(table, schema, (String[])sensors, metrics, properties, out);
            this._printDataRows(table, schema, (String[])sensors, metrics, properties, out);
            out.print("</table>");
        }
        out.print("<a href=\"#top\">");
        out.print(DMSNLSupport.getString("TV_TOP", "Top"));
        out.print("</a> | ");
        this._printMetricHelp(name, out);
        out.println("<p>");
        this._printParamScopedMetricOptions(name, DMSUtil.urlXssEscape(this.m_request.getRequestURI()), out);
        out.println("<p>");
        this._printVariables(schema, name, out);
    }

    @Override
    protected void printBadParams(Collection<String> badNames, Collection<String> badTables, PrintWriter out) {
    }

    @Override
    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    static String[] getTableHeader(Schema schema, String[] sensors, String[][] metrics) {
        if (schema == null) {
            return new String[0];
        }
        TreeSet<String> propertySet = new TreeSet<String>();
        Enumeration<? extends ColumnDefinition> iter = schema.enumerateColumnDefinitions(false);
        while (iter.hasMoreElements()) {
            ColumnDefinition cdef = iter.nextElement();
            propertySet.add(cdef.getName());
        }
        if (sensors != null) {
            Arrays.sort(sensors);
            for (int i = 0; i < sensors.length; ++i) {
                if (sensors[i] == null) continue;
                ColumnGroup group = schema.getColumnGroup(sensors[i]);
                metrics[i] = group.getMemberNames();
                if (metrics[i] == null) continue;
                Arrays.sort(metrics[i]);
                for (String metric : metrics[i]) {
                    propertySet.remove(metric);
                }
            }
        }
        propertySet.remove("Name");
        propertySet.remove("Host");
        propertySet.remove("Process");
        propertySet.remove("Parent");
        propertySet.remove("ObjectName");
        String[] properties = new String[propertySet.size()];
        propertySet.toArray(properties);
        return properties;
    }

    private void _printMetricHelp(String table, PrintWriter out) {
        out.print("<a");
        this._printTableLink(table, "metrichelp", out);
        out.print(QUERY_SCHEMA);
        out.println("\" ");
        MetricTableReporter.printStatusLine(DMSNLSupport.getString("TV_METRICS_DEFS", "Metric Definitions"), out);
        out.print('>');
        out.print(DMSNLSupport.getString("TV_METRICS_DEFS", "Metric Definitions"));
        out.println("</a>");
    }

    private void _printDataRows(Table table, Schema schema, String[] sensors, String[][] metrics, String[] properties, PrintWriter out) {
        boolean lightBG = true;
        RowComparator orderBy = this._getComparator(schema);
        Enumeration<? extends Row> iter = table.enumerateRows(orderBy);
        while (iter.hasMoreElements()) {
            Row row = iter.nextElement();
            int maxMetrics = 1;
            if (metrics != null) {
                for (String[] metric : metrics) {
                    if (metric == null || metric.length <= maxMetrics) continue;
                    maxMetrics = metric.length;
                }
            }
            this._printDataRow(row, schema, lightBG, sensors, metrics, maxMetrics, properties, out);
            lightBG = !lightBG;
        }
    }

    private void _printDataRow(Row row, Schema schema, boolean lightBG, String[] sensors, String[][] metrics, int maxMetrics, String[] properties, PrintWriter out) {
        for (int i = 0; i < maxMetrics; ++i) {
            MetricTableReporter.printRowStart(lightBG, out);
            if (i == 0) {
                if (schema.containsColumn("Name")) {
                    MetricTableReporter.printDataCell(row.getValue("Name"), maxMetrics, true, out);
                }
                if (schema.containsColumn("Host")) {
                    MetricTableReporter.printDataCell(row.getValue("Host"), maxMetrics, true, out);
                }
                if (schema.containsColumn("Process")) {
                    MetricTableReporter.printDataCell(row.getValue("Process"), maxMetrics, true, out);
                }
            }
            if (sensors != null) {
                for (int j = 0; j < sensors.length; ++j) {
                    int size;
                    if (sensors[j] == null || metrics[j] == null || (size = metrics[j].length) == 0 || i >= size) continue;
                    Serializable value = row.getValue(metrics[j][i]);
                    ColumnDefinition mdesc = schema.getColumnDefinition(metrics[j][i]);
                    String unit = null;
                    if (mdesc != null) {
                        unit = mdesc.getUnit();
                    }
                    String displayName = metrics[j][i];
                    int index = metrics[j][i].indexOf(sensors[j]);
                    if (index >= 0 && index < metrics[j][i].length() - sensors[j].length()) {
                        displayName = metrics[j][i].substring(index + sensors[j].length());
                    }
                    if (displayName.startsWith(".")) {
                        displayName = displayName.substring(1);
                    }
                    if (unit != null && unit.trim().length() > 0) {
                        displayName = displayName + ", " + unit;
                    }
                    int rowspan = 1;
                    if (size == i + 1) {
                        rowspan = maxMetrics - i;
                    }
                    if (size > 1) {
                        MetricTableReporter.printDataCell(displayName, rowspan, true, out);
                    }
                    MetricTableReporter.printDataCell(value, rowspan, true, out);
                }
            }
            if (i == 0) {
                for (String property : properties) {
                    if (property == null) continue;
                    Serializable propertyVal = row.getValue(property);
                    MetricTableReporter.printDataCell(propertyVal, maxMetrics, true, out);
                }
            }
            out.print("</tr>");
        }
    }

    private void _printDataHeader(Table table, Schema schema, String[] sensors, String[][] metrics, String[] properties, PrintWriter out) {
        String description;
        String tableName = table.getName();
        out.print("<tr>");
        if (schema.containsColumn("Name")) {
            this._printHeaderCell("Name", DMSNLSupport.getString("QU_Name"), tableName, "Name", 1, this.isSortable(table, "Name"), out);
        }
        if (schema.containsColumn("Host")) {
            this._printHeaderCell("Host", DMSNLSupport.getString("QU_Host"), tableName, "Host", 1, this.isSortable(table, "Host"), out);
        }
        if (schema.containsColumn("Process")) {
            this._printHeaderCell("Process", DMSNLSupport.getString("QU_Process"), tableName, "Process", 1, this.isSortable(table, "Process"), out);
        }
        if (sensors != null) {
            for (int i = 0; i < sensors.length; ++i) {
                boolean isSortable;
                ColumnDefinition mdesc;
                String orderBy;
                int colspan;
                int size;
                if (sensors[i] == null || metrics[i] == null || (size = metrics[i].length) == 0) continue;
                String name = sensors[i];
                description = null;
                if (size == 1) {
                    colspan = 1;
                    orderBy = metrics[i][0];
                    mdesc = schema.getColumnDefinition(orderBy);
                    String unit = null;
                    if (mdesc != null) {
                        description = mdesc.getDescription();
                        unit = mdesc.getUnit();
                    }
                    if (unit != null && unit.trim().length() > 0) {
                        name = sensors[i] + ", " + unit;
                    }
                    isSortable = this.isSortable(table, orderBy);
                } else {
                    colspan = 2;
                    orderBy = this._getOrderByMetric(metrics[i]);
                    mdesc = schema.getColumnDefinition(orderBy);
                    if (mdesc != null) {
                        description = mdesc.getDescription();
                    }
                    isSortable = this.isSortable(table, orderBy);
                }
                this._printHeaderCell(name, description, tableName, orderBy, colspan, isSortable, out);
            }
        }
        for (String property : properties) {
            if (property == null) continue;
            ColumnDefinition mdesc = schema.getColumnDefinition(property);
            description = null;
            if (mdesc != null) {
                description = mdesc.getDescription();
            }
            this._printHeaderCell(property, description, tableName, property, 1, this.isSortable(table, property), out);
        }
        out.print("</tr>");
    }

    private void _printTableSort(String table, String orderBy, PrintWriter out) {
        String format = "metrictable";
        if ("metrictable".equals(format)) {
            format = format + BYPASS_CACHE;
        }
        this._printTableLink(table, format + '&' + "orderby" + '=' + orderBy, out);
        out.print("\"  onClick=\"top.orderby='");
        out.print(orderBy);
        out.println("';\" ");
    }

    private void _printTableLink(String table, String format, PrintWriter out) {
        out.print(" href=\"");
        out.print(DMSUtil.urlXssEscape(this.m_request.getRequestURI()));
        out.print('?');
        out.print("format");
        out.print('=');
        out.print(format);
        if (table != null && table.trim().length() > 0) {
            out.print('&');
            out.print("table");
            out.print('=');
            out.print(table);
        }
    }

    static void printTableSort(String table, String uri, PrintWriter out) {
        String link = MetricTableReporter.getTableSort(table, uri);
        out.println(link);
    }

    static String getTableSort(String table, String uri) {
        StringBuilder url = new StringBuilder(uri);
        url.append(TABLE_FORMAT);
        url.append(BYPASS_CACHE);
        if (table != null) {
            url.append('&');
            url.append("table");
            url.append('=');
            url.append(table);
        }
        String urlString = url.toString();
        StringBuilder buf = new StringBuilder(" href=\"");
        buf.append(urlString);
        buf.append("\" onClick=\"this.href='");
        buf.append(urlString);
        buf.append('&');
        buf.append("orderby");
        buf.append("='+top.orderby;\" ");
        return buf.toString();
    }

    static void printBanner(String banner, Request request, PrintWriter out) {
        boolean isLogout;
        MetricTableReporter.printTableStart(0, 0, out, 100);
        MetricTableReporter.printRowStart(true, out);
        out.print("<td class=banner valign=bottom><font size=+1>");
        out.print(banner);
        out.println("</font></td>");
        if (request instanceof DmsServletRequest && (isLogout = ((DmsServletRequest)request).isLogout())) {
            String contextPath = ((DmsServletRequest)request).getContextPath();
            out.println("<td class=banner align=right><a href=\"");
            out.println(contextPath);
            out.println("/logout.jsp\">");
            out.println(DMSNLSupport.getString("TV_LOGOUT", "Logout"));
            out.println("</a></td>");
        }
        out.println("</tr></table><p>");
    }

    static void printStyleSheet(PrintWriter out) {
        out.println("<style type=\"text/css\">\n<!--");
        out.print("body, td, th {font-family:Tahoma, Verdana, Helvetica, sans-serif;");
        out.println("font-weight:normal;font-size:11px;}");
        out.println("body {background-color:#FFFFFF;}");
        out.println("hr {color:#E1E1E2;}");
        out.print("td {color:#000000;}");
        out.print("td.dataCell, td.inputCell {border-left-color:#E1E1E2; border-style:solid;");
        out.println("border-bottom-color:#E1E1E2;vertical-align:baseline;}");
        out.print("td.inputCell {padding:0px;}");
        out.println("td.banner {background-color:#E5F6FA;}");
        out.println("td.list {background-color:#FFFFFF;}");
        out.print("tr.lightRow {background-color:#FFFFFF;");
        out.println("border-right-color:#FFFFFF;border-top-color:#FFFFFF;}");
        out.print("tr.darkRow {background-color:#F8F9F8;");
        out.println("border-right-color:#F8F9F8;border-top-color:#F8F9F8;}");
        out.print("th {color:#000000;background-color:#EFEFEF; text-align:left;");
        out.print("border-left-color:#E1E1E2; border-style:solid; ");
        out.print("border-right-color:#EFEFEF; border-bottom-color:#E1E1E2; ");
        out.println("border-top-color:#EFEFEF; vertical-align:baseline;} ");
        out.println("a.noLine {text-decoration:none;}");
        out.println("a.noLine:link {color:#0000FF;} ");
        out.println("a.noLine:visited {color:#0000FF;} ");
        out.println("a.noLine:hover {text-decoration:underline;}");
        out.println("-->\n</style>");
    }

    static void printStatusLine(String status, PrintWriter out) {
        out.print(" onMouseOver=\"status='");
        out.print(DMSUtil.xssEscape(status));
        out.println("';return true;\" onMouseOut=\"status='';\" ");
    }

    static void printHTMLStart(PrintWriter out) {
        out.print("<html><head><title>");
        String name = DMSUtil.getProcessName();
        if (name != null && name.trim().length() > 0) {
            out.print(name);
            out.print(' ');
        }
        out.print(DMSNLSupport.getString("TV_METRICS", "DMS Metrics"));
        out.println("</title>");
        MetricTableReporter.printJavaScriptDefs(out);
        MetricTableReporter.printStyleSheet(out);
    }

    static void printTableStart(int border, int cellpadding, PrintWriter out, int width) {
        out.print("<table border=");
        out.print(border);
        out.print(" cellpadding=");
        out.print(cellpadding);
        out.print(" cellspacing=0");
        if (width > 0) {
            out.print(" width=\"100%\"");
        }
        out.println('>');
    }

    static void printRowStart(boolean lightBG, PrintWriter out) {
        out.print("<tr class=\"");
        out.print(lightBG ? "lightRow" : "darkRow");
        out.println("\">");
    }

    static void printDataCell(Object data, int rowspan, boolean fullEscape, PrintWriter out) {
        boolean alignright = false;
        String text = SPACE;
        if (data instanceof Number) {
            alignright = true;
            long value = ((Number)data).longValue();
            text = data instanceof Double && value > 100000000L ? data.toString() : (value > 100L ? s_numFormat0.format(data) : (value > 10L ? s_numFormat1.format(data) : (value > 0L ? s_numFormat2.format(data) : s_numFormat3.format(data))));
        } else if (!(data == null || data instanceof String && ((String)data).trim().length() <= 0)) {
            text = data.toString();
            text = fullEscape ? DMSUtil.xssEscape(text) : DMSUtil.scriptEscape(text);
            text = NetUtil.addSoftBreak(text);
        }
        MetricTableReporter._printStringDataCell(text, rowspan, alignright, out);
    }

    private static void _printStringDataCell(String data, int rowspan, boolean alignright, PrintWriter out) {
        out.print("<td class=dataCell valign=top");
        if (rowspan > 1) {
            out.print(" rowspan=");
            out.print(rowspan);
        }
        if (alignright) {
            out.print(" align=right");
        }
        out.print(">");
        if (data == null || data.trim().length() == 0) {
            data = SPACE;
        }
        out.print(data);
        out.println("</td>");
    }

    static void printHeaderCellGrey(String header, int colspan, PrintWriter out) {
        out.print("<th ");
        if (colspan > 1) {
            out.print(" colspan=");
            out.print(colspan);
        }
        out.print('>');
        out.print(NetUtil.addSoftBreak(DMSUtil.xssEscape(header)));
        out.println("</th>");
    }

    private void _printHeaderCell(String header, String status, String table, String orderBy, int colspan, boolean isSortable, PrintWriter out) {
        if (!(isSortable || status != null && status.trim().length() != 0)) {
            MetricTableReporter.printHeaderCellGrey(header, colspan, out);
            return;
        }
        out.print("<th ");
        if (colspan > 1) {
            out.print(" colspan=");
            out.print(colspan);
        }
        out.print("><a class=noLine");
        if (isSortable) {
            this._printTableSort(table, orderBy, out);
        }
        if (status != null && status.trim().length() > 1) {
            MetricTableReporter.printStatusLine(status, out);
        }
        out.print('>');
        out.print(NetUtil.addSoftBreak(DMSUtil.xssEscape(header)));
        out.println("</a></th>");
    }

    static void printJavaScriptDefs(PrintWriter out) {
        out.println("<script language=\"javascript\">\n<!--");
        out.println("var orderby='Name';");
        out.println("function disableTextField(anode, eid){");
        out.println("var o = document.getElementById(eid);");
        out.println("if (anode.checked){");
        out.println("o.value = \"\"; o.disabled = true;");
        out.println("} else {");
        out.println("o.disabled = false;");
        out.println("}}");
        out.println("// -->\n</script>");
    }

    private String _getOrderByMetric(String[] metrics) {
        if (metrics == null || metrics.length == 0) {
            return null;
        }
        for (String metric : metrics) {
            if (!metric.endsWith(TIME) && !metric.endsWith(VALUE)) continue;
            return metric;
        }
        return metrics[0];
    }

    private void _printVariables(SchemaSupport schema, String tableName, PrintWriter out) {
        if (schema == null || schema.variableCount() == 0) {
            return;
        }
        out.print("<p><b>");
        out.print(DMSNLSupport.getString("TV_QUERY_TITLE"));
        out.println("</b></p>");
        out.println("<form method='get' action='#'>");
        MetricTableReporter.printTableStart(1, 1, out, 0);
        out.print("<tr><th ");
        out.print(DMSNLSupport.getString("QU_NAME", "Name"));
        out.print("</th><th ");
        out.print(DMSNLSupport.getString("TV_VAR_VAL", "Query Values"));
        out.print("</th><th ");
        out.print(DMSNLSupport.getString("TV_IS_NULL", "Is Null?"));
        out.println("</th></tr>");
        String[] variableNames = schema.getVariableNames();
        boolean lightBG = true;
        for (String variableName : variableNames) {
            MetricTableReporter.printRowStart(lightBG, out);
            out.print("<td class=dataCell>");
            out.print(NetUtil.addSoftBreak(DMSUtil.xssEscape(variableName)));
            out.print("&nbsp;</td>");
            out.print("<td class=inputCell><input type='text' name='");
            out.print("var_");
            out.print(variableName);
            out.print("' id='");
            out.print(variableName);
            out.print("' size=32");
            String description = schema.getVariableDescription(variableName);
            if (description != null && description.trim().length() > 0) {
                MetricTableReporter.printStatusLine(description, out);
            }
            out.print("></td><td class=dataCell>");
            out.print("<input onclick=\"disableTextField(this, '");
            out.print(variableName);
            out.print("')\" type='checkbox' name='");
            out.print("variablenull");
            out.print("' value='");
            out.print(variableName);
            out.print('\'');
            out.println("></td></tr>");
            lightBG = !lightBG;
        }
        out.print("</table>");
        out.print("<input type='hidden' name='");
        out.print("format");
        out.print("' value='");
        out.print("metrictable");
        out.println("'>");
        out.print("<input type='hidden' name='");
        out.print("cache");
        out.print("' value='");
        out.print("false");
        out.println("'>");
        out.print("<input type='hidden' name='");
        out.print("prefetch");
        out.print("' value='");
        out.print("false");
        out.println("'>");
        out.print("<input type='hidden' name='");
        out.print("table");
        out.print("' value='");
        out.print(tableName);
        out.println("'>");
        for (String variableName : variableNames) {
            out.print("<input type='hidden' name='");
            out.print("variable");
            out.print("' value='");
            out.print(variableName);
            out.println("'>");
        }
        out.print("<p><input type='submit' name='Submit' value='");
        out.print(DMSNLSupport.getString("TV_SUBMIT", "Submit Query"));
        out.print('\'');
        out.print("><input type='reset' value='");
        out.print(DMSNLSupport.getString("TV_RESET", "Reset"));
        out.print('\'');
        out.println("></p></form>");
    }

    private RowComparator _getComparator(Schema schema) {
        String orderBy = this.m_request.getOrderBy();
        if (orderBy != null && orderBy.trim().length() > 0 && schema.containsColumn(orderBy)) {
            return new RowComparator(orderBy, true);
        }
        if (schema.containsColumn("Name")) {
            return new RowComparator("Name", true);
        }
        return null;
    }

    public boolean isSortable(Table table, String metric) {
        if (table == null || metric == null || metric.trim().length() == 0) {
            return false;
        }
        Serializable oldValue = null;
        Enumeration<? extends Row> iter = table.enumerateRows();
        while (iter.hasMoreElements()) {
            Row row = iter.nextElement();
            Serializable value = row.getValue(metric);
            if (value instanceof ErrorObject || value instanceof NullValue) {
                value = null;
            }
            if (!(oldValue == null || value != null && oldValue.equals(value))) {
                return true;
            }
            if (value == null) continue;
            oldValue = value;
        }
        return false;
    }

    private void _printParamScopedMetricOptions(String tableName, String requestURI, PrintWriter out) {
        TableName parsedName = TableName.parseName(tableName);
        if (parsedName.isParamScopedMetrics()) {
            return;
        }
        ParamScopedMetricsConfigManager psmMgr = ParamScopedMetricsSystem.getConfigManager();
        if (psmMgr != null) {
            HashSet<ActivationParameterDescriptor> validParamDescriptors = new HashSet<ActivationParameterDescriptor>();
            ParamScopedMetricsConfig psmConfig = psmMgr.getCurrentConfiguration();
            if (psmConfig != null) {
                ParameterDescriptor pd;
                Map<String, ? extends ParamScopedMetricsConfig.ParameterValueConfig> actParamConfig = psmConfig.getActParamConfigForNounType(parsedName.getNounTypeName());
                Map<String, ? extends ParamScopedMetricsConfig.ParameterValueConfig> ctxParamConfig = psmConfig.getCtxParamConfigForNounType(parsedName.getNounTypeName());
                if (actParamConfig != null) {
                    for (String string : actParamConfig.keySet()) {
                        pd = DMSConsole.getActivationParameterFactory().findDescriptor(string);
                        if (pd == null) continue;
                        validParamDescriptors.add((ActivationParameterDescriptor)pd);
                    }
                }
                if (ctxParamConfig != null) {
                    for (String string : ctxParamConfig.keySet()) {
                        pd = DMSContextManager.getDomainContextManager().findContextParameterDescriptor(string);
                        if (pd == null) continue;
                        validParamDescriptors.add((ActivationParameterDescriptor)pd);
                    }
                }
                if (!validParamDescriptors.isEmpty()) {
                    out.println("<h3>Parameter Scoped Metric Tables</h3>");
                    out.println("<ul>");
                    for (ParameterDescriptor parameterDescriptor : validParamDescriptors) {
                        HashMap<String, String> tableNameParams = new HashMap<String, String>(4);
                        if (parameterDescriptor instanceof ContextParameterDescriptor) {
                            tableNameParams.put("scopingParamType", "ctx");
                        } else {
                            if (!(parameterDescriptor instanceof ActivationParameterDescriptor)) continue;
                            tableNameParams.put("scopingParamType", "act");
                        }
                        tableNameParams.put("scopingParamName", parameterDescriptor.getName());
                        TableName fullTableName = TableName.createName(tableName, tableNameParams);
                        HashMap<String, String> params = new HashMap<String, String>(4);
                        params.put("format", "metrictable");
                        params.put("cache", "false");
                        params.put("prefetch", "false");
                        params.put("table", fullTableName.getNormalName());
                        String hLink = requestURI + "?" + URIUtils.buildQueryString(params);
                        out.println("<li>");
                        out.println("<a href='");
                        out.println(hLink);
                        out.println("'>");
                        out.println(parameterDescriptor.getName());
                        out.println("</a>");
                        out.println("</li>");
                    }
                    out.println("</ul>");
                }
            }
        }
    }

    static {
        s_numFormat0.setMaximumFractionDigits(0);
        s_numFormat1.setMaximumFractionDigits(1);
        s_numFormat2.setMaximumFractionDigits(2);
        s_numFormat3.setMaximumFractionDigits(3);
        s_numFormat0.setGroupingUsed(false);
        s_numFormat1.setGroupingUsed(false);
        s_numFormat2.setGroupingUsed(false);
        s_numFormat3.setGroupingUsed(false);
    }
}

