/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import oracle.dms.event.Event;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.Filter;
import oracle.dms.event.NounTypeDiscriminator;

public class NullFilterWithEventTypeProxy
implements Filter {
    private static EventType[] sAllEventTypes = EventType.getAllEventTypes();
    private String mName;
    private String mId;
    private EventTypeEnthusiast mEventTypeEnthusiast;
    private NounTypeDiscriminator mNounTypeDiscriminator;

    public NullFilterWithEventTypeProxy(String filterName, String filterId, Object delegate) {
        this.mName = filterName;
        this.mId = filterId;
        if (delegate instanceof EventTypeEnthusiast) {
            this.mEventTypeEnthusiast = (EventTypeEnthusiast)delegate;
        }
        if (delegate instanceof NounTypeDiscriminator) {
            this.mNounTypeDiscriminator = (NounTypeDiscriminator)delegate;
        }
    }

    @Override
    public boolean applyFilter(Event event) {
        return true;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        EventType[] retVal = null;
        retVal = this.mEventTypeEnthusiast != null ? this.mEventTypeEnthusiast.getEventTypesOfInterest() : sAllEventTypes;
        return retVal;
    }

    @Override
    public boolean willDiscriminateAgainstNounType(String nounType) {
        boolean retVal = false;
        if (this.mNounTypeDiscriminator != null) {
            retVal = this.mNounTypeDiscriminator.willDiscriminateAgainstNounType(nounType);
        }
        return retVal;
    }
}

