/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.impl.incident.ADRHelper;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.incident.DiagnosticsDataExtractorImpl;
import oracle.dfw.impl.query.ADRQueryExecutor;
import oracle.dfw.impl.query.Condition;
import oracle.dfw.impl.query.QueryParser;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentManager;
import oracle.dfw.incident.Problem;

public class IncidentManagerImpl
implements IncidentManager {
    private ADRInfo m_defaultADR;
    private ADRHelper m_adrHelper;
    private ADRQueryExecutor m_adrQueryExecutor;
    private static List<Incident> EMPTY_INCIDENT_LIST = Collections.emptyList();

    public IncidentManagerImpl(DiagnosticsDataExtractorImpl dde, ADRInfo defaultADR, DiagnosticsConfiguration diagConfig) throws DiagnosticsException {
        if (defaultADR == null || diagConfig == null || dde == null) {
            throw new IllegalArgumentException("Invalid arguments defaultADR=" + defaultADR + " config=" + diagConfig + " dde=" + dde);
        }
        this.m_defaultADR = defaultADR;
        this.m_adrHelper = dde.getADRHelper();
        if (this.m_adrHelper == null) {
            throw new DiagnosticsException("ADRHelper instance unavailable");
        }
        this.m_adrQueryExecutor = new ADRQueryExecutor(this.m_adrHelper);
    }

    @Override
    public String getADRBase() {
        return this.m_defaultADR.getADRBase();
    }

    @Override
    public String getADRHome() {
        return this.m_defaultADR.getADRHome();
    }

    @Override
    public List<String> getADRHomes() {
        return this.m_adrHelper.listADRHomes(this.m_defaultADR.getADRBase());
    }

    @Override
    public List<Problem> getProblems() {
        return this.m_adrHelper.listProblems(this.m_defaultADR);
    }

    @Override
    public List<Problem> getProblems(String ADRHome) throws DiagnosticsException {
        return this.m_adrHelper.listProblems(ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome));
    }

    @Override
    public Problem getProblem(String problemId) {
        return this.m_adrHelper.getProblem(this.m_defaultADR, problemId);
    }

    @Override
    public Problem getProblem(String ADRHome, String problemId) throws DiagnosticsException {
        return this.m_adrHelper.getProblem(ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome), problemId);
    }

    @Override
    public List<Incident> getIncidents(String problemId) {
        return this.m_adrHelper.listIncidents(this.m_defaultADR, problemId);
    }

    @Override
    public List<Incident> getIncidents(String ADRHome, String problemId) throws DiagnosticsException {
        return this.m_adrHelper.listIncidents(ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome), problemId);
    }

    @Override
    public Incident getIncident(String incidentId) {
        return this.m_adrHelper.getIncident(this.m_defaultADR, incidentId);
    }

    @Override
    public Incident getIncident(String ADRHome, String incidentId) throws DiagnosticsException {
        return this.m_adrHelper.getIncident(ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome), incidentId);
    }

    @Override
    public void addIncidentFile(String incidentId, String ... filenames) throws DiagnosticsException {
        this.m_adrHelper.addIncidentFiles(this.m_defaultADR, incidentId, filenames);
    }

    @Override
    public void addIncidentFileWithADRHome(String ADRHome, String incidentId, String ... filenames) throws DiagnosticsException {
        this.m_adrHelper.addIncidentFiles(ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome), incidentId, filenames);
    }

    @Override
    public List<Incident> queryIncidents(String ADRHome, String query) throws DiagnosticsException {
        if (ADRHome == null || query == null) {
            throw new IllegalArgumentException("invalid parameters to queryIncidents. ADRHome=" + ADRHome + " query=" + query);
        }
        QueryParser parser = new QueryParser();
        Condition con = parser.parse(query);
        ADRInfo adrInfo = ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome);
        Set<String> incidentIds = this.m_adrQueryExecutor.execute(adrInfo, query, con);
        List<Incident> incidents = null;
        if (incidentIds != null) {
            incidents = this.m_adrHelper.getIncidents(adrInfo, incidentIds);
        }
        return incidents != null ? incidents : EMPTY_INCIDENT_LIST;
    }

    public void validateQuery(String query) throws DiagnosticsException {
        if (query == null) {
            throw new IllegalArgumentException("query string is null");
        }
        QueryParser parser = new QueryParser();
        Condition con = parser.parse(query);
        this.m_adrQueryExecutor.validate(query, con);
    }

    public void shutdown() {
    }
}

