/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

public final class PrependStringBuffer {
    private int m_pos;
    private char[] m_buf;

    public PrependStringBuffer(int size, String val) {
        int len = val.length();
        int bufSz = size + len;
        this.m_buf = new char[bufSz];
        this.m_pos = bufSz - len;
        val.getChars(0, len, this.m_buf, this.m_pos);
    }

    public PrependStringBuffer prepend(String str) {
        int len = str.length();
        if (this.m_pos < len) {
            this.expandCapacity(len);
        }
        this.m_pos -= len;
        str.getChars(0, len, this.m_buf, this.m_pos);
        return this;
    }

    public PrependStringBuffer prepend(char ch) {
        if (this.m_pos < 1) {
            this.expandCapacity(1);
        }
        this.m_buf[--this.m_pos] = ch;
        return this;
    }

    public String toString() {
        return new String(this.m_buf, this.m_pos, this.m_buf.length - this.m_pos);
    }

    private final void expandCapacity(int min) {
        int bufSz = this.m_buf.length;
        int newSz = bufSz > min ? bufSz * 2 : bufSz + min;
        char[] newbuf = new char[newSz];
        int count = bufSz - this.m_pos;
        System.arraycopy(this.m_buf, this.m_pos, newbuf, newSz - count, count);
        this.m_buf = newbuf;
        this.m_pos = newSz - count;
    }
}

