/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.trace2.runtime;

import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Event;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventType;
import oracle.dms.event.Filter;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.trace2.runtime.Condition;
import oracle.dms.trace2.runtime.DataType;
import oracle.dms.trace2.runtime.OpType;

public class ConditionFilter
implements Filter {
    private Condition mCondition;
    private boolean mNeedsContext;
    private String mId;
    private String mName;
    private EventType[] mEventTypesOfInterest;
    private boolean mInstrumentationEventsExpected;

    public ConditionFilter(String name, String id, String eventTypesAsString, Condition c) {
        this.mName = name;
        this.mId = id;
        this.mCondition = c;
        this.mNeedsContext = this.mCondition != null ? this.mCondition.needsContext() : false;
        this.mEventTypesOfInterest = eventTypesAsString == null ? EventType.getAllEventTypes() : EventType.parseList(eventTypesAsString);
        this.mInstrumentationEventsExpected = false;
        for (EventType eventType : this.mEventTypesOfInterest) {
            if (!eventType.getSourceType().isTypeOf(EventSourceType.INSTRUMENTATION_NODE)) continue;
            this.mInstrumentationEventsExpected = true;
        }
        if (!this.mInstrumentationEventsExpected && ConditionFilter.getAnyNounTypeCondition(this.mCondition) != null) {
            throw new IllegalArgumentException("NounType conditions are not permitted in a ConditionFilter if the eventType setting excludes all events relating to either nouns or sensors or both.");
        }
    }

    @Override
    public boolean applyFilter(Event event) {
        boolean retVal = true;
        if (this.mCondition != null && event != null) {
            retVal = this.mCondition.applyCondition(event);
        }
        return retVal;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean needsContext() {
        return this.mNeedsContext;
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        return this.mEventTypesOfInterest;
    }

    @Override
    public boolean willDiscriminateAgainstNounType(String nounType) {
        boolean retVal = false;
        if (!this.mInstrumentationEventsExpected) {
            retVal = true;
        } else if (this.mCondition != null) {
            retVal = this.mCondition.willDiscriminateAgainstNounType(nounType);
        }
        return retVal;
    }

    private static NounTypeCondition getAnyNounTypeCondition(Condition condition) {
        NounTypeCondition retVal = null;
        if (condition instanceof NounTypeCondition) {
            retVal = (NounTypeCondition)condition;
        } else {
            Condition lhCondition = null;
            Condition rhCondition = null;
            if (condition instanceof AndCondition) {
                AndCondition andCondition = (AndCondition)condition;
                lhCondition = andCondition.lh;
                rhCondition = andCondition.rh;
            } else if (condition instanceof OrCondition) {
                OrCondition orCondition = (OrCondition)condition;
                lhCondition = orCondition.lh;
                rhCondition = orCondition.rh;
            }
            if (lhCondition != null) {
                retVal = ConditionFilter.getAnyNounTypeCondition(lhCondition);
            }
            if (retVal == null && rhCondition != null) {
                retVal = ConditionFilter.getAnyNounTypeCondition(rhCondition);
            }
        }
        return retVal;
    }

    public static class NestedCondition
    implements Condition {
        Condition nestedCondition;

        public NestedCondition(Condition nestedCondition) {
            if (nestedCondition != null) {
                this.nestedCondition = nestedCondition;
            }
        }

        @Override
        public boolean applyCondition(Event event) {
            return this.nestedCondition.applyCondition(event);
        }

        @Override
        public boolean willDiscriminateAgainstNounType(String nounType) {
            return this.nestedCondition.willDiscriminateAgainstNounType(nounType);
        }

        @Override
        public boolean needsContext() {
            return this.nestedCondition.needsContext();
        }
    }

    public static class ExecutionContextCondition
    implements Condition {
        private OpType opType;
        private String propertyName;
        private String propertyValueForComparison;
        private DataType dataType;
        private boolean ignorecase;

        public ExecutionContextCondition(String propertyName, String propertyValue, OpType opType, DataType dataType, boolean ignorecase) {
            if (propertyName == null || opType == null) {
                throw new IllegalArgumentException("Following arguments must be non-null: propertyName = '" + propertyName + "', " + "propertyValue = '" + propertyValue + "', " + "opType = '" + (Object)((Object)opType) + "'");
            }
            if (opType != OpType.IS_NOT_NULL && opType != OpType.ISNOTNULL && opType != OpType.IS_NULL && opType != OpType.ISNULL) {
                StringBuilder exceptString = new StringBuilder();
                if (propertyValue == null) {
                    exceptString.append("propertyValue");
                }
                if (dataType == null) {
                    if (propertyValue == null) {
                        exceptString.append(" and dataType");
                    } else {
                        exceptString.append("dataType");
                    }
                }
                if (propertyValue == null || dataType == null) {
                    exceptString.append(" argument is mandatory for this opType: propertyName = '" + propertyName + "', " + "propertyValue = '" + propertyValue + "', " + "opType = '" + (Object)((Object)opType) + "', " + "dataType = `" + (Object)((Object)dataType) + "'");
                    throw new IllegalArgumentException(exceptString.toString());
                }
            }
            this.propertyName = propertyName;
            this.propertyValueForComparison = propertyValue;
            this.opType = opType;
            this.dataType = dataType;
            this.ignorecase = ignorecase;
        }

        @Override
        public boolean applyCondition(Event event) {
            boolean retVal = false;
            ExecutionContext ctx = event.getExecutionContext();
            if (ctx != null) {
                String ctxValue = ctx.getValue(this.propertyName);
                retVal = this.opType.applyOperation(ctxValue, this.propertyValueForComparison, this.dataType, this.ignorecase);
            }
            return retVal;
        }

        @Override
        public boolean needsContext() {
            return true;
        }

        @Override
        public boolean willDiscriminateAgainstNounType(String nounType) {
            return false;
        }
    }

    public static class NounTypeCondition
    implements Condition {
        private OpType opType;
        private String nounTypeForComparison;

        public NounTypeCondition(String nounType, OpType opType) {
            if (nounType == null || opType == null) {
                throw new IllegalArgumentException("Both nounType and opType arguments must be non-null: nounType = '" + nounType + "', " + "opType = '" + (Object)((Object)opType) + "'");
            }
            this.nounTypeForComparison = nounType;
            this.opType = opType;
        }

        @Override
        public boolean applyCondition(Event event) {
            boolean retVal = false;
            Noun noun = null;
            if (event.getSourceType().isTypeOf(EventSourceType.INSTRUMENTATION_NODE)) {
                String nounType = null;
                if (event.getSourceType() == EventSourceType.ANONYMOUS_PHASE_SENSOR) {
                    nounType = (String)event.getSubsidiaryObject(1);
                } else if (event.getSourceType().isTypeOf(EventSourceType.SENSOR)) {
                    Sensor sensor = (Sensor)event.getSource();
                    noun = sensor.getParent();
                    nounType = noun.getType();
                } else if (event.getSourceType() == EventSourceType.NOUN) {
                    noun = (Noun)event.getSource();
                    nounType = noun.getType();
                }
                retVal = this.opType.applyOperation(nounType, this.nounTypeForComparison, DataType.STRING, false);
            } else {
                retVal = true;
            }
            return retVal;
        }

        @Override
        public boolean needsContext() {
            return false;
        }

        @Override
        public boolean willDiscriminateAgainstNounType(String nounType) {
            return !this.opType.applyOperation(nounType, this.nounTypeForComparison, DataType.STRING, false);
        }
    }

    public static class OrCondition
    implements Condition {
        Condition lh;
        Condition rh;

        public OrCondition(Condition lh, Condition rh) {
            if (lh == null || rh == null) {
                throw new IllegalArgumentException("Both Condition arguments must be non-null: lh = '" + lh + "', " + "rh = '" + rh + "'");
            }
            this.lh = lh;
            this.rh = rh;
        }

        @Override
        public boolean applyCondition(Event event) {
            return this.lh.applyCondition(event) || this.rh.applyCondition(event);
        }

        @Override
        public boolean needsContext() {
            return this.rh.needsContext() || this.lh.needsContext();
        }

        @Override
        public boolean willDiscriminateAgainstNounType(String nounType) {
            return this.rh.willDiscriminateAgainstNounType(nounType) && this.lh.willDiscriminateAgainstNounType(nounType);
        }
    }

    public static class AndCondition
    implements Condition {
        Condition lh;
        Condition rh;

        public AndCondition(Condition lh, Condition rh) {
            if (lh == null || rh == null) {
                throw new IllegalArgumentException("Both Condition arguments must be non-null: lh = '" + lh + "', " + "rh = '" + rh + "'");
            }
            this.lh = lh;
            this.rh = rh;
        }

        @Override
        public boolean applyCondition(Event event) {
            return this.lh.applyCondition(event) && this.rh.applyCondition(event);
        }

        @Override
        public boolean needsContext() {
            return this.rh.needsContext() || this.lh.needsContext();
        }

        @Override
        public boolean willDiscriminateAgainstNounType(String nounType) {
            return this.rh.willDiscriminateAgainstNounType(nounType) || this.lh.willDiscriminateAgainstNounType(nounType);
        }
    }
}

