/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.SimpleType;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.RequiresEventsOnInitialization;
import oracle.dms.event.RequiresReinitializationOnFilterChange;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.jmx.MetricMBean;
import oracle.dms.jmx.MetricMBeanInfo;
import oracle.dms.jmx.MetricMBeanInitializer;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.MBeanServerSupport;
import oracle.dms.util.Validatable;

@RequiresReinitializationOnFilterChange
@RequiresEventsOnInitialization(eventTypes="NOUN:CREATE")
@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.event.EventResourceBundle", nlsDescriptionID="NOUN_MBEAN_CREATER_DESTINATION")
public class MetricMBeanFactory
implements LoadableDestination,
EventTypeEnthusiast {
    private Map<Noun, ObjectName> m_objectNames = new ConcurrentHashMap<Noun, ObjectName>();
    private Map<Noun, MetricMBeanInfo> m_mbeanInfos = new ConcurrentHashMap<Noun, MetricMBeanInfo>();
    private volatile boolean m_shutdown = true;
    private String m_id = null;
    private String m_name = null;
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");
    private static final EventType[] EVENT_TYPES_OF_INTEREST = new EventType[]{EventType.getEventType(EventSourceType.EVENT_SENSOR, EventActionType.CREATE), EventType.getEventType(EventSourceType.EVENT_SENSOR, EventActionType.DELETE), EventType.getEventType(EventSourceType.EVENT_SENSOR, EventActionType.METRIC_SELECTION_CHANGED), EventType.getEventType(EventSourceType.PHASE_SENSOR, EventActionType.CREATE), EventType.getEventType(EventSourceType.PHASE_SENSOR, EventActionType.DELETE), EventType.getEventType(EventSourceType.PHASE_SENSOR, EventActionType.METRIC_SELECTION_CHANGED), EventType.getEventType(EventSourceType.STATE_SENSOR, EventActionType.CREATE), EventType.getEventType(EventSourceType.STATE_SENSOR, EventActionType.DELETE), EventType.getEventType(EventSourceType.STATE_SENSOR, EventActionType.METRIC_SELECTION_CHANGED), EventType.getEventType(EventSourceType.ROLLUP_SENSOR, EventActionType.CREATE), EventType.getEventType(EventSourceType.ROLLUP_SENSOR, EventActionType.DELETE), EventType.getEventType(EventSourceType.ROLLUP_SENSOR, EventActionType.METRIC_SELECTION_CHANGED), EventType.getEventType(EventSourceType.NOUN, EventActionType.CREATE), EventType.getEventType(EventSourceType.NOUN, EventActionType.DELETE), EventType.getEventType(EventSourceType.NOUN, EventActionType.TYPE_CHANGE)};

    public boolean isShutdown() {
        return this.m_shutdown;
    }

    @Override
    public void handleEvent(Event event) {
        block19: {
            String METHOD_NAME = "handleEvent";
            if (this.m_shutdown) {
                return;
            }
            EventActionType actionType = event.getActionType();
            EventSourceType sourceType = event.getSourceType();
            switch (sourceType) {
                case PHASE_SENSOR: 
                case STATE_SENSOR: 
                case EVENT_SENSOR: 
                case ROLLUP_SENSOR: 
                case SENSOR: {
                    if (this.m_shutdown) break;
                    Sensor sensor = (Sensor)event.getSource();
                    Noun noun = sensor.getParent();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, this.getClass().getName(), "handleEvent", "Received sensor event: " + sensor);
                    }
                    switch (actionType) {
                        case CREATE: {
                            if (!this._isExposedNoun(noun)) break;
                            this._registerSensors(noun, true);
                            break;
                        }
                        case METRIC_SELECTION_CHANGED: {
                            if (!this._isExposedNoun(noun)) break;
                            this._registerSensors(noun, false);
                            break;
                        }
                        case DELETE: {
                            this._unregisterSensors(noun, sensor);
                            break;
                        }
                    }
                    break;
                }
                case NOUN: {
                    if (this.m_shutdown) break;
                    Noun noun = (Noun)event.getSource();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, this.getClass().getName(), "handleEvent", "Received NOUN event: " + noun);
                    }
                    switch (actionType) {
                        case CREATE: {
                            if (this._isExposedNoun(noun)) {
                                this._registerSensors(noun, true);
                                break;
                            }
                            break block19;
                        }
                        case DELETE: {
                            this._unregisterNoun(noun);
                            break;
                        }
                        case TYPE_CHANGE: {
                            if (!this.m_mbeanInfos.containsKey(noun)) break;
                            this._unregisterNoun(noun);
                            if (this._isExposedNoun(noun)) {
                                this._registerSensors(noun, true);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    private void _registerSensors(Noun noun, boolean toCreate) {
        block13: {
            String METHOD_NAME = "_registerSensors";
            if (noun.getChildSensorCount() == 0) {
                return;
            }
            String nountype = noun.getType();
            if (nountype.startsWith("JVM_") || "JVM".equals(nountype)) {
                return;
            }
            MetricMBeanInfo mbeanInfo = this.m_mbeanInfos.get(noun);
            if (mbeanInfo != null) {
                ArrayList<ModelMBeanAttributeInfo> attributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
                this._createMetricAttributeInfos(noun, attributeInfoList, mbeanInfo);
                for (ModelMBeanAttributeInfo attributeInfo : attributeInfoList) {
                    mbeanInfo.setAttribute(attributeInfo);
                }
                attributeInfoList.clear();
            } else if (toCreate) {
                try {
                    mbeanInfo = this._createMBeanInfo(noun);
                    MetricMBean metricMBean = new MetricMBean(mbeanInfo);
                    MetricMBeanInfo oldMbeanInfo = this.m_mbeanInfos.put(noun, mbeanInfo);
                    if (oldMbeanInfo != null) {
                        MBeanAttributeInfo[] attributeInfos = oldMbeanInfo.getAttributes();
                        if (attributeInfos != null) {
                            for (MBeanAttributeInfo attributeInfo : attributeInfos) {
                                if (!(attributeInfo instanceof ModelMBeanAttributeInfo)) continue;
                                mbeanInfo.setAttribute((ModelMBeanAttributeInfo)attributeInfo);
                            }
                        }
                        if (this.m_objectNames.containsKey(noun)) {
                            return;
                        }
                    }
                    ObjectName objName = this._createObjectName(noun);
                    MBeanServer mbeanServer = MBeanServerSupport.getMBeanServer();
                    ObjectInstance objInst = mbeanServer.registerMBean(metricMBean, objName);
                    objName = objInst.getObjectName();
                    this.m_objectNames.put(noun, objName);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.logp(Level.FINEST, this.getClass().getName(), "_registerSensors", "Register metric MBean for noun '" + noun + "': " + objName);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block13;
                    LOGGER.logp(Level.FINE, this.getClass().getName(), "_registerSensors", "Failed to create metric MBean for noun: " + noun, e);
                }
            }
        }
    }

    private void _unregisterSensors(Noun noun, Sensor sensor) {
        MetricMBeanInfo mbeanInfo = this.m_mbeanInfos.get(noun);
        if (mbeanInfo == null) {
            return;
        }
        if (noun.getChildSensorCount() == 0) {
            this._unregisterNoun(noun);
            return;
        }
        String sensorName = sensor.toString();
        MBeanAttributeInfo[] attributeInfos = mbeanInfo.getAttributes();
        if (attributeInfos == null) {
            return;
        }
        for (MBeanAttributeInfo attributeInfo : attributeInfos) {
            Descriptor descriptor = attributeInfo.getDescriptor();
            Object sensorInfo = descriptor.getFieldValue("oracle.dms.sensor");
            if (!sensorName.equals(sensorInfo)) continue;
            mbeanInfo.removeAttribute(attributeInfo.getName());
        }
    }

    private void _unregisterNoun(Noun noun) {
        block4: {
            String METHOD_NAME = "_unregisterNoun";
            this.m_mbeanInfos.remove(noun);
            ObjectName objName = this.m_objectNames.remove(noun);
            if (objName == null) {
                return;
            }
            try {
                MBeanServer mbeanServer = MBeanServerSupport.getMBeanServer();
                mbeanServer.unregisterMBean(objName);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.logp(Level.FINEST, this.getClass().getName(), "_unregisterNoun", "Unregister metric MBean for noun '" + noun + "': " + objName);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block4;
                LOGGER.logp(Level.FINE, this.getClass().getName(), "_unregisterNoun", "Failed to unregister metric MBean for noun '" + noun + "': " + objName, e);
            }
        }
    }

    private boolean _isExposedNoun(Noun noun) {
        if (noun == null || !noun.isAlive()) {
            return false;
        }
        String nountype = noun.getType();
        NounDescriptor ndesc = noun.getDescriptor();
        return noun != noun.getRoot() && nountype != null && nountype.trim().length() > 0 && !"n/a".equals(nountype) && ndesc != null;
    }

    private MetricMBeanInfo _createMBeanInfo(Noun noun) {
        String nounName = noun.getName();
        String nountype = noun.getType();
        ArrayList<ModelMBeanAttributeInfo> attributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this._createAttributeInfos(noun, attributeInfoList);
        DescriptorSupport descriptor = new DescriptorSupport();
        descriptor.setField("name", nounName);
        descriptor.setField("displayName", nounName);
        descriptor.setField("oracle.dms.nountype", nountype);
        descriptor.setField("descriptorType", "mbean");
        descriptor.setField("visibility", 1);
        descriptor.setField("descriptionResourceBundleBaseName", "oracle.dms.util.dms");
        descriptor.setField("descriptionResourceKey", "MetricMBean.description");
        descriptor.setField("DiagnosticTypeName", nountype);
        descriptor.setField("immutableInfo", "false");
        descriptor.setField("infoTimeout", 0L);
        MetricMBeanInfo mbeanInfo = new MetricMBeanInfo(MetricMBean.class.getName(), "MetricMBean.description", attributeInfoList, new ModelMBeanConstructorInfo[0], new ModelMBeanOperationInfo[0], new ModelMBeanNotificationInfo[0], (Descriptor)descriptor);
        return mbeanInfo;
    }

    private void _createAttributeInfos(Noun noun, List<ModelMBeanAttributeInfo> list) {
        this._createMetricAttributeInfos(noun, list, null);
        this._createFixAttributeInfos(noun, list);
        list.add(this._createFixAttributeInfo("Name", "fixvalue", noun.getName()));
        list.add(this._createFixAttributeInfo("Parent", "fixvalue", noun.getParent().toString()));
    }

    private void _createMetricAttributeInfos(Noun noun, List<ModelMBeanAttributeInfo> list, MetricMBeanInfo mbeanInfo) {
        Sensor[] sensors = noun.getSensors();
        if (sensors == null || sensors.length == 0) {
            return;
        }
        for (Sensor sensor : sensors) {
            SensorDescriptor sdesc;
            if (sensor == null || (sdesc = sensor.getDescriptor()) == null) continue;
            Vector<Metric> metrics = new Vector<Metric>();
            sensor.getMetrics(metrics);
            if (metrics.size() == 0) continue;
            String description = sdesc.getDescription();
            for (Metric metric : metrics) {
                if (metric == null) continue;
                this._addMetricAttributeInfo(metric, description, list, mbeanInfo);
            }
        }
    }

    private void _addMetricAttributeInfo(Metric metric, String description, List<ModelMBeanAttributeInfo> list, MetricMBeanInfo mbeanInfo) {
        SimpleType<Object> simpleType;
        String className;
        ModelMBeanAttributeInfo attributeInfo;
        String metricName = metric.getName();
        String metricIDName = DMSUtil.javaIdentifieringName(metricName);
        if (mbeanInfo != null && (attributeInfo = mbeanInfo.getAttribute(metricIDName)) != null) {
            return;
        }
        MetricDescriptor mdesc = metric.getDescriptor();
        byte typeID = mdesc.getValueTypeID();
        switch (typeID) {
            case 3: {
                className = Integer.class.getName();
                simpleType = SimpleType.INTEGER;
                break;
            }
            case 2: {
                className = Long.class.getName();
                simpleType = SimpleType.LONG;
                break;
            }
            case 1: {
                className = Double.class.getName();
                simpleType = SimpleType.DOUBLE;
                break;
            }
            default: {
                className = String.class.getName();
                simpleType = SimpleType.STRING;
            }
        }
        String metricType = "gauge";
        if (metricName.endsWith(".maxTime") || metricName.endsWith(".count") || metricName.endsWith(".completed") || metricName.endsWith(".time") || metricName.endsWith(".maxActive")) {
            metricType = "counter";
        }
        String unit = mdesc.getUnit();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("name", metricIDName);
        fields.put("displayName", metricName);
        fields.put("oracle.dms.metric", metricName);
        fields.put("descriptorType", "attribute");
        fields.put("visibility", 1);
        fields.put("openType", simpleType);
        fields.put("oracle.dms.metrictype", "metric");
        fields.put("oracle.dms.sensor", metric.getSensor().toString());
        fields.put("metricType", metricType);
        if (unit != null && unit.trim().length() > 0) {
            fields.put("units", unit);
        }
        ImmutableDescriptor descriptor = new ImmutableDescriptor(fields);
        list.add(new ModelMBeanAttributeInfo(metricIDName, className, description, true, false, false, descriptor));
    }

    private void _createFixAttributeInfos(Noun noun, List<ModelMBeanAttributeInfo> list) {
        Noun root = noun.getRoot();
        for (Noun n = noun.getParent(); n != null && n != root; n = n.getParent()) {
            String ancestorName = n.getName();
            String ancestorType = n.getType();
            if (ancestorType == null || "n/a".equals(ancestorType)) continue;
            list.add(this._createFixAttributeInfo(ancestorType, "fixvalue", ancestorName));
        }
    }

    private ModelMBeanAttributeInfo _createFixAttributeInfo(String name, String attributeType, String value) {
        String idName = DMSUtil.javaIdentifieringName(name);
        String description = DMSNLSupport.getString("MetricMBean.ancestornoun.description");
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("name", idName);
        fields.put("displayName", name);
        fields.put("oracle.dms.metric", name);
        fields.put("descriptorType", "attribute");
        fields.put("visibility", 1);
        fields.put("openType", SimpleType.STRING);
        fields.put("descriptionResourceBundleBaseName", "oracle.dms.util.dms");
        fields.put("descriptionResourceKey", "MetricMBean.ancestornoun.description");
        fields.put("currencyTimeLimit", new Long(Long.MAX_VALUE));
        fields.put("value", value);
        if (attributeType != null) {
            fields.put("oracle.dms.metrictype", attributeType);
        }
        ImmutableDescriptor descriptor = new ImmutableDescriptor(fields);
        return new ModelMBeanAttributeInfo(idName, String.class.getName(), description, true, false, false, descriptor);
    }

    private ObjectName _createObjectName(Noun noun) throws MalformedObjectNameException {
        Noun root = noun.getRoot();
        StringBuffer objNameBuf = new StringBuffer("oracle.dms");
        objNameBuf.append(":type=");
        objNameBuf.append(noun.getType());
        for (Noun n = noun.getParent(); n != null && n != root; n = n.getParent()) {
            String ancestorName = n.getName();
            String ancestorType = n.getType();
            if (ancestorType == null || "n/a".equals(ancestorType)) continue;
            MetricMBeanFactory._addObjectNameProperty(ancestorType, ancestorName, objNameBuf);
        }
        MetricMBeanFactory._addObjectNameProperty("name", noun.toString(), objNameBuf);
        String objNameString = objNameBuf.toString();
        return new ObjectName(objNameString);
    }

    private static final void _addObjectNameProperty(String key, String value, StringBuffer buf) {
        buf.append(',');
        buf.append(key);
        buf.append('=');
        buf.append(value);
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        return (EventType[])EVENT_TYPES_OF_INTEREST.clone();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public synchronized void initDestination() {
        if (!this.m_shutdown) {
            return;
        }
        if (DMSConsole.getSensorWeight() > 5) {
            LOGGER.warning("MetricMBean.sensorWeightWarning");
        }
        this.m_shutdown = false;
        MetricMBeanInitializer.setMetricMBeanFactory(this);
        MetricMBeanInitializer.createMetricMBeans(true);
    }

    @Override
    public synchronized void shutdownDestination() {
        String METHOD_NAME = "shutdownDestination";
        if (this.m_shutdown) {
            return;
        }
        this.m_shutdown = true;
        MetricMBeanInitializer.createMetricMBeans(false);
        for (Map.Entry<Noun, ObjectName> entry : this.m_objectNames.entrySet()) {
            Noun noun = entry.getKey();
            ObjectName objName = entry.getValue();
            this.m_mbeanInfos.remove(noun);
            try {
                MBeanServer mbeanServer = MBeanServerSupport.getMBeanServer();
                mbeanServer.unregisterMBean(objName);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.logp(Level.FINE, this.getClass().getName(), "shutdownDestination", "Failed to unregister metric MBean: " + objName, e);
            }
        }
        this.m_objectNames.clear();
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) {
    }
}

