/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

public enum OpType {
    EQUALS,
    EQ,
    STARTS_WITH,
    STARTSWITH,
    SW,
    CONTAINS,
    NOT_EQUALS,
    NOTEQUALS,
    NE,
    IS_NULL,
    ISNULL,
    IS_NOT_NULL,
    ISNOTNULL,
    LT,
    GT,
    LE,
    GE,
    IN;

    OpType mRootType;

    private void setRootOpType(OpType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException();
        }
        this.mRootType = rootType;
    }

    public static OpType getOpType(String opType) {
        try {
            return OpType.valueOf(opType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public OpType getRootAlias() {
        return this.mRootType;
    }

    static {
        EQUALS.setRootOpType(EQUALS);
        EQ.setRootOpType(EQUALS);
        STARTS_WITH.setRootOpType(STARTS_WITH);
        STARTSWITH.setRootOpType(STARTS_WITH);
        SW.setRootOpType(STARTS_WITH);
        CONTAINS.setRootOpType(CONTAINS);
        NOT_EQUALS.setRootOpType(NOT_EQUALS);
        NOTEQUALS.setRootOpType(NOT_EQUALS);
        NE.setRootOpType(NOT_EQUALS);
        IS_NULL.setRootOpType(IS_NULL);
        ISNULL.setRootOpType(IS_NULL);
        IS_NOT_NULL.setRootOpType(IS_NOT_NULL);
        ISNOTNULL.setRootOpType(IS_NOT_NULL);
        LT.setRootOpType(LT);
        GT.setRootOpType(GT);
        LE.setRootOpType(LE);
        GE.setRootOpType(GE);
        IN.setRootOpType(IN);
        for (OpType opType : OpType.values()) {
            if (opType.mRootType != null) continue;
            throw new IllegalStateException("InternalError " + OpType.class.getName() + ":" + opType.name() + " not properly constructed.");
        }
    }
}

