/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.jmx;

import java.util.List;
import java.util.Map;
import oracle.as.jmx.framework.annotations.AttributeGetterRequiredGlobalSecurityRoles;
import oracle.as.jmx.framework.annotations.Description;
import oracle.as.jmx.framework.annotations.GlobalSecurityRole;
import oracle.as.jmx.framework.annotations.Notification;
import oracle.as.jmx.framework.annotations.NotificationSeverity;
import oracle.as.jmx.framework.annotations.OperationRequiredGlobalSecurityRoles;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.Problem;

@Notification(id="diagnostic.incidents", name="javax.management.Notification", notifTypes={"incident.created"}, resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation", resourceKey="DFW_INCIDENT_MANAGER_NOTIFICATION", severity=NotificationSeverity.Info)
@Description(resourceKey="DFW_INCIDENTMXBEAN_DESCRIPTION", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
public interface IncidentManagerMXBean {
    public static final String INCIDENT_MANAGER_EVENT_ID = "diagnostic.incidents";
    public static final String INCIDENT_CREATED_NOTIFICATION_TYPE = "incident.created";

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_PROBLEMS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Problem> getProblems();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_PROBLEMS_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Problem> getProblems(String var1) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_PROBLEM", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Problem getProblem(String var1);

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_PROBLEM_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Problem getProblem(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_INCIDENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Incident> getIncidents(String var1);

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_INCIDENTS_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public List<Incident> getIncidents(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_INCIDENT", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident getIncident(String var1);

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_INCIDENT_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident getIncident(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_ADD_INC_FILE", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String addIncidentFile(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_ADD_INC_FILE_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String addIncidentFile(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_CREATE_INCIDENT", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident createIncident(String var1, String var2, String var3, String var4, String var5) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_CREATE_INCIDENT_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Incident createIncident(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_INC_FILE_CONTENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String getIncidentFileContents(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_INC_FILE_CONTENTS_ADR", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String getIncidentFileContents(String var1, String var2, String var3) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_ORACLE_HOME", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public String getADROracleHome();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_BASE", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public String getADRBase();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_HOMES", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public List<String> getADRHomes();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_HOME", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public String getADRHome();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_HOMES_ABS_PATH", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public List<String> getADRHomesAbsolutePath();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_HOME_ABS_PATH", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @AttributeGetterRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public String getADRHomeAbsolutePath();

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_PRODUCT_ID", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public String getADRProductId(String var1);

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ADR_INSTANCE_ID", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor, GlobalSecurityRole.Operator})
    public String getADRInstanceId(String var1);

    @Description(resourceKey="DFW_INCIDENTMXBEAN_QUERY_INCIDENTS", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<String, List<Incident>> queryIncidents(String var1) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_GET_ZIPPED_INCIDENT", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public String getZippedIncident(String var1, String var2) throws Exception;

    @Description(resourceKey="DFW_INCIDENTMXBEAN_RELOAD_CUSTOM_RULES", resourceBundleBaseName="oracle.dfw.resource.DiagnosticTranslation")
    @OperationRequiredGlobalSecurityRoles(value={GlobalSecurityRole.Monitor})
    public Map<String, String> reloadCustomRules(String var1) throws Exception;
}

