/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class MemoryTypeStats
implements GroupRefresh {
    private static HashMap<MemoryType, MemoryTypeStats> s_stats = new HashMap();
    private static MemoryMXBean s_memoryMXBean = null;
    private MemoryType m_memoryType = null;
    private State m_usedState = null;
    private State m_committedState = null;
    private State m_maxState = null;
    private State m_initState = null;

    private MemoryTypeStats(Noun baseNoun, MemoryType memoryType) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        this.m_memoryType = memoryType;
        Noun noun = Noun.create(baseNoun, memoryType.toString(), "JVM_MemorySet");
        this.m_usedState = State.create(noun, "used", (byte)2, "KB", "memory in use");
        this.m_usedState.setRefresh(this);
        this.m_maxState = State.create(noun, "max", (byte)2, "KB", "available");
        this.m_maxState.setRefresh(this);
        this.m_committedState = State.create(noun, "committed", (byte)2, "KB", "to the JVM");
        this.m_committedState.setRefresh(this);
        this.m_initState = State.create(noun, "init", (byte)2, "KB", "requested by JVM");
        long kb = this.toKb(this.getMemoryUsage().getInit());
        this.m_initState.update(kb);
        this.refresh();
    }

    private long toKb(long numBytes) {
        return (numBytes + 512L) / 1024L;
    }

    private MemoryUsage getMemoryUsage() {
        MemoryUsage memoryUage = null;
        switch (this.m_memoryType) {
            case HEAP: {
                memoryUage = s_memoryMXBean.getHeapMemoryUsage();
                break;
            }
            case NON_HEAP: {
                memoryUage = s_memoryMXBean.getNonHeapMemoryUsage();
            }
        }
        return memoryUage;
    }

    public static MemoryTypeStats create(Noun base, MemoryType type) {
        if (base == null || type == null) {
            return null;
        }
        MemoryTypeStats stats = s_stats.get((Object)type);
        if (stats != null) {
            return stats;
        }
        stats = new MemoryTypeStats(base, type);
        s_stats.put(type, stats);
        return stats;
    }

    @Override
    public void refresh() {
        MemoryUsage usage = this.getMemoryUsage();
        long kb = this.toKb(usage.getUsed());
        this.m_usedState.update(kb);
        kb = this.toKb(usage.getMax());
        this.m_maxState.update(kb);
        kb = this.toKb(usage.getCommitted());
        this.m_committedState.update(kb);
    }

    static void exit() {
        s_stats.clear();
    }

    static {
        s_memoryMXBean = ManagementFactory.getMemoryMXBean();
    }
}

