/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class LongValue
extends Value {
    private long _value = 0L;
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;

    private void setValue(long newval) {
        this._value = newval;
        if (this.MAX && this._value > this._max) {
            this._max = newval;
        }
        if (this.MIN && this._value < this._min) {
            this._min = newval;
        }
    }

    @Override
    public void update(long newval) {
        this.setValue(newval);
    }

    @Override
    public void update(double newval) {
        long lval = 0L;
        lval = newval >= 0.0 ? Math.round(newval) : -Math.round(-newval);
        this.setValue(lval);
    }

    @Override
    public void update(int newval) {
        long lval = newval;
        this.setValue(lval);
    }

    @Override
    public void increment() {
        long lval = this._value + 1L;
        this.setValue(lval);
    }

    @Override
    public void increment(int inc) {
        long lval = this._value + (long)inc;
        this.setValue(lval);
    }

    @Override
    public void increment(long inc) {
        long lval = this._value + inc;
        this.setValue(lval);
    }

    @Override
    public void increment(double inc) {
        long lval = (long)(inc + 0.5);
        this.setValue(lval += this._value);
    }

    @Override
    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Long.MAX_VALUE) {
            return this._min;
        }
        return 0L;
    }

    @Override
    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Long.MIN_VALUE) {
            return this._max;
        }
        return 0L;
    }

    @Override
    public String toString() {
        return Long.toString(this._value);
    }

    @Override
    public Object clone() {
        LongValue retVal = (LongValue)super.clone();
        return retVal;
    }
}

