/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.wls;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.wls.WLSExecutionContext;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.servlet.DMSServletRequestInspector;
import oracle.dms.util.Time;

public class DMSServletFilter
extends oracle.dms.servlet.DMSServletFilter {
    private static final String CLASS_NAME = DMSServletFilter.class.getName();
    private static final String USER_AGENT_JAXRPC_1x1 = "Oracle JAX-RPC 1.1";
    private static final String USER_AGENT_JAXWS_2x1x4 = "Oracle JAX-WS 2.1.4";
    private static final String USER_AGENT_JAXWS_2x1x5 = "Oracle JAX-WS 2.1.5";
    private static final String USER_AGENT_JAXWS_2x2x1 = "Oracle JAX-WS 2.2.1";

    @Override
    protected DMSServletRequestInspector getRequestInsepctor() {
        return new RequestInspectorForWLS();
    }

    public static class RequestInspectorForWLS
    extends DMSServletRequestInspector {
        private static final String CLASS_NAME = RequestInspectorForWLS.class.getName();

        public static boolean transferHttpRequest(WLSExecutionContext fromContext, WLSExecutionContext toContext) {
            String userAgent;
            HttpServletRequest fromRequest;
            String METHOD_NAME = "transferHttpRequest";
            boolean retVal = false;
            if (fromContext != null && toContext != null && fromContext != toContext && (fromRequest = (HttpServletRequest)fromContext.getCachedObject(DomainExecutionContext.ObjectCacheKey.HTTP_REQUEST)) != null && ((userAgent = fromRequest.getHeader("User-Agent")).startsWith("JAX-RPC") || userAgent.startsWith("JAX-WS"))) {
                block4: {
                    toContext.setCachedObject(DomainExecutionContext.ObjectCacheKey.HTTP_REQUEST, fromRequest);
                    try {
                        EventReportingManager eMgr = EventSystem.getEventReportingManager();
                        if (eMgr != null) {
                            ExecutionContext fromExecCtx = fromContext.getAsMutableExecutionContext();
                            ExecutionContext toExecCtx = toContext.getAsMutableExecutionContext();
                            eMgr.reportEvent(null, EventSourceType.HTTP_REQUEST, EventActionType.CONTEXT_CHANGED, Time.currentTimeMillis(), toExecCtx, new Object[]{fromRequest, fromExecCtx, toExecCtx});
                        }
                    }
                    catch (Exception t) {
                        if (!sLogger.isLoggable(Level.WARNING)) break block4;
                        LogRecord lr = new LogRecord(Level.WARNING, "DMS-58034");
                        lr.setResourceBundle(sLogger.getResourceBundle());
                        lr.setSourceClassName(CLASS_NAME);
                        lr.setSourceMethodName("transferHttpRequest");
                        lr.setParameters(new Object[]{toContext == null ? "(unknown)" : toContext.getIDasString(), fromRequest.getRequestURL().toString()});
                        lr.setThrown(t);
                        sLogger.log(lr);
                    }
                }
                retVal = true;
            }
            return retVal;
        }

        @Override
        public void deactivateContext(ExecutionContext endContext) {
            WLSExecutionContext wlsContext = (WLSExecutionContext)endContext.getDomainExecutionContext();
            wlsContext.deactivate(false);
            wlsContext.disassociateWithThread(false);
        }
    }
}

