/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.util.StackTrace;
import oracle.dms.util.Time;

public class StackTraceAggregate {
    Vector<StackTrace> stv = new Vector();
    private AtomicLong mLastDumpTime = new AtomicLong(Time.currentTimeMillis());

    protected synchronized void addStackTrace(StackTrace st) {
        if (this.stv.isEmpty()) {
            this.stv.add(st);
        } else {
            Vector v = (Vector)this.stv.clone();
            Enumeration est = v.elements();
            while (est.hasMoreElements()) {
                StackTrace ost = (StackTrace)est.nextElement();
                if (!ost.equals(st)) continue;
                ost.incCount();
                return;
            }
            this.stv.add(st);
        }
    }

    protected synchronized void printStackTraces(String eventType) {
        this.printStackTraces(eventType, System.err);
    }

    protected synchronized void printStackTraces(String eventType, PrintStream printStream) {
        Enumeration<StackTrace> est = this.stv.elements();
        while (est.hasMoreElements()) {
            String s = StackTraceAggregate.getStackTraceAsString(est.nextElement(), eventType);
            printStream.println(s);
        }
        this.mLastDumpTime.set(Time.currentTimeMillis());
    }

    protected synchronized void printStackTraces(String eventType, Logger logger) {
        Enumeration<StackTrace> est = this.stv.elements();
        while (est.hasMoreElements()) {
            String s = StackTraceAggregate.getStackTraceAsString(est.nextElement(), eventType);
            logger.log(Level.INFO, s);
        }
        this.mLastDumpTime.set(Time.currentTimeMillis());
    }

    private static String getStackTraceAsString(StackTrace ost, String eventType) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("The ").append(eventType).append(" stack occurred ").append(ost.getCount()).append(" times: \n");
        StackTraceElement[] ste = ost.getStackElements();
        for (int i = 0; i < ste.length; ++i) {
            sb.append("--> ").append(ste[i].getClassName()).append(".").append(ste[i].getMethodName()).append('\n');
        }
        return sb.toString();
    }

    protected synchronized void clearStackTraces() {
        this.stv.clear();
    }

    protected long getLastDumpTime() {
        return this.mLastDumpTime.get();
    }
}

