/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jfr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupportFactory;

public class JFREnvironmentInspector {
    private JFREnvironmentInspector() {
    }

    public static Availability isFlightRecorderAvailable() {
        Availability retVal;
        Logger logger = Logger.getLogger("oracle.dms.event", EventResourceBundle.class.getName());
        Platform platform = PlatformSupportFactory.getPlatformSupport().getPlatform();
        if (platform == Platform.WebLogic || platform == Platform.WebLogicAS) {
            Class<?> flightRecorderClass = null;
            String flightRecorderClassName = "com.oracle.jrockit.jfr.FlightRecorder";
            try {
                flightRecorderClass = Class.forName("com.oracle.jrockit.jfr.FlightRecorder");
                try {
                    Method isActiveMethod = flightRecorderClass.getMethod("isActive", null);
                    boolean isActive = (Boolean)isActiveMethod.invoke((Object)null, (Object[])null);
                    retVal = isActive ? Availability.AVAILABLE : Availability.SUPPORTED_BUT_NOT_AVAILABLE;
                }
                catch (NoSuchMethodException nsmee) {
                    retVal = Availability.SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM;
                    logger.log(Level.FINE, "NoSuchMethodException: com.oracle.jrockit.jfr.FlightRecorder.isActive(). FlightRecorder not available in this environment.");
                }
                catch (InvocationTargetException ite) {
                    retVal = Availability.SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM;
                    logger.log(Level.FINE, "InvocationTargetException: com.oracle.jrockit.jfr.FlightRecorder.isActive(). FlightRecorder not available in this environment.");
                }
                catch (IllegalAccessException iae) {
                    retVal = Availability.SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM;
                    logger.log(Level.FINE, "IllegalAccessException: com.oracle.jrockit.jfr.FlightRecorder.isActive(). FlightRecorder not available in this environment.");
                }
            }
            catch (ClassNotFoundException e) {
                retVal = Availability.SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM;
                logger.log(Level.FINE, "ClassNotFoundException: com.oracle.jrockit.jfr.FlightRecorder. FlightRecorder not available in this environment.");
            }
        } else {
            retVal = Availability.NOT_SUPPORTED_BY_PLATFORM;
            logger.log(Level.FINE, "Platform is not WebLogic or WebLogicAS. FlightRecorder not available in this environment.");
        }
        logger.log(Level.FINE, "isFlightRecorderAvailable? " + (Object)((Object)retVal));
        return retVal;
    }

    private static boolean supportedByJVM() {
        return true;
    }

    public static enum Availability {
        NOT_SUPPORTED_BY_PLATFORM,
        SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM,
        SUPPORTED_BUT_NOT_AVAILABLE,
        AVAILABLE;

    }
}

