/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.producer;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import oracle.dms.producer.MetricConvertor;
import oracle.dms.producer.RowInfo;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.MBeanTreeletNode;
import oracle.dms.reporter.TreeletGenerator;
import oracle.dms.reporter.TreeletNode;

public class MBeanTreeletGenerator
extends TreeletGenerator {
    private MBeanServer m_mbeanServer;
    private MetricConvertor m_metricConvertor;
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");

    public MBeanTreeletGenerator(MBeanServer mbeanServer, MetricConvertor metricConvertor) {
        if (mbeanServer == null) {
            throw new IllegalArgumentException("mbeanServer=" + mbeanServer);
        }
        this.m_mbeanServer = mbeanServer;
        this.m_metricConvertor = metricConvertor;
    }

    @Override
    protected BranchTreeletNode createRootNode() {
        return new MBeanTreeletNode(null);
    }

    @Override
    public void getTreeletNodes(String[] tables, String[] names, Collection<String> badNames, Collection<String> badTables) {
        String METHOD_NAME = "getTreeletNodes";
        if (this.m_metricConvertor == null) {
            return;
        }
        this.getTreeletNodeByTables(tables, badTables);
        if (names != null && names.length > 0) {
            for (String name : names) {
                ObjectName objName;
                try {
                    objName = new ObjectName(name);
                }
                catch (MalformedObjectNameException e) {
                    badNames.add(name);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.logp(Level.FINEST, this.getClass().getName(), "getTreeletNodes", "Invalid object name: " + name, e);
                    continue;
                }
                this._getTreeletNodeByObjName(objName, name, null, badNames, null);
            }
        } else if (tables == null || tables.length == 0) {
            this._getTreeletNodeByObjName(MetricConvertor.QUERY_ALL_MBEANS, null, null, null, null);
        } else {
            return;
        }
    }

    @Override
    protected void resetMetrics() {
    }

    @Override
    protected void getTreeletNodeByTables(String[] tables, Collection<String> badTables) {
        if (tables == null || tables.length == 0 || this.m_metricConvertor == null) {
            return;
        }
        for (String table : tables) {
            Set<ObjectName> objNames = this.m_metricConvertor.getObjectNames(table);
            if (objNames == null || objNames.size() == 0) {
                badTables.add(table);
                continue;
            }
            for (ObjectName objName : objNames) {
                this._getTreeletNodeByObjName(objName, null, table, null, badTables);
            }
        }
    }

    @Override
    protected TreeletNode getDescendant(BranchTreeletNode parent, String name, char delim) {
        return null;
    }

    @Override
    protected void queryMetricValues() {
        Collection branches = this.m_root.getBranches(false);
        if (branches == null || branches.size() == 0) {
            return;
        }
        for (BranchTreeletNode branch : branches) {
            MBeanTreeletNode mbeanNode = (MBeanTreeletNode)branch;
            RowInfo rowInfo = (RowInfo)mbeanNode.getNode();
            Map<String, Serializable> columnValues = this.m_metricConvertor.getColumnValues(rowInfo);
            mbeanNode.addColumnValues(columnValues);
        }
    }

    private void _getTreeletNodeByObjName(ObjectName objectName, String name, String table, Collection<String> badNames, Collection<String> badTables) {
        String METHOD_NAME = "_getTreeletNodeByObjName";
        if (this.m_metricConvertor == null) {
            return;
        }
        Set<Object> objNames = null;
        if (objectName.isPattern()) {
            try {
                objNames = this.m_mbeanServer.queryNames(objectName, null);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, this.getClass().getName(), "_getTreeletNodeByObjName", "DMS-50973", e);
                }
            }
        } else {
            objNames = new HashSet<ObjectName>(3);
            objNames.add(objectName);
        }
        if (objNames == null || objNames.size() == 0) {
            if (badNames != null && name != null) {
                badNames.add(name);
            } else if (badTables != null && table != null) {
                badTables.add(table);
            }
            return;
        }
        boolean found = false;
        for (ObjectName objectName2 : objNames) {
            RowInfo rowInfo = this.m_metricConvertor.getRowInfo(objectName2);
            if (rowInfo == null) continue;
            found = true;
            MBeanTreeletNode mbNode = new MBeanTreeletNode(rowInfo, (MBeanTreeletNode)this.m_root);
            this.m_root.addBranch(objectName2.getCanonicalName(), mbNode);
        }
        if (!found) {
            if (badNames != null && name != null) {
                badNames.add(name);
            } else if (badTables != null && table != null) {
                badTables.add(table);
            }
        }
    }
}

