/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.internal.ParamScopedMetricsRuntimeManager;
import oracle.dms.instrument.internal.ParamScopedMetricsSystem;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class Event
extends Sensor
implements EventIntf {
    private int _count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event create(String pathname, String desc) {
        EventReportingManager eMgr;
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("DMS-50752", "Event.create()", "" + pathname + ":" + desc);
        }
        Event ev = (Event)Sensor.lookupCache(pathname);
        if (ev != null) {
            return ev;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        boolean newEvent = false;
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            ev = (Event)parent.getSensor(sanitizedName);
            if (ev != null) {
                ev.addToCache(pathname);
            } else {
                ev = new Event(false, parent, sanitizedName, desc);
                newEvent = true;
            }
        }
        if (newEvent && (eMgr = EventSystem.getEventReportingManager()) != null && parent.getDescriptor() != null && parent.getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(ev, EventSourceType.EVENT_SENSOR, EventActionType.CREATE, ev.mCreateTime, null, null);
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event create(Noun parent, String name, String desc) {
        EventReportingManager eMgr;
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("DMS-50752", "Event.create()", "" + parent + ":" + name + ":" + desc);
        }
        Event e = null;
        boolean newEvent = false;
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            e = (Event)parent.getSensor(sanitizedName);
            if (e == null) {
                e = new Event(false, parent, sanitizedName, desc);
                newEvent = true;
            }
        }
        if (newEvent && (eMgr = EventSystem.getEventReportingManager()) != null && parent.getDescriptor() != null && parent.getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(e, EventSourceType.EVENT_SENSOR, EventActionType.CREATE, e.mCreateTime, null, null);
        }
        return e;
    }

    @Deprecated
    public Event(Noun parent, String name, String desc) {
        this(true, parent, name, desc);
    }

    @Deprecated
    private Event(boolean sanitizeName, Noun parent, String name, String desc) {
        super(sanitizeName, parent, name, desc);
        this.setUpdateTime(0L);
        this._metrics[1] = Metric.create(this._name + ".count", this._description, "ops", this, false, (byte)3, (byte)1);
    }

    public static void occurred(String pathname) {
        ((Event)Sensor.get(pathname)).occurred();
    }

    @Override
    public void occurred() {
        this.occurred((ActivationParameter[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void occurred(ActivationParameter ... parameters) {
        int count;
        if (!this._alive) {
            return;
        }
        Event event = this;
        synchronized (event) {
            count = ++this._count;
        }
        this._lastUpdate = Time.currentTimeMillis();
        if (this._refresh == null) {
            ParamScopedMetricsRuntimeManager psmrm;
            EventReportingManager eMgr = EventSystem.getEventReportingManager();
            if (eMgr != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.UPDATE)) {
                eMgr.reportEvent(this, EventSourceType.EVENT_SENSOR, EventActionType.UPDATE, this._lastUpdate, null, new Object[]{parameters});
            }
            if ((psmrm = ParamScopedMetricsSystem.getRuntimeManager()) != null) {
                psmrm.handleEventSensorUpdate(this, this._lastUpdate, parameters);
            }
        }
        if (this.isLoggable()) {
            this.logActivation("" + count);
        }
        Bucket.drop((Sensor)this, 1, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void occurred(Object[] inserts) {
        ParamScopedMetricsRuntimeManager psmrm;
        EventReportingManager eMgr;
        int count;
        if (!this._alive) {
            return;
        }
        Event event = this;
        synchronized (event) {
            count = ++this._count;
        }
        this._lastUpdate = Time.currentTimeMillis();
        if (this._refresh == null && (eMgr = EventSystem.getEventReportingManager()) != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.UPDATE)) {
            eMgr.reportEvent(this, EventSourceType.EVENT_SENSOR, EventActionType.UPDATE, this._lastUpdate, null, null);
        }
        if ((psmrm = ParamScopedMetricsSystem.getRuntimeManager()) != null) {
            psmrm.handleEventSensorUpdate(this, this._lastUpdate, null);
        }
        if (this.isLoggable()) {
            this.logActivation("" + count, inserts);
        }
        Bucket.drop((Sensor)this, 1, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Metric m) {
        if (m == null) {
            m = this.getMetric(2);
        }
        if (!m.isAlive()) {
            return new ErrorObject();
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("DMS-50751", m.toString(), this.toString());
        }
        Event event = this;
        synchronized (event) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 1: {
                    return this._count;
                }
            }
        }
        throw new InstrumentationException("DMS-50751", m.toString(), this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this._alive) {
            return;
        }
        long timeStamp = Time.currentTimeMillis();
        Event event = this;
        synchronized (event) {
            this._count = 0;
            this.setResetTime(timeStamp);
        }
    }

    @Override
    public void deriveMetric(int metric) {
    }

    public Event getCousin(Noun pre) {
        Event retval = null;
        if (!this._alive) {
            return retval;
        }
        Noun cousinNoun = this.getParent().getCousin(pre);
        if (cousinNoun != null) {
            retval = Event.create(cousinNoun, this._name, "cousin");
        }
        return retval;
    }

    @Override
    EventSourceType getSourceType() {
        return EventSourceType.EVENT_SENSOR;
    }

    @Override
    public boolean isInitialized() {
        return this._count > 0;
    }

    @Override
    public ActivationParameter[] getActivationParametersFromEvent(oracle.dms.event.Event event) {
        return (ActivationParameter[])event.getSubsidiaryObject(0);
    }
}

