/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.util.StringTokenizer;
import oracle.core.ojdl.LogMessage;
import oracle.dms.util.DMSUtil;

public abstract class Request {
    public static final String OPERATION = "operation";
    public static final String NAME = "name";
    @Deprecated
    public static final String NOUNTYPE = "nountype";
    public static final String TABLE = "table";
    public static final String VALUE = "value";
    public static final String UNITS = "units";
    public static final String DESCRIPTION = "description";
    public static final String RECURSE = "recurse";
    public static final String FORMAT = "format";
    public static final String NEW_VALUE = "newvalue";
    public static final String ORDERBY = "orderby";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String RESET = "reset";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String XML = "xml";
    public static final String PDML = "pdml";
    public static final String TBML = "tbml";
    public static final String HTML = "html";
    public static final String RAW = "raw";
    public static final String METRIC_TABLE = "metrictable";
    public static final String METRIC_LIST = "metriclist";
    public static final String METRIC_HELP = "metrichelp";
    public static final String TRANSTRACE = "transtrace";
    public static final String CHILDREN = "children";
    public static final String ALL = "all";
    public static final String NONE = "none";
    public static final String ASC = "asc";
    public static final String CACHE = "cache";
    public static final String DESC = "desc";
    public static final String INTERVAL = "interval";
    public static final String PRE_FETCH = "prefetch";
    public static final String REFRESH_ALL = "refreshall";
    public static final String REFRESH_VALUES = "refreshvalues";
    public static final String ROWS = "rows";
    public static final String SCHEMA = "schema";
    public static final String HISTORICAL = "historical";
    public static final String VALUE_REFRESH = "valuerefresh";
    public static final String VARIABLE = "variable";
    public static final String VARIABLE_NULL = "variablenull";
    public static final String VAR_PREFIX = "var_";
    public static final String VERSION = "version";
    public static final String RAW_QUERY = "format=raw&units=true&description=true&value=true";
    public static final String NO_DOC_TYPE = "nodoctype";
    public static final String DUMP_RAW_QUERY = "format=raw&units=true&description=true&value=true&nodoctype=true";
    protected String m_userPasswd = null;
    protected LogMessage.InstanceId m_instanceId = null;
    protected boolean m_setInstId = false;
    protected String[] m_names = null;
    protected String[] m_tables = null;
    protected Boolean m_includeUnit = null;
    protected Boolean m_includeValue = null;
    protected Boolean m_includeDescription = null;
    protected String m_newValue = null;
    protected String m_orderBy = null;
    protected String m_format = null;
    protected String m_operation = null;
    protected String m_includeDescendents = null;
    protected String m_requestURL = null;

    public abstract String getMethod();

    public abstract String getHeader(String var1);

    public abstract String getParameter(String var1);

    public abstract String[] getParameterValues(String var1);

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getRequestedSessionId();

    public abstract String getQueryString();

    public abstract String getRequestURI();

    public String[] getNames() {
        if (this.m_names != null) {
            return (String[])this.m_names.clone();
        }
        this.m_names = this.getParameterValues(NAME);
        if (this.m_names == null) {
            return null;
        }
        for (int i = 0; i < this.m_names.length; ++i) {
            if (this.m_names[i] == null) continue;
            this.m_names[i] = DMSUtil.xssEscape(this.m_names[i]);
        }
        return (String[])this.m_names.clone();
    }

    public String[] getTables() {
        if (this.m_tables != null) {
            return (String[])this.m_tables.clone();
        }
        this.m_tables = this.getParameterValues(TABLE);
        if (this.m_tables == null) {
            this.m_tables = this.getParameterValues(NOUNTYPE);
        }
        if (this.m_tables == null) {
            return null;
        }
        return (String[])this.m_tables.clone();
    }

    public boolean includeUnits() {
        if (this.m_includeUnit != null) {
            return this.m_includeUnit;
        }
        String unit = this.getParameter(UNITS);
        boolean ret = TRUE.equalsIgnoreCase(unit);
        this.m_includeUnit = ret;
        return ret;
    }

    public boolean includeValues() {
        if (this.m_includeValue != null) {
            return this.m_includeValue;
        }
        String value = this.getParameter(VALUE);
        boolean ret = !FALSE.equalsIgnoreCase(value);
        this.m_includeValue = ret;
        return ret;
    }

    public boolean includeDescription() {
        if (this.m_includeDescription != null) {
            return this.m_includeDescription;
        }
        String description = this.getParameter(DESCRIPTION);
        boolean ret = TRUE.equalsIgnoreCase(description);
        this.m_includeDescription = ret;
        return ret;
    }

    public String getNewValue() {
        if (this.m_newValue != null) {
            return this.m_newValue;
        }
        this.m_newValue = this.getParameter(NEW_VALUE);
        if (this.m_newValue == null) {
            this.m_newValue = "";
        }
        return this.m_newValue;
    }

    public String getOrderBy() {
        if (this.m_orderBy != null) {
            return this.m_orderBy;
        }
        this.m_orderBy = this.getParameter(ORDERBY);
        if (this.m_orderBy == null) {
            this.m_orderBy = "";
        }
        this.m_orderBy = DMSUtil.xssEscape(this.m_orderBy);
        return this.m_orderBy;
    }

    public String getBasicAuthorization() {
        if (this.m_userPasswd != null) {
            return this.m_userPasswd;
        }
        String authorizationString = this.getHeader("authorization");
        if (authorizationString == null) {
            this.m_userPasswd = "";
            return this.m_userPasswd;
        }
        StringTokenizer st = new StringTokenizer(authorizationString);
        String enUserPasswd = null;
        if (st.hasMoreTokens()) {
            if (!"basic".equalsIgnoreCase(st.nextToken())) {
                this.m_userPasswd = "";
                return this.m_userPasswd;
            }
            if (st.hasMoreTokens()) {
                enUserPasswd = st.nextToken();
            }
        }
        this.m_userPasswd = enUserPasswd == null ? "" : enUserPasswd;
        return this.m_userPasswd;
    }

    public LogMessage.InstanceId getInstanceID() {
        if (this.m_instanceId != null) {
            return this.m_instanceId;
        }
        if (this.m_setInstId) {
            return null;
        }
        this.m_setInstId = true;
        String strCtx = this.getHeader("oracle-ecid");
        if (strCtx == null) {
            return null;
        }
        int index = strCtx.indexOf(44);
        if (index > 0) {
            int ctxSeq;
            String ctxUId = strCtx.substring(0, index);
            try {
                ctxSeq = Integer.parseInt(strCtx.substring(index + 2));
            }
            catch (Exception e) {
                ctxSeq = -1;
            }
            if (ctxSeq >= 0) {
                this.m_instanceId = new LogMessage.InstanceId(ctxUId, ctxSeq + 1);
                return this.m_instanceId;
            }
        }
        return null;
    }

    public boolean isFormat(String formatString) {
        if (formatString == null) {
            return false;
        }
        if (this.m_format == null) {
            this.m_format = this.getParameter(FORMAT);
            if (this.m_format == null) {
                this.m_format = "";
            }
        }
        return formatString.equalsIgnoreCase(this.m_format);
    }

    public boolean isOperation(String opString) {
        if (opString == null) {
            return false;
        }
        if (this.m_operation == null) {
            this.m_operation = this.getParameter(OPERATION);
            if (this.m_operation == null) {
                this.m_operation = GET;
            }
        }
        return opString.equalsIgnoreCase(this.m_operation);
    }

    public boolean includeDescendents(String incluDescentString) {
        if (incluDescentString == null) {
            return false;
        }
        if (this.m_includeDescendents == null) {
            this.m_includeDescendents = this.getParameter(RECURSE);
            if (this.m_includeDescendents == null) {
                this.m_includeDescendents = "";
            }
        }
        return incluDescentString.equalsIgnoreCase(this.m_includeDescendents);
    }

    public String getRequestURL() {
        if (this.m_requestURL != null) {
            return this.m_requestURL;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.getServerName());
        int port = this.getServerPort();
        if (port != 80 && port != 0) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        this.m_requestURL = url.toString();
        return this.m_requestURL;
    }
}

