/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import com.oracle.jrockit.jfr.FlightRecorder;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.impl.dump.AccessCheck;
import oracle.dfw.resource.DiagnosticTranslation;

public class JavaFlightRecorderDump
extends ComponentDiagnosticDump {
    private FlightRecorderClient m_recorderClient;
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();

    @Override
    public DumpResult executeDump(final DumpContext context) throws DumpExecutionException {
        DumpResult result = null;
        try {
            final File dumpFile = context.generateUniqueFile("jfr");
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<DumpResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DumpResult run() throws Exception {
                    if (FlightRecorder.isActive()) {
                        if (JavaFlightRecorderDump.this.m_recorderClient == null) {
                            JavaFlightRecorderDump.this.m_recorderClient = new FlightRecorderClient();
                        }
                        for (FlightRecordingClient recordingClient : JavaFlightRecorderDump.this.m_recorderClient.getRecordingObjects()) {
                            if (!recordingClient.getName().startsWith("WLDF")) continue;
                            FlightRecordingClient tempClient = null;
                            try {
                                tempClient = recordingClient.cloneRecordingObject("DFW", true);
                                if (tempClient == null) break;
                                tempClient.copyTo(AccessCheck.getAbsolutePath(dumpFile), true);
                                break;
                            }
                            finally {
                                if (tempClient != null) {
                                    tempClient.close();
                                }
                            }
                        }
                        return new DumpResult(context, dumpFile.getName());
                    }
                    DumpWriter dw = new DumpWriter(context);
                    dw.dump("Java Flight Recorder is not active");
                    return dw.getDumpResult();
                }
            });
        }
        catch (Throwable e) {
            Throwable t = e;
            if (e instanceof PrivilegedActionException) {
                t = ((PrivilegedActionException)e).getCause();
            }
            throw new DumpExecutionException("failure dumping Java Flight Recording", t);
        }
        return result;
    }

    @Override
    public String getName() {
        return "flightRecording";
    }

    @Override
    public String getOwner() {
        return "jvm";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.PERFORMANCE, DiagnosticsCategory.MEMORY, DiagnosticsCategory.PROCESS, DiagnosticsCategory.THREADS);
    }

    @Override
    public String getDumpDescription() {
        return this.getDumpDescription(null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_JFRDUMP_DESCRIPTION", locale);
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }
}

