/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.common;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dfw.common.ArgumentDescriptor;
import oracle.dfw.common.ArgumentType;

public class ArgumentDescriptorImpl
implements ArgumentDescriptor,
Serializable {
    private String m_name;
    private ArgumentType m_type;
    private String m_description;
    private String m_resourceBundle;
    private String m_resourceKey;
    private static final long serialVersionUID = 0L;

    public ArgumentDescriptorImpl(String name, ArgumentType type, String desc) {
        this.m_name = name;
        this.m_type = type;
        this.m_description = desc;
    }

    public ArgumentDescriptorImpl(String name, ArgumentType type, String resourceBundle, String resourceKey) {
        this.m_name = name;
        this.m_type = type;
        this.m_resourceBundle = resourceBundle;
        this.m_resourceKey = resourceKey;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ArgumentType getType() {
        return this.m_type;
    }

    @Override
    public String getDescription() {
        return this.getDescription(null, null);
    }

    @Override
    public String getDescription(Locale locale, ClassLoader loader) {
        if (this.m_description != null) {
            return this.m_description;
        }
        try {
            if (locale != null && loader != null) {
                return ResourceBundle.getBundle(this.m_resourceBundle, locale, loader).getString(this.m_resourceKey);
            }
            if (locale != null) {
                return ResourceBundle.getBundle(this.m_resourceBundle, locale).getString(this.m_resourceKey);
            }
            return ResourceBundle.getBundle(this.m_resourceBundle).getString(this.m_resourceKey);
        }
        catch (Exception e) {
            return this.m_resourceKey;
        }
    }
}

