/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashSet;
import java.util.Hashtable;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.Descriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.internal.ActivationParameterDescriptorEx;
import oracle.dms.util.ClientObjectHolderImpl;
import oracle.dms.util.ClientObjectKey;
import oracle.dms.util.ClientObjectKeyManager;
import oracle.dms.util.Time;

public class NounDescriptor
extends Descriptor {
    private Hashtable<String, SensorDescriptor> m_children = new Hashtable(31);
    private HashSet<String> m_ancestorTypes = new HashSet(31);
    private HashSet<Noun> m_nouns = new HashSet(31);
    private boolean m_isTraceable = false;
    private volatile long m_lastUpdateTime = Time.currentTimeMillis();
    private ActivationParameterDescriptor[] mActivationParameterDescriptors;
    private boolean mActivationParameterDescriptorsSet = false;
    private volatile boolean[] m_isEventable;
    private final ClientObjectHolderImpl mClientObjectHolderImpl = new ClientObjectHolderImpl(ClientObjectKeyManager.ClientObjectHolderType.NOUN_DESCRIPTOR);

    public NounDescriptor(String name) {
        super(name);
        this.setTraceable();
        this.setEventable(EventSystem.getEventConfigManager());
    }

    public SensorDescriptor getSensorDescriptor(String name) {
        return this.m_children.get(name);
    }

    public void addSensorDescriptor(SensorDescriptor sdesc) {
        if (sdesc == null) {
            return;
        }
        if (this.m_children.put(sdesc.getName(), sdesc) == null) {
            this.m_lastUpdateTime = Time.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSensorNames() {
        String[] ret = null;
        Hashtable<String, SensorDescriptor> hashtable = this.m_children;
        synchronized (hashtable) {
            ret = new String[this.m_children.size()];
            this.m_children.keySet().toArray(ret);
        }
        return ret;
    }

    public int getSensorCount() {
        return this.m_children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAncestorTypes() {
        String[] ret = null;
        HashSet<String> hashSet = this.m_ancestorTypes;
        synchronized (hashSet) {
            ret = new String[this.m_ancestorTypes.size()];
            this.m_ancestorTypes.toArray(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAncestorCount() {
        HashSet<String> hashSet = this.m_ancestorTypes;
        synchronized (hashSet) {
            return this.m_ancestorTypes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAncestorTypes(Noun parent) {
        if (parent == null) {
            return;
        }
        NounDescriptor pdesc = null;
        boolean added = false;
        while (parent.getParent() != null) {
            pdesc = parent.getDescriptor();
            if (pdesc != null) {
                HashSet<String> hashSet = this.m_ancestorTypes;
                synchronized (hashSet) {
                    added |= this.m_ancestorTypes.addAll(pdesc.m_ancestorTypes);
                }
                if (added |= this.m_ancestorTypes.add(parent.getType())) {
                    this.m_lastUpdateTime = Time.currentTimeMillis();
                }
                return;
            }
            parent = parent.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNoun(Noun noun) {
        if (noun == null) {
            return;
        }
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            this.m_nouns.add(noun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNoun(Noun noun) {
        if (noun == null) {
            return false;
        }
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            return this.m_nouns.remove(noun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNounCount() {
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            return this.m_nouns.size();
        }
    }

    public void setTraceable(boolean b) {
        this.m_isTraceable = b;
    }

    private void setTraceable() {
        String name = this.getName();
        if (name.startsWith("oc4j_url") || name.startsWith("oc4j_servlet") || name.startsWith("oc4j_ejb") || name.startsWith("oc4j_jsp(") || name.startsWith("oc4j_webservice_operation") || name.startsWith("JDBC_")) {
            this.setTraceable(true);
        } else {
            this.setTraceable(false);
        }
    }

    public void setEventable(EventConfigManager eventConfigManager) {
        this.m_isEventable = eventConfigManager != null ? eventConfigManager.isNounTypeOfPossibleInterest(this.getName()) : new boolean[EventActionType.values().length];
    }

    public boolean getEventable(EventActionType actionType) {
        return this.m_isEventable[actionType.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Noun[] getNouns() {
        Noun[] ret;
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            ret = new Noun[this.m_nouns.size()];
            this.m_nouns.toArray(ret);
        }
        return ret;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.m_lastUpdateTime = lastUpdateTime;
    }

    public long getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    NounDescriptor duplicateWithoutNouns() {
        NounDescriptor clone = (NounDescriptor)super.clone();
        clone.m_children = new Hashtable<String, SensorDescriptor>(this.m_children);
        clone.m_ancestorTypes = new HashSet<String>(this.m_ancestorTypes);
        clone.m_nouns = new HashSet();
        return clone;
    }

    public void setActivationParameterDescriptors(ActivationParameterDescriptor ... descriptors) {
        boolean descriptorsIdentical = true;
        boolean descriptorsEqual = true;
        if (this.mActivationParameterDescriptorsSet) {
            if (descriptors == null && this.mActivationParameterDescriptors != null) {
                descriptorsIdentical = false;
                descriptorsEqual = false;
            } else if (descriptors != null && this.mActivationParameterDescriptors == null) {
                descriptorsIdentical = false;
                descriptorsEqual = false;
            } else if (descriptors == null && this.mActivationParameterDescriptors == null) {
                descriptorsIdentical = true;
                descriptorsEqual = true;
            } else if (descriptors.length != this.mActivationParameterDescriptors.length) {
                descriptorsIdentical = false;
            } else {
                for (int i = 0; i < descriptors.length; ++i) {
                    if (!descriptors[i].equals(this.mActivationParameterDescriptors[i])) {
                        descriptorsEqual = false;
                    }
                    if (descriptors[i] == this.mActivationParameterDescriptors[i]) continue;
                    descriptorsIdentical = false;
                }
            }
        }
        if (!descriptorsEqual) {
            throw new IllegalStateException("Can not setActivationParameterDescriptors on a NounDescriptor for which ActivationParameterDescriptors have already been set.");
        }
        if (!this.mActivationParameterDescriptorsSet || descriptorsEqual && !descriptorsIdentical) {
            this.mActivationParameterDescriptorsSet = true;
            if (descriptors != null) {
                for (ActivationParameterDescriptor p : this.mActivationParameterDescriptors = (ActivationParameterDescriptor[])descriptors.clone()) {
                    ((ActivationParameterDescriptorEx)p).addNounDescriptor(this);
                }
            }
        }
    }

    public Object setClientObject(ClientObjectKey key, Object value) {
        return this.mClientObjectHolderImpl.setClientObject(key, value);
    }

    public Object getClientObject(ClientObjectKey key) {
        return this.mClientObjectHolderImpl.getClientObject(key);
    }

    public ActivationParameterDescriptor[] getActivationParameterDescriptors() {
        return this.mActivationParameterDescriptors == null ? null : (ActivationParameterDescriptor[])this.mActivationParameterDescriptors.clone();
    }
}

