/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.NameValue;

public enum EventSourceType {
    INSTRUMENTATION_NODE,
    NOUN{

        @Override
        public String toString(Event e) {
            Noun n = (Noun)e.getSource();
            StringBuilder sb = new StringBuilder(128);
            if (n.getType() != null) {
                sb.append(n.getType());
            }
            sb.append(":").append(n.toString());
            return sb.toString();
        }
    }
    ,
    SENSOR{

        @Override
        public String toString(Event e) {
            Sensor s = (Sensor)e.getSource();
            StringBuilder sb = new StringBuilder(128);
            if (s.getParent().getType() != null) {
                sb.append(s.getParent().getType());
            }
            sb.append(":").append(s.getName()).append(":").append(s.getParent().toString());
            EventSourceType.appendActivationParameters(sb, s, e);
            return sb.toString();
        }
    }
    ,
    EVENT_SENSOR{

        @Override
        public String toString(Event event) {
            return SENSOR.toString(event);
        }
    }
    ,
    PHASE_SENSOR{

        @Override
        public String toString(Event event) {
            StringBuilder sb = new StringBuilder(128);
            PhaseEvent phaseSensor = (PhaseEvent)event.getSource();
            if (phaseSensor.getParent().getType() != null) {
                sb.append(phaseSensor.getParent().getType());
            }
            sb.append(":").append(phaseSensor.getName()).append(":").append(phaseSensor.getParent().toString());
            Object[] supplementalObjects = event.getSubsidiaryObjects();
            if (event.getActionType().isTypeOf(EventActionType.UPDATE)) {
                if (event.getActionType() == EventActionType.STOP) {
                    sb.append(":");
                    sb.append(supplementalObjects[0]);
                    sb.append(':').append(supplementalObjects[1]);
                    sb.append(":");
                    sb.append(supplementalObjects[2]);
                } else {
                    sb.append(":");
                    sb.append(supplementalObjects[0]);
                    sb.append(':');
                    sb.append(supplementalObjects[1]);
                }
            }
            EventSourceType.appendActivationParameters(sb, phaseSensor, event);
            return sb.toString();
        }
    }
    ,
    ANONYMOUS_PHASE_SENSOR{

        @Override
        public String toString(Event event) {
            if (!event.getActionType().isTypeOf(EventActionType.START) && !event.getActionType().isTypeOf(EventActionType.ABORT)) {
                throw new IllegalArgumentException("Only START and ABORT are supported on ANONYMOUS_PHASE_SNESOR");
            }
            StringBuilder sb = new StringBuilder(128);
            Object[] supplementalObjects = event.getSubsidiaryObjects();
            if (supplementalObjects[1] == null) {
                sb.append("?unknown-type?");
            } else {
                sb.append(supplementalObjects[1]);
            }
            sb.append(':');
            sb.append("?unknown-name?");
            sb.append(':');
            if (supplementalObjects[2] == null) {
                sb.append("?unknown-leading-path?");
            } else {
                sb.append(supplementalObjects[2]);
            }
            sb.append(":");
            sb.append(supplementalObjects[0]);
            sb.append(":");
            if (supplementalObjects.length < 4) {
                sb.append("null");
            } else {
                sb.append(":");
                NameValue[] activationParameters = (NameValue[])supplementalObjects[3];
                JSONUtils.appendValue(sb, activationParameters);
            }
            return sb.toString();
        }
    }
    ,
    STATE_SENSOR{

        @Override
        public String toString(Event event) {
            Object so;
            StringBuilder sb = new StringBuilder(128);
            State stateSensor = (State)event.getSource();
            if (stateSensor.getParent().getType() != null) {
                sb.append(stateSensor.getParent().getType());
            }
            sb.append(":").append(stateSensor.getName()).append(":").append(stateSensor.getParent().toString()).append(":").append(stateSensor.getValueTypeString()).append(':');
            Object[] supplementalObjects = event.getSubsidiaryObjects();
            if (supplementalObjects != null && supplementalObjects.length >= 1 && (so = supplementalObjects[0]) != null) {
                sb.append(so.toString());
            }
            return sb.toString();
        }
    }
    ,
    ROLLUP_SENSOR{

        @Override
        public String toString(Event event) {
            return SENSOR.toString(event);
        }
    }
    ,
    EXECUTION_CONTEXT,
    HTTP_REQUEST{

        @Override
        public String toString(Event event) {
            String retVal = null;
            try {
                HttpServletRequest request = (HttpServletRequest)event.getSubsidiaryObject(0);
                if (request != null) {
                    retVal = request.getRequestURI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return retVal;
        }
    };

    private int mExactTypeBit = 0;
    private int mAllTypeBits = 0;
    private EventSourceType mSuperType = null;
    private List<EventSourceType> mSubTypeList = new LinkedList<EventSourceType>();

    private void setSuperType(EventSourceType superType) {
        this.mSuperType = superType;
        this.mAllTypeBits |= this.mSuperType.mAllTypeBits;
        this.mSuperType.mSubTypeList.add(this);
    }

    public boolean isTypeOf(EventSourceType querySourceType) {
        return (this.mAllTypeBits & querySourceType.mExactTypeBit) != 0;
    }

    @Deprecated
    List<EventSourceType> getSubTypeList() {
        return this.getSubTypeList(false);
    }

    List<EventSourceType> getSubTypeList(boolean expand) {
        if (expand) {
            ArrayList<EventSourceType> expandedList = new ArrayList<EventSourceType>();
            for (EventSourceType sourceType : this.mSubTypeList) {
                if (sourceType.isSuperType()) {
                    for (EventSourceType subSourceType : sourceType.getSubTypeList(true)) {
                        expandedList.add(subSourceType);
                    }
                    continue;
                }
                expandedList.add(sourceType);
            }
            return expandedList;
        }
        return this.mSubTypeList;
    }

    public boolean isSuperType() {
        if (this.getSubTypeList(false) == null) {
            return false;
        }
        return !this.getSubTypeList(false).isEmpty();
    }

    public String toString(Event event) {
        String retVal = "(null)";
        Object source = event.getSource();
        if (source != null) {
            retVal = source.toString();
        }
        return retVal;
    }

    private static void appendActivationParameters(StringBuilder sb, Sensor s, Event e) {
        if (e.getActionType().isTypeOf(EventActionType.UPDATE)) {
            sb.append(":");
            ActivationParameter[] activationParameters = s.getActivationParametersFromEvent(e);
            if (activationParameters != null) {
                sb.append('{');
                sb.append("\"actParams\"");
                sb.append(':');
                JSONUtils.appendValue(sb, activationParameters);
                sb.append('}');
            } else {
                sb.append("null");
            }
        }
    }

    static {
        if (EventSourceType.values().length > 31) {
            throw new RuntimeException("Too many EventSourceTypes, not enough bits");
        }
        for (EventSourceType e : EventSourceType.values()) {
            e.mAllTypeBits = e.mExactTypeBit = 1 << e.ordinal();
        }
        NOUN.setSuperType(INSTRUMENTATION_NODE);
        SENSOR.setSuperType(INSTRUMENTATION_NODE);
        EVENT_SENSOR.setSuperType(SENSOR);
        PHASE_SENSOR.setSuperType(SENSOR);
        ANONYMOUS_PHASE_SENSOR.setSuperType(SENSOR);
        STATE_SENSOR.setSuperType(SENSOR);
        ROLLUP_SENSOR.setSuperType(SENSOR);
    }
}

