/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dfw.common.ApplicationContext;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.impl.incident.WrapperException;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;

public class IncidentFacts
implements Serializable {
    private static ApplicationContext s_appCtx;
    private String m_productType;
    private String m_productId;
    private String m_instanceId;
    private String m_problemKey;
    private String m_description;
    private String m_executionContextId;
    private String m_componentId;
    private String m_moduleId;
    private String m_appName;
    private boolean m_isEvaluateDiagnosticRules = true;
    private boolean m_isUnhandledExceptionIncident = false;
    private boolean m_isSynchronous = true;
    private long m_incidentTime;
    private ErrorMessage m_errorMessage;
    private LogRecord m_logRecord;
    private Throwable m_throwable;
    private Incident.IncidentSource m_incidentSource;
    private Map<IncidentFactProperty, List<String>> m_secondaryFacts;
    private List<DiagnosticDump> m_dumps = null;
    private List<DumpInfo> m_namedDumps = null;
    private Map<String, String> m_contextValues = new HashMap<String, String>();
    private static final long serialVersionUID = 0L;

    private IncidentFacts(Incident.IncidentSource source, long incidentTime) {
        if (source == null) {
            throw new IllegalArgumentException("Invalid argument: source=" + (Object)((Object)source));
        }
        this.m_incidentSource = source;
        this.m_incidentTime = incidentTime != 0L ? incidentTime : System.currentTimeMillis();
        this.m_secondaryFacts = new HashMap<IncidentFactProperty, List<String>>();
    }

    public static IncidentFacts createSystemIncidentFacts(long incidentTime, ErrorMessage message, String componentId, String moduleId) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid arguments message=" + message);
        }
        IncidentFacts facts = new IncidentFacts(Incident.IncidentSource.SYSTEM, incidentTime);
        facts.setErrorMessage(message);
        facts.setComponentModuleId(componentId, moduleId);
        return facts;
    }

    public static IncidentFacts createUnhandledExceptionIncidentFacts(long incidentTime, String appName, String componentId, String moduleId, boolean isSynchronous, Throwable unhandled) {
        if (unhandled == null) {
            throw new IllegalArgumentException("Invalid arguments unhandled=" + unhandled);
        }
        IncidentFacts facts = new IncidentFacts(Incident.IncidentSource.SYSTEM, incidentTime);
        facts.setApplicationName(appName);
        facts.setThrowable(unhandled);
        facts.setComponentModuleId(componentId, moduleId);
        facts.setSynchronous(isSynchronous);
        facts.m_isUnhandledExceptionIncident = true;
        try {
            facts.generateProblemKey();
        }
        catch (Throwable e) {
            LoggerFactory.getFrameworkLogger().log(Level.FINE, "failure generating Incident Problem Key", e);
            facts.m_problemKey = ErrorMessage.SystemErrorMessage.UNHANDLED_EXCEPTION_ERROR_MESSAGE.getErrorMessage().getOriginalErrorMessageId() + " [" + unhandled.getClass().getName() + "]";
        }
        return facts;
    }

    public static IncidentFacts createManualIncidentFacts(long incidentTime) {
        IncidentFacts facts = new IncidentFacts(Incident.IncidentSource.MANUAL, incidentTime);
        facts.setSynchronous(false);
        return facts;
    }

    public long getIncidentTime() {
        return this.m_incidentTime;
    }

    public Incident.IncidentSource getIncidentSource() {
        return this.m_incidentSource;
    }

    public void setContextValue(String name, String value) {
        if (name == null) {
            return;
        }
        if (value != null) {
            this.m_contextValues.put(name, value);
        } else {
            this.m_contextValues.remove(name);
        }
    }

    public String getContextValue(String name) {
        return this.m_contextValues.get(name);
    }

    public Map<String, String> getContextValues() {
        return Collections.unmodifiableMap(this.m_contextValues);
    }

    public void setSynchronous(boolean isSynchronous) {
        this.m_isSynchronous = isSynchronous;
    }

    public boolean isSynchronous() {
        return this.m_isSynchronous;
    }

    public void setErrorMessage(ErrorMessage msg) {
        this.m_errorMessage = msg;
    }

    public ErrorMessage getErrorMessage() {
        return this.m_errorMessage != null ? this.m_errorMessage : ErrorMessage.SystemErrorMessage.DEFAULT_ERROR_MESSAGE.getErrorMessage();
    }

    public void setExecutionContextId(String id) {
        if (id != null && id.length() == 0) {
            return;
        }
        this.m_executionContextId = id;
    }

    public String getExecutionContextId() {
        return this.m_executionContextId;
    }

    public void setLogRecord(LogRecord logRecord) {
        this.m_logRecord = logRecord;
    }

    public LogRecord getLogRecord() {
        return this.m_logRecord;
    }

    public void setDescription(String description) {
        if (description != null && description.length() == 0) {
            return;
        }
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setApplicationName(String appName) {
        if (this.m_isUnhandledExceptionIncident) {
            throw new IllegalArgumentException("setApplicationName should not be called on unhandled exception IncidentFacts instances");
        }
        if (appName != null && appName.length() == 0) {
            return;
        }
        this.m_appName = appName;
    }

    public String getApplicationName() {
        return this.m_appName;
    }

    public void setThrowable(Throwable throwable) {
        if (this.m_isUnhandledExceptionIncident) {
            throw new IllegalArgumentException("setThrowable should not be called on unhandled exception IncidentFacts instances");
        }
        this.m_throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public void setComponentModuleId(String componentId, String moduleId) {
        this.m_componentId = componentId;
        this.m_moduleId = moduleId;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public String getModuleId() {
        return this.m_moduleId;
    }

    public void setADRHome(String productType, String productId, String instanceId) {
        if (productType == null || productType.length() == 0 || productId == null || productId.length() == 0 || instanceId == null || instanceId.length() == 0) {
            throw new IllegalArgumentException("Invalid arguments: productType=" + productType + " productId=" + productId + " instanceId=" + instanceId);
        }
        this.m_productType = productType;
        this.m_productId = productId;
        this.m_instanceId = instanceId;
    }

    public String getProductType() {
        return this.m_productType;
    }

    public String getProductId() {
        return this.m_productId;
    }

    public String getInstanceId() {
        return this.m_instanceId;
    }

    public boolean isEvaluateDiagnosticRules() {
        return this.m_isEvaluateDiagnosticRules;
    }

    public void setEvaluateDiagnosticRules(boolean evaluateRules) {
        this.m_isEvaluateDiagnosticRules = evaluateRules;
    }

    public String getProblemKey() {
        if (this.m_problemKey == null) {
            this.generateProblemKey();
        }
        return this.m_problemKey;
    }

    public void setProblemKey(String problemKey) {
        this.m_problemKey = problemKey;
    }

    public void addDiagnosticDump(DiagnosticDump dump) {
        if (dump == null) {
            return;
        }
        if (this.m_dumps == null) {
            this.m_dumps = new ArrayList<DiagnosticDump>(1);
        }
        this.m_dumps.add(dump);
    }

    public List<DiagnosticDump> getDiagnosticDumps() {
        return this.m_dumps;
    }

    public void addNamedDiagnosticDump(String dumpName, Map<String, Serializable> args, String appName) {
        if (dumpName == null) {
            return;
        }
        if (this.m_namedDumps == null) {
            this.m_namedDumps = new ArrayList<DumpInfo>(1);
        }
        this.m_namedDumps.add(new DumpInfo(dumpName, args, appName));
    }

    public List<DumpInfo> getNamedDiagnosticDumps() {
        return this.m_namedDumps;
    }

    public void addProperty(IncidentFactProperty property, String ... value) {
        if (property == null || value == null || value.length == 0) {
            return;
        }
        List<String> propVals = this.m_secondaryFacts.get((Object)property);
        if (propVals == null) {
            propVals = new ArrayList<String>();
        }
        for (String val : value) {
            propVals.add(val);
        }
        this.m_secondaryFacts.put(property, propVals);
    }

    public Set<IncidentFactProperty> getIncidentFactPropertyNames() {
        return this.m_secondaryFacts.keySet();
    }

    public List<String> getIncidentFactPropertyValues(IncidentFactProperty property) {
        return this.m_secondaryFacts.get((Object)property);
    }

    private void generateProblemKey() {
        if (this.m_isUnhandledExceptionIncident) {
            this.m_problemKey = this.generateUnhandledExceptionProblemKey();
        } else {
            this.m_problemKey = this.getErrorMessage().getErrorFacility() != null ? this.getErrorMessage().getOriginalErrorMessageId() : ErrorMessage.SystemErrorMessage.DEFAULT_ERROR_MESSAGE.getErrorMessage().getOriginalErrorMessageId();
            if (this.m_componentId != null || this.m_moduleId != null || this.m_incidentSource.equals((Object)Incident.IncidentSource.MANUAL)) {
                this.m_problemKey = this.m_problemKey + " ";
            }
            if (this.m_componentId != null) {
                this.m_problemKey = this.m_problemKey + "[" + this.m_componentId + "]";
            }
            if (this.m_moduleId != null) {
                this.m_problemKey = this.m_problemKey + "[" + this.m_moduleId + "]";
            }
            if (this.m_incidentSource.equals((Object)Incident.IncidentSource.MANUAL)) {
                this.m_problemKey = this.m_problemKey + "[" + (Object)((Object)this.m_incidentSource) + "]";
            }
        }
        if (this.m_problemKey != null) {
            this.m_problemKey = this.m_problemKey.replaceAll("\\p{Cntrl}", "");
        }
    }

    private String generateUnhandledExceptionProblemKey() {
        String problemKey = null;
        Throwable deepThrowable = this.m_throwable;
        Throwable nested = null;
        if (this.m_appName == null && s_appCtx != null) {
            this.m_appName = s_appCtx.getApplicationName();
        }
        while ((nested = deepThrowable.getCause()) != null) {
            deepThrowable = nested;
        }
        String exceptionName = null;
        exceptionName = deepThrowable instanceof WrapperException ? ((WrapperException)deepThrowable).getDeepestExceptionName() : deepThrowable.getClass().getName();
        if (deepThrowable instanceof OutOfMemoryError || exceptionName.equals("java.lang.OutOfMemoryError")) {
            this.setErrorMessage(ErrorMessage.SystemErrorMessage.OOME_ERROR_MESSAGE.getErrorMessage());
            problemKey = ErrorMessage.SystemErrorMessage.OOME_ERROR_MESSAGE.getErrorMessage().getOriginalErrorMessageId() + " [java.lang.OutOfMemoryError]";
        } else if (deepThrowable instanceof SQLException || exceptionName.startsWith("java.sql")) {
            String sqlErrorCode = this.getSQLErrorCode(deepThrowable);
            if (sqlErrorCode == null) {
                sqlErrorCode = exceptionName;
            }
            String errorText = "unhandled java.lang.SQLException detected";
            String data = " [" + sqlErrorCode + "]";
            String sourceRef = this.getSourceRef(deepThrowable, true);
            if (sourceRef != null) {
                data = data + "[" + sourceRef + "]";
            }
            if (this.m_appName != null) {
                data = data + "[" + this.m_appName + "]";
            }
            problemKey = ErrorMessage.SystemErrorMessage.SQL_EXCEPTION_ERROR_MESSAGE.getErrorMessage().getOriginalErrorMessageId() + data;
            this.setErrorMessage(ErrorMessage.SystemErrorMessage.SQL_EXCEPTION_ERROR_MESSAGE.getErrorMessage(errorText + data));
        } else {
            String errorText = "unhandled exception detected";
            String data = " [" + exceptionName + "]";
            String sourceRef = this.getSourceRef(deepThrowable, false);
            if (sourceRef != null) {
                data = data + "[" + sourceRef + "]";
            }
            if (this.m_appName != null) {
                data = data + "[" + this.m_appName + "]";
            }
            problemKey = ErrorMessage.SystemErrorMessage.UNHANDLED_EXCEPTION_ERROR_MESSAGE.getErrorMessage().getOriginalErrorMessageId() + data;
            this.setErrorMessage(ErrorMessage.SystemErrorMessage.UNHANDLED_EXCEPTION_ERROR_MESSAGE.getErrorMessage(errorText + data));
        }
        return problemKey;
    }

    private String getSQLErrorCode(Throwable deepThrowable) {
        String sqlErrorCode = null;
        if (deepThrowable instanceof WrapperException) {
            sqlErrorCode = ((WrapperException)deepThrowable).getDeepestSQLErrorCode();
        } else {
            String msg = deepThrowable.getMessage();
            if (msg != null && msg.length() > 0) {
                int idx1 = (msg = msg.trim()).indexOf(":");
                if (idx1 <= 0) {
                    idx1 = msg.indexOf(" ");
                }
                if (idx1 > 0) {
                    try {
                        ErrorMessage errMsg = new ErrorMessage(msg.substring(0, idx1));
                        if (errMsg != null) {
                            sqlErrorCode = errMsg.getOriginalErrorMessageId();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        LoggerFactory.getFrameworkLogger().log(Level.FINEST, "unable to extract error message ID from exception string: " + msg, e);
                    }
                }
            }
        }
        return sqlErrorCode;
    }

    private String getSourceRef(Throwable deepThrowable, boolean skipJDBC) {
        String sourceRef = null;
        if (deepThrowable instanceof WrapperException) {
            sourceRef = ((WrapperException)deepThrowable).getDeepestSourceRef(skipJDBC);
        } else {
            String oracleRef = null;
            String weblogicRef = null;
            String anyRef = null;
            for (StackTraceElement element : deepThrowable.getStackTrace()) {
                if (!(!element.getClassName().startsWith("oracle.") || skipJDBC && element.getClassName().startsWith("oracle.jdbc"))) {
                    oracleRef = element.getClassName() + "." + element.getMethodName();
                    break;
                }
                if (element.getClassName().startsWith("weblogic.")) {
                    weblogicRef = element.getClassName() + "." + element.getMethodName();
                    continue;
                }
                anyRef = element.getClassName() + "." + element.getMethodName();
            }
            sourceRef = oracleRef != null ? oracleRef : (weblogicRef != null ? weblogicRef : anyRef);
        }
        return sourceRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[problemKey=");
        sb.append(this.getProblemKey());
        sb.append(" incidentSource=");
        sb.append((Object)this.m_incidentSource);
        sb.append(" incidentTime=");
        sb.append(new Date(this.m_incidentTime).toString());
        sb.append(" errorMessage=");
        sb.append(this.m_errorMessage);
        sb.append(" executionContextId=");
        sb.append(this.m_executionContextId);
        for (IncidentFactProperty name : this.getIncidentFactPropertyNames()) {
            sb.append(" propertyName=");
            sb.append((Object)name);
            sb.append("{");
            boolean first = true;
            for (String value : this.getIncidentFactPropertyValues(name)) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(value);
                first = true;
            }
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }

    @Deprecated
    public static synchronized void setApplicationContext(ApplicationContext appCtx) {
        s_appCtx = appCtx;
    }

    public class DumpInfo {
        private String m_dumpName;
        private Map<String, Serializable> m_args;
        private String m_appName;

        DumpInfo(String dumpName, Map<String, Serializable> args, String appName) {
            this.m_dumpName = dumpName;
            this.m_args = args;
            this.m_appName = appName;
        }

        public String getDumpName() {
            return this.m_dumpName;
        }

        public Map<String, Serializable> getDumpArguments() {
            return this.m_args;
        }

        public String getApplicationName() {
            return this.m_appName;
        }
    }

    public static enum IncidentFactProperty {
        PROBLEM_IMPACT_PROP,
        INCIDENT_TIME_PROP;

        private static final long serialVersionUID = 0L;

        public static final IncidentFactProperty getProperty(IncidentFactKeyword keyword) {
            switch (keyword) {
                case PROBLEM_IMPACT: {
                    return PROBLEM_IMPACT_PROP;
                }
                case INCIDENT_TIME: {
                    return INCIDENT_TIME_PROP;
                }
            }
            return null;
        }
    }

    public static enum IncidentFactKeyword {
        ECID,
        PROBLEM_IMPACT,
        INCIDENT_TIME,
        MESSAGE_ID,
        COMPONENT_ID,
        MODULE_ID;

        private static final long serialVersionUID = 0L;

        public static IncidentFactKeyword getIncidentFactKeyword(String keyword) {
            try {
                return IncidentFactKeyword.valueOf(keyword.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

