/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.ApplicationContext;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpManager;
import oracle.dfw.impl.incident.DiagnosticRules;
import oracle.dfw.impl.incident.DumpAction;
import oracle.dfw.impl.incident.IncidentActions;
import oracle.dfw.impl.incident.LogWrapper;
import oracle.dfw.impl.incident.RuleActions;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.InvalidRulesException;

public class DiagnosticRulesManager {
    private Map<String, DiagnosticRules> m_sysRules = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, DiagnosticRules>> m_appRules = Collections.synchronizedMap(new HashMap());
    private volatile boolean m_shutdown;
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private ApplicationContext m_appContext;
    private DumpManager m_dumpManager;

    public DiagnosticRulesManager(ApplicationContext appContext, DumpManager dumpManager) {
        this.m_appContext = appContext;
        this.m_dumpManager = dumpManager;
    }

    public void registerRules(Reader rules, String rulesId, boolean systemScope, String appName) throws InvalidRulesException {
        if (this.m_shutdown) {
            return;
        }
        if (rules == null || rulesId == null || rulesId.length() == 0) {
            throw new IllegalArgumentException("Invalid arguments rules=" + rules + " rulesId=" + rulesId);
        }
        DiagnosticRules diagRules = DiagnosticRules.createRules(rules);
        if (diagRules != null) {
            if (systemScope) {
                this.m_sysRules.put(rulesId, diagRules);
            } else {
                if (appName == null) {
                    appName = this.getApplicationName();
                }
                if (appName != null) {
                    Map<String, DiagnosticRules> appRules = this.m_appRules.get(appName);
                    if (appRules == null) {
                        appRules = Collections.synchronizedMap(new HashMap());
                        this.m_appRules.put(appName, appRules);
                    }
                    appRules.put(rulesId, diagRules);
                } else {
                    this.m_sysRules.put(rulesId, diagRules);
                }
            }
            if (this.m_logger.isLoggable(Level.FINE)) {
                StringBuilder buf = new StringBuilder();
                buf.append("registering rules \"");
                buf.append(rulesId);
                buf.append("\" as ");
                if (!systemScope && appName != null) {
                    buf.append("scoped to application \"");
                    buf.append(appName);
                    buf.append("\"");
                } else if (!systemScope && appName == null) {
                    buf.append("system scoped since application name cannot be determined");
                } else {
                    buf.append("system scoped");
                }
                this.m_logger.fine(buf.toString());
            }
        }
    }

    public void unregisterRules(String rulesId, boolean systemScope, String appName) {
        if (this.m_shutdown) {
            return;
        }
        if (rulesId != null) {
            if (systemScope) {
                this.m_sysRules.remove(rulesId);
            } else {
                Map<String, DiagnosticRules> appRules;
                if (appName == null) {
                    appName = this.getApplicationName();
                }
                if (appName != null && (appRules = this.m_appRules.get(appName)) != null) {
                    appRules.remove(rulesId);
                    if (appRules.size() == 0) {
                        this.m_appRules.remove(appName);
                    }
                }
            }
        }
        this.m_logger.fine("unregistering rules \"" + rulesId + "\"");
    }

    public List<String> getSystemRuleIds() {
        if (this.m_shutdown) {
            return null;
        }
        return new ArrayList<String>(this.m_sysRules.keySet());
    }

    public Map<String, List<String>> getApplicationRuleIds() {
        if (this.m_shutdown) {
            return null;
        }
        HashMap<String, List<String>> appRuleIds = new HashMap<String, List<String>>();
        for (Map.Entry<String, Map<String, DiagnosticRules>> appRules : this.m_appRules.entrySet()) {
            appRuleIds.put(appRules.getKey(), new ArrayList<String>(appRules.getValue().keySet()));
        }
        return appRuleIds;
    }

    public String getRuleDefinition(String rulesId, String appName) {
        if (this.m_shutdown) {
            return null;
        }
        DiagnosticRules rules = null;
        if (rulesId != null) {
            if (appName == null || appName.length() == 0) {
                rules = this.m_sysRules.get(rulesId);
            } else {
                Map<String, DiagnosticRules> appRules = this.m_appRules.get(appName);
                if (appRules != null) {
                    rules = appRules.get(rulesId);
                }
            }
        }
        return rules != null ? rules.toString() : null;
    }

    boolean evaluateLogConditions(LogWrapper log) {
        Map<String, DiagnosticRules> appRules;
        if (this.m_shutdown) {
            return false;
        }
        for (DiagnosticRules rules : this.m_sysRules.values()) {
            if (!rules.evaluateLogConditions(log)) continue;
            return true;
        }
        String appName = this.getApplicationName();
        if (appName != null && (appRules = this.m_appRules.get(appName)) != null) {
            for (DiagnosticRules rules : appRules.values()) {
                if (!rules.evaluateLogConditions(log)) continue;
                return true;
            }
        }
        return false;
    }

    public IncidentActions evaluateRules(IncidentFacts facts, String adrHome, String incidentId, String incidentPath) throws InvalidRulesException {
        Map<String, DiagnosticRules> appRules;
        String appName;
        if (this.m_shutdown) {
            return null;
        }
        IncidentActions actions = new IncidentActions(adrHome, incidentId, incidentPath);
        for (DiagnosticRules rules : this.m_sysRules.values()) {
            this.evaluateActions(null, rules.getDefaultActions(), facts, actions);
            this.evaluateActions(null, rules.evaluateRules(facts), facts, actions);
        }
        String string = appName = facts.getApplicationName() != null ? facts.getApplicationName() : this.getApplicationName();
        if (appName != null && (appRules = this.m_appRules.get(appName)) != null) {
            for (DiagnosticRules rules : appRules.values()) {
                this.evaluateActions(appName, rules.getDefaultActions(), facts, actions);
                this.evaluateActions(appName, rules.evaluateRules(facts), facts, actions);
            }
        }
        return actions;
    }

    private void evaluateActions(String appName, RuleActions ruleActions, IncidentFacts facts, IncidentActions actions) {
        if (ruleActions == null) {
            return;
        }
        for (DumpAction dumpAction : ruleActions.getDumpActions()) {
            this.createDumpContext(dumpAction, facts, appName, actions);
        }
    }

    private void createDumpContext(DumpAction action, IncidentFacts facts, String appName, IncidentActions actions) {
        DiagnosticDump dump = null;
        if (appName != null) {
            dump = this.m_dumpManager.getDump(action.getDumpName(), false, appName);
        }
        if (dump == null) {
            appName = null;
            dump = this.m_dumpManager.getDump(action.getDumpName(), true, null);
        }
        if (dump == null) {
            return;
        }
        boolean runSynchronously = false;
        if (!facts.isSynchronous() && (action.runSynchronously() || dump.getRunMode() == DiagnosticDump.DumpRunMode.SYNCHRONOUS)) {
            return;
        }
        if (facts.isSynchronous() && (action.runSynchronously() || dump.getRunMode() == DiagnosticDump.DumpRunMode.SYNCHRONOUS || dump.getRunMode() == DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS)) {
            runSynchronously = true;
        }
        int factCount = action.getFactBasedArguments().size();
        boolean forceCreation = false;
        if (factCount > 0) {
            boolean multiFactValid = true;
            HashMap<String, String> args = null;
            for (Map.Entry<String, String> arg : action.getFactBasedArguments().entrySet()) {
                String name = arg.getKey();
                String value = arg.getValue();
                List<String> factValues = this.getFactBasedArg(value, facts);
                if (factValues != null && factValues.size() > 0) {
                    for (String fact : factValues) {
                        if (args == null || factCount == 1) {
                            args = new HashMap<String, String>(1);
                            args.putAll(action.getLiteralBasedArguments());
                            if (action.getContextBasedArguments().size() > 0) {
                                for (Map.Entry<String, String> contextArg : action.getContextBasedArguments().entrySet()) {
                                    String contextValue = facts.getContextValue(contextArg.getValue());
                                    if (contextValue == null) continue;
                                    args.put(contextArg.getKey(), contextValue);
                                }
                            }
                        }
                        args.put(name, fact);
                        if (factCount != 1) continue;
                        DumpContext dumpContext = this.createDumpContext(action.getDumpName(), args, appName, actions, facts);
                        actions.addDumpContext(dumpContext, runSynchronously);
                    }
                    continue;
                }
                if (factCount == 1 && !action.isMandatory(name)) {
                    forceCreation = true;
                    continue;
                }
                if (!action.isMandatory(name)) continue;
                multiFactValid = false;
                this.m_logger.log(Level.FINER, "Value for fact based argument " + name + " not found.");
            }
            if (factCount > 1 && multiFactValid || forceCreation) {
                DumpContext dumpContext = this.createDumpContext(action.getDumpName(), args, appName, actions, facts);
                actions.addDumpContext(dumpContext, runSynchronously);
            }
        } else {
            HashMap<String, String> args = new HashMap<String, String>();
            if (action.getLiteralBasedArguments().size() > 0) {
                args.putAll(action.getLiteralBasedArguments());
            }
            if (action.getContextBasedArguments().size() > 0) {
                for (Map.Entry<String, String> contextArg : action.getContextBasedArguments().entrySet()) {
                    String value = facts.getContextValue(contextArg.getValue());
                    if (value == null) continue;
                    args.put(contextArg.getKey(), value);
                }
            }
            DumpContext dumpContext = this.createDumpContext(action.getDumpName(), args, appName, actions, facts);
            actions.addDumpContext(dumpContext, runSynchronously);
        }
    }

    private DumpContext createDumpContext(String dumpName, HashMap<String, String> args, String appName, IncidentActions actions, IncidentFacts facts) {
        DumpContext ctx = DumpContext.createDumpContext(dumpName, actions.getADRHome(), actions.getIncidentId(), actions.getIncidentPath(), facts);
        for (Map.Entry<String, String> dumpArg : args.entrySet()) {
            ctx.addArgument(dumpArg.getKey(), (Serializable)((Object)dumpArg.getValue()));
        }
        if (appName != null) {
            ctx.setAppScoped(appName);
        }
        return ctx;
    }

    private List<String> getFactBasedArg(String factName, IncidentFacts facts) {
        IncidentFacts.IncidentFactKeyword keyword = IncidentFacts.IncidentFactKeyword.getIncidentFactKeyword(factName);
        ArrayList<String> args = new ArrayList<String>();
        if (keyword != null) {
            switch (keyword) {
                case ECID: {
                    this.addArgIfNotNull(facts.getExecutionContextId(), args);
                    break;
                }
                case INCIDENT_TIME: {
                    this.addArgIfNotNull(String.valueOf(facts.getIncidentTime()), args);
                    break;
                }
                case COMPONENT_ID: {
                    this.addArgIfNotNull(facts.getComponentId(), args);
                    break;
                }
                case MODULE_ID: {
                    this.addArgIfNotNull(facts.getModuleId(), args);
                    break;
                }
                case MESSAGE_ID: {
                    if (facts.getErrorMessage() == null) break;
                    this.addArgIfNotNull(facts.getErrorMessage().getErrorFacilityAndNumber(), args);
                    break;
                }
            }
            IncidentFacts.IncidentFactProperty prop = IncidentFacts.IncidentFactProperty.getProperty(keyword);
            if (prop != null && facts.getIncidentFactPropertyValues(prop) != null) {
                args.addAll(facts.getIncidentFactPropertyValues(prop));
            }
        }
        return args;
    }

    private void addArgIfNotNull(String value, ArrayList<String> args) {
        if (value != null) {
            args.add(value);
        }
    }

    public void shutdown() {
        if (this.m_shutdown) {
            return;
        }
        this.m_shutdown = true;
    }

    private String getApplicationName() {
        return this.m_appContext != null ? this.m_appContext.getApplicationName() : null;
    }
}

