/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.dfw.dump.DumpContext;

public class IncidentActions {
    private ArrayList<DumpContext> m_synchronousDumpContextList = new ArrayList();
    private ArrayList<DumpContext> m_asynchronousDumpContextList = new ArrayList();
    private ArrayList<String> m_dumpContextIndex = new ArrayList();
    private String m_adrHome;
    private String m_incidentId;
    private String m_incidentPath;

    IncidentActions(String adrHome, String incidentId, String incidentPath) {
        this.m_adrHome = adrHome;
        this.m_incidentId = incidentId;
        this.m_incidentPath = incidentPath;
    }

    public List<DumpContext> getSynchronousDumpContextList() {
        return this.m_synchronousDumpContextList;
    }

    public List<DumpContext> getAsynchronousDumpContextList() {
        return this.m_asynchronousDumpContextList;
    }

    void addDumpContext(DumpContext context, boolean runSynchronously) {
        String index = context.getDumpName() + context.getAppName();
        Enumeration<String> e = context.getArguments().enumerateKeys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            index = index + name + context.getArguments().getString(name);
        }
        if (!this.m_dumpContextIndex.contains(index)) {
            this.m_dumpContextIndex.add(index);
            if (runSynchronously) {
                this.m_synchronousDumpContextList.add(context);
            } else {
                this.m_asynchronousDumpContextList.add(context);
            }
        }
    }

    public String getADRHome() {
        return this.m_adrHome;
    }

    public String getIncidentId() {
        return this.m_incidentId;
    }

    public String getIncidentPath() {
        return this.m_incidentPath;
    }
}

