/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.util.EnumSet;
import java.util.Locale;
import java.util.logging.Level;
import oracle.dfw.common.ArgumentDescriptorMap;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.dump.InvalidDumpContextException;
import oracle.dfw.impl.common.ArgumentDescriptorMapImpl;

public abstract class DiagnosticDump
implements Comparable<DiagnosticDump> {
    private ArgumentDescriptorMapImpl m_mandatoryArguments = new ArgumentDescriptorMapImpl();
    private ArgumentDescriptorMapImpl m_optionalArguments = new ArgumentDescriptorMapImpl();

    public abstract String getOwner();

    public abstract String getName();

    public String getFullDumpName() {
        return this.getOwner() + "." + this.getName();
    }

    public abstract EnumSet<DiagnosticsCategory> getDumpCategories();

    public abstract String getDumpDescription();

    public String getDumpDescription(Locale locale) {
        return this.getDumpDescription();
    }

    public DumpRunMode getRunMode() {
        return DumpRunMode.ASYNCHRONOUS;
    }

    public void validateDumpContext(DumpContext context) throws InvalidDumpContextException {
        for (String argName : context.validateDumpArguments(this.getMandatoryArguments(), this.getOptionalArguments())) {
            LoggerFactory.getFrameworkLogger().log(Level.INFO, "DFW-40006", new String[]{argName, this.getFullDumpName()});
        }
    }

    public abstract DumpResult executeDump(DumpContext var1) throws DumpExecutionException, DumpWriterException;

    @Deprecated
    public final void defineArgument(String name, ArgumentType type, boolean isRequired, String desc) {
        if (name == null || name.length() == 0 || type == null || desc == null || desc.length() == 0) {
            return;
        }
        if (isRequired) {
            this.m_mandatoryArguments.put(name, type, desc);
        } else {
            this.m_optionalArguments.put(name, type, desc);
        }
    }

    public final void defineArgument(String name, ArgumentType type, boolean isRequired, String resourceBundle, String resourceKey) {
        if (name == null || name.length() == 0 || type == null || resourceBundle == null || resourceBundle.length() == 0 || resourceKey == null || resourceKey.length() == 0) {
            return;
        }
        if (isRequired) {
            this.m_mandatoryArguments.put(name, type, resourceBundle, resourceKey);
        } else {
            this.m_optionalArguments.put(name, type, resourceBundle, resourceKey);
        }
    }

    public final ArgumentDescriptorMap getMandatoryArguments() {
        return this.m_mandatoryArguments;
    }

    public final ArgumentDescriptorMap getOptionalArguments() {
        return this.m_optionalArguments;
    }

    @Override
    public int compareTo(DiagnosticDump dump) {
        if (dump == null) {
            return -1;
        }
        return this.getName().compareTo(dump.getName());
    }

    public String toString() {
        return "[dump owner=" + this.getOwner() + " : dump name=" + this.getName() + "]";
    }

    public static enum DumpRunMode {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        SYNCHRONOUS_ASYNCHRONOUS;

    }
}

