/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dms.util.DMSNLSupport;

public class TableName {
    private Map<String, String> mParams;
    private String mNounTypeName;
    private String mNormalName;
    private static final char JEE_SCOPE_TO_MBEAN_NAME_SEPARATOR = ':';
    private static final char CORE_NAME_2_QUERY_STRING_SEPARATOR = '|';
    private static final char QUERY_STRING_PARAMETER_2_PARAMETER_SEPARATOR = ',';
    private static final char QUERY_STRING_PARAMETER_2_VALUE_SEPARATOR = ';';
    private static final String QUERY_STRING_PARAMETER_2_PARAMETER_SEPARATOR_String = ",";
    public static final String SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME = "scopingParamType";
    public static final String SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_VALUE_CTX = "ctx";
    public static final String SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_VALUE_ACT = "act";
    public static final String SCOPING_PARAM_NAME_QUERY_STRING_PARAM_NAME = "scopingParamName";
    public static final String SCOPING_PARAM_VALUE_QUERY_STRING_PARAM_NAME = "scopingParamValue";
    public static final SortedSet<String> sLegalQueryStringParameterNames = new TreeSet<String>();

    private TableName(String nounTypeName, Map<String, String> parameters, String standardName) {
        this.mNounTypeName = nounTypeName;
        this.mParams = parameters;
        this.mNormalName = standardName;
    }

    public static TableName createName(String nounTypeName, Map<String, String> parameters) {
        if (parameters != null) {
            String s;
            for (String parameterName : parameters.keySet()) {
                if (sLegalQueryStringParameterNames.contains(parameterName)) continue;
                throw new IllegalArgumentException(DMSNLSupport.getString("TableName.IllegalTableName"));
            }
            if (!(!parameters.containsKey(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME) && !parameters.containsKey(SCOPING_PARAM_NAME_QUERY_STRING_PARAM_NAME) || parameters.containsKey(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME) && parameters.containsKey(SCOPING_PARAM_NAME_QUERY_STRING_PARAM_NAME))) {
                throw new IllegalArgumentException(DMSNLSupport.getString("TableName.IllegalTableName"));
            }
            if (!(!parameters.containsKey(SCOPING_PARAM_VALUE_QUERY_STRING_PARAM_NAME) || parameters.containsKey(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME) && parameters.containsKey(SCOPING_PARAM_NAME_QUERY_STRING_PARAM_NAME))) {
                throw new IllegalArgumentException(DMSNLSupport.getString("TableName.IllegalTableName"));
            }
            if (parameters.containsKey(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME) && !SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_VALUE_CTX.equals(s = parameters.get(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME)) && !SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_VALUE_ACT.equals(s)) {
                throw new IllegalArgumentException(DMSNLSupport.getString("TableName.IllegalTableName"));
            }
        }
        StringBuilder sb = new StringBuilder(nounTypeName);
        if (parameters != null && parameters.size() > 0) {
            boolean appendInterParamSeparator = false;
            for (String key : sLegalQueryStringParameterNames) {
                String value = parameters.get(key);
                if (value == null) continue;
                if (appendInterParamSeparator) {
                    sb.append(',');
                } else {
                    sb.append('|');
                    appendInterParamSeparator = true;
                }
                sb.append(key);
                sb.append(';');
                sb.append(value);
            }
        }
        String standardName = sb.toString();
        TableName retVal = new TableName(nounTypeName, parameters, standardName);
        return retVal;
    }

    public static TableName parseName(String tableName) {
        int loc = 0;
        int tableNameLen = tableName.length();
        String nounTypeName = null;
        Map<String, String> allParams = null;
        loc = tableName.indexOf(124);
        if (loc > 0 && loc < tableNameLen) {
            nounTypeName = tableName.substring(0, loc);
            allParams = TableName.parseQueryString(tableName.substring(loc + 1));
            if (allParams.size() == 0) {
                throw new IllegalArgumentException(DMSNLSupport.getString("TableName.IllegalTableName"));
            }
        } else {
            nounTypeName = tableName;
            allParams = new HashMap<String, String>(1);
        }
        TableName retVal = TableName.createName(nounTypeName, allParams);
        return retVal;
    }

    public String getNounTypeName() {
        return this.mNounTypeName;
    }

    public Map<String, String> getParameters() {
        return this.mParams;
    }

    public String getNormalName() {
        return this.mNormalName;
    }

    public boolean isParamScopedMetrics() {
        boolean retVal = false;
        if (this.mParams.containsKey(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isParamScopedMetrics(String s) {
        TableName tn = TableName.parseName(s);
        boolean isPSM = tn.isParamScopedMetrics();
        return isPSM;
    }

    private static Map<String, String> parseQueryString(String queryString) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(queryString, QUERY_STRING_PARAMETER_2_PARAMETER_SEPARATOR_String);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] parsedToken = TableName.parseQueryStringParameterToken(token);
            if (parsedToken[0] == null) continue;
            retVal.put(parsedToken[0], parsedToken[1]);
        }
        return retVal;
    }

    private static String[] parseQueryStringParameterToken(String token) {
        String paramName = null;
        String paramValue = null;
        int splitPoint = token.indexOf(59);
        if (splitPoint > 0) {
            paramName = token.substring(0, splitPoint);
            if (splitPoint + 1 < token.length() - 1) {
                paramValue = token.substring(splitPoint + 1, token.length());
            }
        }
        return new String[]{paramName, paramValue};
    }

    static {
        sLegalQueryStringParameterNames.add(SCOPING_PARAM_TYPE_QUERY_STRING_PARAM_NAME);
        sLegalQueryStringParameterNames.add(SCOPING_PARAM_NAME_QUERY_STRING_PARAM_NAME);
        sLegalQueryStringParameterNames.add(SCOPING_PARAM_VALUE_QUERY_STRING_PARAM_NAME);
    }
}

