/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;

public class EventType {
    private EventActionType mActionType;
    private EventSourceType mSourceType;
    private int mHashCode;
    private static int sNumOfSourceTypes = EventSourceType.values().length;
    private static int sNumOfActionTypes = EventActionType.values().length;
    private static final EventActionType[] NO_ACTIONS = new EventActionType[0];
    private static final EventActionType[] INSTRUMENTATION_NODE_ACTIONS = new EventActionType[0];
    private static final EventActionType[] NOUN_ACTIONS = new EventActionType[]{EventActionType.CREATE, EventActionType.DELETE, EventActionType.TYPE_CHANGE};
    private static final EventActionType[] SENSOR_ACTIONS = new EventActionType[0];
    private static final EventActionType[] EVENT_SENSOR_ACTIONS = new EventActionType[]{EventActionType.CREATE, EventActionType.DELETE, EventActionType.METRIC_SELECTION_CHANGED, EventActionType.UPDATE};
    private static final EventActionType[] PHASE_SENSOR_ACTIONS = new EventActionType[]{EventActionType.CREATE, EventActionType.DELETE, EventActionType.METRIC_SELECTION_CHANGED, EventActionType.START, EventActionType.STOP, EventActionType.ABORT};
    private static final EventActionType[] ANONYMOUS_PHASE_SENSOR_ACTIONS = new EventActionType[]{EventActionType.START, EventActionType.ABORT};
    private static final EventActionType[] STATE_SENSOR_ACTIONS = new EventActionType[]{EventActionType.CREATE, EventActionType.DELETE, EventActionType.METRIC_SELECTION_CHANGED, EventActionType.UPDATE};
    private static final EventActionType[] ROLLUP_SENSOR_ACTIONS = new EventActionType[]{EventActionType.CREATE, EventActionType.DELETE, EventActionType.METRIC_SELECTION_CHANGED};
    private static final EventActionType[] EXECUTION_CONTEXT_ACTIONS = new EventActionType[]{EventActionType.START, EventActionType.STOP, EventActionType.SUSPEND};
    private static final EventActionType[] HTTP_REQUEST_ACTIONS = new EventActionType[]{EventActionType.START, EventActionType.STOP, EventActionType.CONTEXT_CHANGED};
    private static EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private static EventType[][] ALL_VALID_EVENT_TYPES_SPARSE2D = new EventType[sNumOfSourceTypes][sNumOfActionTypes];
    private static EventType[] ALL_VALID_EVENT_TYPES_1D;
    public static final String EVENT_LIST_MEMBER_SEPARATOR = ",";
    public static final String EVENT_SOURCE_AND_ACTION_SEPARATOR = ":";
    public static final long INITIALIZATION_EVENT_TIME = -121L;

    public EventType(EventSourceType sourceType, EventActionType actionType) {
        if (sourceType == null || actionType == null) {
            throw new IllegalArgumentException("No parameter can be null: sourceType=" + (Object)((Object)sourceType) + ", actionType=" + (Object)((Object)actionType));
        }
        this.mActionType = actionType;
        this.mSourceType = sourceType;
        this.mHashCode = this.mActionType.hashCode() ^ this.mSourceType.hashCode();
    }

    public static EventType getEventType(EventSourceType sourceType, EventActionType actionType) {
        EventType retVal = ALL_VALID_EVENT_TYPES_SPARSE2D[sourceType.ordinal()][actionType.ordinal()];
        if (retVal == null) {
            throw new IllegalArgumentException("EventType " + (Object)((Object)sourceType) + " : " + (Object)((Object)actionType) + " does not exist.");
        }
        return retVal;
    }

    public static boolean isValidType(EventSourceType sourceType, EventActionType actionType) {
        boolean retVal = false;
        EventType et = ALL_VALID_EVENT_TYPES_SPARSE2D[sourceType.ordinal()][actionType.ordinal()];
        if (et != null) {
            retVal = true;
        }
        return retVal;
    }

    public EventActionType getActionType() {
        return this.mActionType;
    }

    public EventSourceType getSourceType() {
        return this.mSourceType;
    }

    public static EventType[] getAllEventTypes() {
        EventType[] retVal = Arrays.copyOf(ALL_VALID_EVENT_TYPES_1D, ALL_VALID_EVENT_TYPES_1D.length);
        return retVal;
    }

    public static EventType[] parseList(String eventListAsString) {
        ArrayList<EventType> eventCollection = null;
        EventType[] retVal = EMPTY_EVENT_TYPE_ARRAY;
        if (eventListAsString == null || eventListAsString.length() == 0) {
            return retVal;
        }
        eventListAsString = eventListAsString.toUpperCase().replaceAll("\\s", "");
        StringTokenizer st = new StringTokenizer(eventListAsString, EVENT_LIST_MEMBER_SEPARATOR);
        eventCollection = new ArrayList<EventType>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            EventType[] eventTypes = null;
            try {
                eventTypes = EventType.parse(token);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("The string \"" + eventListAsString + "\" can not be parsed: " + iae.getMessage());
            }
            if (eventTypes == null) continue;
            for (EventType eventType : eventTypes) {
                ArrayList ar = new ArrayList();
                if (eventCollection.contains(eventType)) {
                    throw new IllegalArgumentException("The string \"" + eventListAsString + "\" can not be parsed: Contains implicitly" + " or explicitly duplicated event types.");
                }
                eventCollection.add(eventType);
            }
        }
        if (eventCollection != null) {
            retVal = eventCollection.toArray(new EventType[eventCollection.size()]);
        }
        return retVal;
    }

    private static EventType[] parse(String token) {
        boolean bad = false;
        String sourceTypeString = null;
        String actionTypeString = null;
        if (token == null || token == "") {
            bad = true;
        } else {
            String[] et = token.split(EVENT_SOURCE_AND_ACTION_SEPARATOR);
            if (et.length > 0 && et[0].length() == 0) {
                bad = true;
            } else if (et.length == 1) {
                sourceTypeString = et[0];
            } else if (et.length == 2) {
                sourceTypeString = et[0];
                actionTypeString = et[1];
            } else {
                bad = true;
            }
        }
        if (bad) {
            throw new IllegalArgumentException("The string '" + token + "' represents " + "neither a source type, nor a pair of source type and action type.");
        }
        if (actionTypeString != null && actionTypeString.length() == 0) {
            actionTypeString = null;
        }
        EventSourceType sourceType = null;
        EventActionType actionType = null;
        try {
            sourceType = EventSourceType.valueOf(sourceTypeString);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("The source type '" + sourceTypeString + "' inferred from the string '" + token + "' does not record a recognized source type.");
        }
        HashSet<EventType> eventTypeCollection = new HashSet<EventType>(8);
        if (actionTypeString == null) {
            if (sourceType.isSuperType()) {
                List<EventSourceType> sourceTypeSubTypes = sourceType.getSubTypeList();
                for (EventSourceType eventSourceType : sourceTypeSubTypes) {
                    EventActionType[] at;
                    for (EventActionType eventActionType : at = EventType.getActionTypesForSourceType(eventSourceType, false)) {
                        eventTypeCollection.add(new EventType(eventSourceType, eventActionType));
                    }
                }
            } else {
                EventActionType[] at;
                for (EventActionType eventActionType : at = EventType.getActionTypesForSourceType(sourceType, false)) {
                    eventTypeCollection.add(new EventType(sourceType, eventActionType));
                }
            }
        } else {
            try {
                actionType = EventActionType.valueOf(actionTypeString);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("The action type '" + actionTypeString + "' inferred from string '" + token + "' does not record a recognized action type.");
            }
            if (EventType.isValidType(sourceType, actionType)) {
                eventTypeCollection.add(new EventType(sourceType, actionType));
            } else {
                throw new IllegalArgumentException("The combination of source type " + sourceTypeString + " and action type " + actionTypeString + " is not supported");
            }
        }
        return eventTypeCollection.toArray(new EventType[eventTypeCollection.size()]);
    }

    protected static void addEventTypes(Collection<EventType> eventTypeCollection, EventSourceType sourceType, EventActionType actionType) {
        EventSourceType[] sourceTypeArray = sourceType == null ? EventSourceType.values() : new EventSourceType[]{sourceType};
        for (EventSourceType srcType : sourceTypeArray) {
            EventActionType[] validActionTypes = EventType.getActionTypesForSourceType(srcType, false);
            EventActionType[] actionTypeArray = actionType == null ? EventType.getActionTypesForSourceType(srcType, false) : new EventActionType[]{actionType};
            for (EventActionType actType : actionTypeArray) {
                if (actType.in(validActionTypes)) {
                    EventType eventType = EventType.getEventType(srcType, actType);
                    eventTypeCollection.add(eventType);
                }
                for (EventActionType actionSubType : actType.getSubTypeList()) {
                    EventType.addEventTypes(eventTypeCollection, srcType, actionSubType);
                }
            }
            for (EventSourceType sourceSubType : srcType.getSubTypeList()) {
                EventType.addEventTypes(eventTypeCollection, sourceSubType, actionType);
            }
        }
    }

    public static boolean arraysEqual(EventType[] arr1, EventType[] arr2) {
        boolean retVal = false;
        if (arr1 != null && arr2 != null && arr1.length == arr2.length) {
            HashSet<EventType> s1 = new HashSet<EventType>();
            for (EventType et : arr1) {
                s1.add(et);
            }
            for (EventType et : arr2) {
                s1.remove(et);
            }
            HashSet<EventType> s2 = new HashSet<EventType>();
            for (EventType et : arr2) {
                s2.add(et);
            }
            for (EventType et : arr1) {
                s2.remove(et);
            }
            retVal = s1.size() == 0 && s2.size() == 0;
        } else if (arr1 == null && arr2 == null) {
            retVal = true;
        }
        return retVal;
    }

    public String toString() {
        return (Object)((Object)this.mSourceType) + EVENT_SOURCE_AND_ACTION_SEPARATOR + (Object)((Object)this.mActionType);
    }

    public boolean equals(Object that) {
        return that != null && that instanceof EventType && this.getActionType().equals((Object)((EventType)that).getActionType()) && this.getSourceType().equals((Object)((EventType)that).getSourceType());
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public static boolean eventTypeArrayContains(EventType[] eventTypeArray, EventSourceType sourceType, EventActionType actionType) {
        boolean retVal = false;
        if (eventTypeArray != null) {
            for (EventType eventType : eventTypeArray) {
                if (eventType == null || !eventType.getActionType().isTypeOf(actionType) || !eventType.getSourceType().isTypeOf(sourceType)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private static EventActionType[] getActionTypesForSourceType(EventSourceType sourceType, boolean expandImpliedTypes) {
        EventActionType[] retVal = NO_ACTIONS;
        if (expandImpliedTypes && sourceType.getSubTypeList(false) != null) {
            HashSet<EventActionType> validActionTypes = new HashSet<EventActionType>(8);
            List<EventSourceType> subSourceTypesList = sourceType.getSubTypeList(false);
            for (EventSourceType subSourceType : subSourceTypesList) {
                for (EventActionType at : EventType.getActionTypesForSourceType(subSourceType, true)) {
                    validActionTypes.add(at);
                }
            }
            retVal = new EventActionType[validActionTypes.size()];
            int i = 0;
            for (EventActionType at : validActionTypes) {
                retVal[i++] = at;
            }
        } else {
            switch (sourceType) {
                case INSTRUMENTATION_NODE: {
                    retVal = INSTRUMENTATION_NODE_ACTIONS;
                    break;
                }
                case NOUN: {
                    retVal = NOUN_ACTIONS;
                    break;
                }
                case SENSOR: {
                    retVal = SENSOR_ACTIONS;
                    break;
                }
                case EVENT_SENSOR: {
                    retVal = EVENT_SENSOR_ACTIONS;
                    break;
                }
                case PHASE_SENSOR: {
                    retVal = PHASE_SENSOR_ACTIONS;
                    break;
                }
                case ANONYMOUS_PHASE_SENSOR: {
                    retVal = ANONYMOUS_PHASE_SENSOR_ACTIONS;
                    break;
                }
                case STATE_SENSOR: {
                    retVal = STATE_SENSOR_ACTIONS;
                    break;
                }
                case ROLLUP_SENSOR: {
                    retVal = ROLLUP_SENSOR_ACTIONS;
                    break;
                }
                case EXECUTION_CONTEXT: {
                    retVal = EXECUTION_CONTEXT_ACTIONS;
                    break;
                }
                case HTTP_REQUEST: {
                    retVal = HTTP_REQUEST_ACTIONS;
                }
            }
        }
        return retVal;
    }

    public static EventType[] getEventTypesForSourceTypes(EventSourceType[] sourceTypeArray) {
        HashSet<EventType> eventTypeCollection = new HashSet<EventType>();
        for (EventSourceType sourceType : sourceTypeArray) {
            EventType.addEventTypes(eventTypeCollection, sourceType, null);
        }
        EventType[] retVal = eventTypeCollection.toArray(new EventType[eventTypeCollection.size()]);
        return retVal;
    }

    @Deprecated
    public static String v1TypeConversion(String eventListAsString) {
        StringBuffer retVal = new StringBuffer();
        StringTokenizer st = new StringTokenizer(eventListAsString, EVENT_LIST_MEMBER_SEPARATOR);
        boolean bad = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token == null || token == "") {
                bad = true;
                break;
            }
            String[] et = token.split(EVENT_SOURCE_AND_ACTION_SEPARATOR);
            if (et.length > 0 && et[0].length() == 0) {
                bad = true;
                break;
            }
            if (et.length == 1) {
                if (retVal.length() > 0) {
                    retVal.append(EVENT_LIST_MEMBER_SEPARATOR);
                }
                retVal.append(et[0]);
                continue;
            }
            if (et.length == 2) {
                if (retVal.length() > 0) {
                    retVal.append(EVENT_LIST_MEMBER_SEPARATOR);
                }
                try {
                    EventSourceType.valueOf(et[0]);
                    EventActionType.valueOf(et[1]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The event type source \"" + et[0] + "\" or value " + et[1] + " are not valid and cannot be upgraded");
                }
                retVal.append(EventType.expandSuperType(et[0], et[1]));
                continue;
            }
            bad = true;
            break;
        }
        if (bad) {
            throw new IllegalArgumentException("The string '" + eventListAsString + "' represents neither a source type, nor a pair of source type and action type.");
        }
        return EventType.stripDupeSourceTypes(retVal.toString());
    }

    private static String stripDupeSourceTypes(String eventListAsString) {
        boolean exists;
        StringBuffer retVal = new StringBuffer();
        StringTokenizer st = new StringTokenizer(eventListAsString, EVENT_LIST_MEMBER_SEPARATOR);
        ArrayList<String[]> eventTypes = new ArrayList<String[]>();
        while (st.hasMoreTokens()) {
            eventTypes.add(st.nextToken().split(EVENT_SOURCE_AND_ACTION_SEPARATOR));
        }
        ArrayList<String> eventTypesNoAction = new ArrayList<String>();
        ArrayList<String[]> eventTypesSourceAction = new ArrayList<String[]>();
        for (String[] eventType : eventTypes) {
            if (eventType.length == 1) {
                exists = false;
                for (String source : eventTypesNoAction) {
                    if (!eventType[0].equals(source)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                eventTypesNoAction.add(eventType[0]);
                continue;
            }
            if (eventType.length != 2) continue;
            exists = false;
            for (String[] et : eventTypesSourceAction) {
                if (!eventType[0].equals(et[0]) || !eventType[1].equals(et[1])) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            eventTypesSourceAction.add(eventType);
        }
        for (String source : eventTypesNoAction) {
            if (retVal.length() > 0) {
                retVal.append(EVENT_LIST_MEMBER_SEPARATOR);
            }
            retVal.append(source);
        }
        for (String[] et : eventTypesSourceAction) {
            exists = false;
            for (String source : eventTypesNoAction) {
                if (!et[0].equals(source)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            if (retVal.length() > 0) {
                retVal.append(EVENT_LIST_MEMBER_SEPARATOR);
            }
            retVal.append(et[0] + EVENT_SOURCE_AND_ACTION_SEPARATOR + et[1]);
        }
        if (retVal != null) {
            return retVal.toString();
        }
        return null;
    }

    private static String expandSuperType(String source, String action) {
        if (source == null) {
            throw new IllegalArgumentException("The source '" + source + "' is not recognised as a valid event type source");
        }
        source = source.toUpperCase();
        if (action == null) {
            return source;
        }
        action = action.toUpperCase();
        EventSourceType sourceType = null;
        StringBuffer sb = new StringBuffer();
        try {
            sourceType = EventSourceType.valueOf(source);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("The source type '" + source + "' does not record a recognized source type.");
        }
        List<EventSourceType> sourceTypeSubTypes = null;
        if (sourceType.isSuperType()) {
            sourceTypeSubTypes = sourceType.getSubTypeList(true);
        } else {
            sourceTypeSubTypes = new ArrayList<EventSourceType>();
            sourceTypeSubTypes.add(EventSourceType.valueOf(source));
        }
        EventActionType actionType = EventActionType.valueOf(action);
        ArrayList<EventActionType> actionTypeSubTypes = new ArrayList<EventActionType>();
        actionTypeSubTypes.addAll(actionType.getSubTypeList());
        actionTypeSubTypes.add(actionType);
        for (EventSourceType eventSourceType : sourceTypeSubTypes) {
            EventActionType[] at = EventType.getActionTypesForSourceType(eventSourceType, false);
            for (EventActionType eventActionType : actionTypeSubTypes) {
                if (!Arrays.asList(at).contains((Object)eventActionType)) continue;
                if (sb.length() > 0) {
                    sb.append(EVENT_LIST_MEMBER_SEPARATOR);
                }
                sb.append(eventSourceType.toString() + EVENT_SOURCE_AND_ACTION_SEPARATOR + (Object)((Object)eventActionType));
            }
        }
        return sb.toString();
    }

    static {
        LinkedList<EventType> allValidEventTypesList = new LinkedList<EventType>();
        for (EventSourceType sourceType : EventSourceType.values()) {
            for (EventActionType actionType : EventActionType.values()) {
                EventType et;
                if (!actionType.in(EventType.getActionTypesForSourceType(sourceType, false))) continue;
                EventType.ALL_VALID_EVENT_TYPES_SPARSE2D[sourceType.ordinal()][actionType.ordinal()] = et = new EventType(sourceType, actionType);
                allValidEventTypesList.add(et);
            }
        }
        ALL_VALID_EVENT_TYPES_1D = allValidEventTypesList.toArray(new EventType[allValidEventTypesList.size()]);
    }
}

