/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.BufferedReader;
import java.io.StringReader;
import oracle.dfw.incident.ErrorMessage;

public class WrapperException
extends Exception {
    private String m_exceptionName;
    private String m_stackTrace;
    private static String CAUSED_BY = "Caused By: ";
    private static String CAUSED_BY_LOWER = "Caused by: ";
    private static String AT_ORACLE = "at oracle.";
    private static String AT_ORACLE_JDBC = "at oracle.jdbc.";
    private static String AT_WEBLOGIC = "at weblogic.";
    private static String AT_ANYTHING = "at ";

    public WrapperException(String exceptionName, String stackTrace) {
        this.m_exceptionName = exceptionName;
        this.m_stackTrace = stackTrace;
    }

    public String getWrappedExceptionName() {
        return this.m_exceptionName;
    }

    public String getWrappedStackTrace() {
        return this.m_stackTrace;
    }

    public String getDeepestExceptionName() {
        String exceptionName = this.m_exceptionName;
        if (this.m_stackTrace != null) {
            int idx1 = this.m_stackTrace.lastIndexOf(CAUSED_BY);
            if (idx1 <= 0) {
                idx1 = this.m_stackTrace.lastIndexOf(CAUSED_BY_LOWER);
            }
            if (idx1 > 0) {
                int len = CAUSED_BY.length();
                int idx2 = this.m_stackTrace.indexOf(":", idx1 + len);
                int idx3 = this.m_stackTrace.indexOf("\n", idx1 + len);
                if (idx3 < idx2) {
                    idx2 = idx3;
                }
                if (idx2 > idx1) {
                    exceptionName = this.m_stackTrace.substring(idx1 + len, idx2);
                }
            }
        }
        return exceptionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeepestSourceRef(boolean skipJDBC) {
        String ref = null;
        String stack = this.m_stackTrace;
        if (stack != null) {
            int idx1 = stack.lastIndexOf(CAUSED_BY);
            if (idx1 <= 0) {
                idx1 = stack.lastIndexOf(CAUSED_BY_LOWER);
            }
            if (idx1 > 0) {
                stack = stack.substring(idx1);
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new StringReader(stack));
                String line = null;
                String oraRefLine = null;
                String weblogicRefLine = null;
                String anyRefLine = null;
                while ((line = br.readLine()) != null) {
                    if (!(!(line = line.trim()).startsWith(AT_ORACLE) || skipJDBC && line.startsWith(AT_ORACLE_JDBC))) {
                        oraRefLine = line;
                        break;
                    }
                    if (weblogicRefLine == null && line.startsWith(AT_WEBLOGIC)) {
                        weblogicRefLine = line;
                        continue;
                    }
                    if (anyRefLine != null || !line.startsWith(AT_ANYTHING)) continue;
                    anyRefLine = line;
                }
                if (oraRefLine != null) {
                    line = oraRefLine;
                } else if (weblogicRefLine != null) {
                    line = weblogicRefLine;
                } else if (anyRefLine != null) {
                    line = anyRefLine;
                }
                if (line != null) {
                    int idx2 = line.indexOf("(");
                    ref = idx2 > 0 ? line.substring(AT_ANYTHING.length(), idx2) : line.substring(AT_ANYTHING.length());
                }
            }
            catch (Throwable e) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return ref;
    }

    public String getDeepestSQLErrorCode() {
        String sqlErrorCode = null;
        if (this.m_stackTrace != null) {
            int len;
            int idx2;
            int idx1 = this.m_stackTrace.lastIndexOf(CAUSED_BY);
            if (idx1 <= 0) {
                idx1 = this.m_stackTrace.lastIndexOf(CAUSED_BY_LOWER);
            }
            if (idx1 > 0 && (idx2 = this.m_stackTrace.indexOf(":", idx1 + (len = CAUSED_BY.length()))) > idx1) {
                int idx3 = this.m_stackTrace.indexOf(":", idx2 + 1);
                if (idx3 <= 0) {
                    idx3 = this.m_stackTrace.indexOf(" ", idx2 + 1);
                }
                if (idx3 > 0) {
                    try {
                        ErrorMessage errMsg = new ErrorMessage(this.m_stackTrace.substring(idx2 + 1, idx3).trim());
                        if (errMsg != null) {
                            sqlErrorCode = errMsg.getOriginalErrorMessageId();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        return sqlErrorCode;
    }
}

