/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import oracle.dfw.common.ArgumentMap;
import oracle.dfw.dump.DumpResult;

public class IncidentDump
implements Serializable {
    private String m_dumpName;
    private String m_dumpArgsString;
    private String m_applicationName;
    private List<String> m_dumpFiles;
    private static final long serialVersionUID = 0L;

    public IncidentDump(DumpResult dump) {
        this.m_dumpName = dump.getDumpContext().getDumpName();
        this.m_dumpFiles = dump.getDumpFiles();
        this.m_applicationName = dump.getDumpContext().getAppName();
        ArgumentMap dumpArgs = dump.getDumpContext().getArguments();
        if (dumpArgs != null && dumpArgs.size() > 0) {
            StringBuilder argBuf = new StringBuilder();
            Enumeration<String> args = dumpArgs.enumerateKeys();
            while (args.hasMoreElements()) {
                String argName = args.nextElement();
                if (argBuf.length() > 0) {
                    argBuf.append(", ");
                }
                argBuf.append(argName);
                argBuf.append("=");
                argBuf.append(dumpArgs.getString(argName));
            }
            if (argBuf.length() > 0) {
                this.m_dumpArgsString = argBuf.toString();
            }
        }
    }

    public String getDumpName() {
        return this.m_dumpName;
    }

    public String getDumpArguments() {
        return this.m_dumpArgsString;
    }

    public List<String> getDumpFiles() {
        return this.m_dumpFiles;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }
}

